/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.operation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.config.model.JoinConfig;
import net.risedata.jdbc.operation.impl.SimpleOperation;
import net.risedata.jdbc.search.exception.FieldException;

public class Where {
    private StringBuilder sql;
    private List<Object> args;
    private Map<String, Object> excludeMap;
    private FieldConfig fc;
    private Map<String, Object> valueMap;
    private BeanConfig bc;

    public Where(StringBuilder sql, FieldConfig fc, Map<String, Object> valueMap, List<Object> args, Map<String, Object> excludeMap, BeanConfig bc) {
        this.excludeMap = excludeMap;
        this.sql = sql;
        this.fc = fc;
        this.valueMap = valueMap;
        this.args = args;
        this.bc = bc;
    }

    public Class<?> getBeanClass() {
        return this.bc.getCla();
    }

    public FieldConfig getFieldConfig() {
        return this.fc;
    }

    public String getCloum(String fieldName) {
        FieldConfig fc = this.bc.getField(fieldName);
        if (fc == null) {
            throw new FieldException("fieldName" + fieldName + "\u5728 bean" + this.bc.getCla() + "\u4e2d\u672a\u627e\u5230");
        }
        return fc.getColumn();
    }

    public Where add(Object args) {
        this.args.add(args);
        return this;
    }

    public Where in(Collection values, boolean bracket) {
        if (bracket) {
            this.sql.append("(");
        }
        boolean flag = false;
        for (Object object : values) {
            if (flag) {
                this.sql.append(",?");
            } else {
                flag = true;
                this.sql.append("?");
            }
            this.add(object);
        }
        if (bracket) {
            this.sql.append(")");
        }
        return this;
    }

    public Where in(Object[] values, boolean bracket) {
        if (bracket) {
            this.sql.append("(");
        }
        boolean flag = false;
        for (Object object : values) {
            if (flag) {
                this.sql.append(",?");
            } else {
                flag = true;
                this.sql.append("?");
            }
            this.add(object);
        }
        if (bracket) {
            this.sql.append(")");
        }
        return this;
    }

    public Where in(Collection values) {
        return this.in(values, true);
    }

    public JoinConfig getJoinConfig(Class<?> joinEntiry) {
        return this.bc.getJoin(joinEntiry);
    }

    public String getTableAs() {
        return this.bc.getTableAs();
    }

    public StringBuilder getSql() {
        return this.sql;
    }

    public StringBuilder append(CharSequence seq) {
        return this.sql.append(seq);
    }

    public Object getValue() {
        return SimpleOperation.getValue(this.fc, this.valueMap);
    }

    public Object getValue(String fieldName) {
        return this.valueMap.get(fieldName);
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public void removeExcludeField(String key) {
        this.excludeMap.remove(key);
    }
}

