/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.mapping.columns;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.annotations.factory.Factory;
import net.risedata.jdbc.commons.map.LMap;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.exception.InstanceException;
import net.risedata.jdbc.executor.search.SearchExecutor;
import net.risedata.jdbc.factory.impl.SpringApplicationFactory;
import net.risedata.jdbc.mapping.ColumnMapping;
import net.risedata.jdbc.repository.model.Type;
import net.risedata.jdbc.repository.parse.ReturnTypeFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Factory(value=SpringApplicationFactory.class)
public class OneToManyColumnMapping
implements ColumnMapping {
    private Field field;
    private String sourceId;
    private String targetId;
    private boolean isList;
    private Class<?> typeClass;
    @Autowired
    private SearchExecutor searchExecutor;

    public OneToManyColumnMapping() {
    }

    public OneToManyColumnMapping(Field field, String sourceId, String targetId, boolean isList, Class<?> typeClass, SearchExecutor searchExecutor) {
        this.field = field;
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.isList = isList;
        this.typeClass = typeClass;
        this.searchExecutor = searchExecutor;
    }

    @Override
    public ColumnMapping create(BeanConfig bc, Field field, String[] args) {
        if (args.length == 2) {
            Type type = ReturnTypeFactory.parseType(field.getGenericType().getTypeName());
            Class<?> typeClass = null;
            typeClass = type.isList() ? type.getGeneralClass() : type.getType();
            return new OneToManyColumnMapping(field, args[0], args[1], type.isList(), typeClass, this.searchExecutor);
        }
        throw new InstanceException("create OneToManyColumnMapping args \u9519\u8bef  ['\u5f53\u524d\u7c7b\u8fde\u63a5id','\u76ee\u6807\u7c7bid']");
    }

    @Override
    public void handle(Object value, BeanConfig bc) {
        try {
            if (this.isList) {
                List<?> list = this.searchExecutor.searchForList(this.typeClass, null, (Map<String, Object>)LMap.createMap((Object)this.targetId, (Object)bc.getValue(value, this.sourceId)), this.typeClass);
                this.field.set(value, list);
            } else {
                Object object = this.searchExecutor.findOne(this.typeClass, (Map<String, Object>)LMap.createMap((Object)this.targetId, (Object)bc.getValue(value, this.sourceId)), null, false, this.typeClass);
                this.field.set(value, object);
            }
        }
        catch (Exception e) {
            throw new InstanceException("\u5904\u7406\u4e00\u5bf9\u591a\u64cd\u4f5c\u51fa\u9519 " + e.getMessage());
        }
    }
}

