/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.mapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.exception.SqlExecutionException;
import net.risedata.jdbc.executor.set.SetValueExecutor;
import net.risedata.jdbc.executor.set.impl.FieldSetValueExecutor;
import net.risedata.jdbc.mapping.ColumnMapping;
import net.risedata.jdbc.mapping.HandleMapping;
import net.risedata.jdbc.mapping.LRowMapping;
import org.springframework.jdbc.core.RowMapper;

public class RowMapping<T>
implements RowMapper<T> {
    private Collection<FieldConfig> fields;
    private BeanConfig bc;
    private int[] isCloum;
    private LRowMapping<T> rowMapping;
    private static final SetValueExecutor<Field> SET_VALUE = new FieldSetValueExecutor();

    public RowMapping(BeanConfig bc, Collection<FieldConfig> fields) {
        this.fields = fields;
        this.isCloum = new int[fields.size()];
        this.bc = bc;
    }

    public RowMapping(BeanConfig bc, Collection<FieldConfig> fields, LRowMapping<T> roMapping) {
        this(bc, fields);
        this.rowMapping = roMapping;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        int index = 0;
        if (rowNum == 0) {
            for (FieldConfig fieldConfig : this.fields) {
                if (fieldConfig.isEntiry()) break;
                this.isCloum[index] = this.isExistColumn(rs, fieldConfig.getColumn()) ? 0 : 1;
                ++index;
            }
        }
        index = -1;
        Object o = null;
        try {
            o = this.bc.getConstructor().newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        Object ret = o;
        HandleMapping<?> hand = null;
        try {
            for (FieldConfig fieldConfig : this.fields) {
                if (this.isCloum[++index] == 1) continue;
                hand = fieldConfig.getHandle();
                try {
                    hand.handle(ret, fieldConfig.getSetValueField(), SET_VALUE, fieldConfig.getFieldType(), hand.getValue(rs, fieldConfig.getColumn()));
                }
                catch (SQLException e) {
                    throw new SqlExecutionException("\u51fa\u73b0sql\u5f02\u5e38 " + e.getMessage() + "  \u5bf9\u5e94\u7684\u5b57\u6bb5\u662f: " + fieldConfig.getColumn());
                }
            }
            if (this.rowMapping != null) {
                this.rowMapping.handle(ret, rs, rowNum);
            }
            if (this.bc.columnMappings() != null) {
                List<ColumnMapping> lists = this.bc.columnMappings();
                for (ColumnMapping columnMapping : lists) {
                    columnMapping.handle(ret, this.bc);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String ClobToString(Clob clob) throws SQLException, IOException {
        String reString = "";
        Reader is = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(is);
        String s = br.readLine();
        StringBuffer sb = new StringBuffer();
        while (s != null) {
            sb.append(s);
            s = br.readLine();
        }
        reString = sb.toString();
        if (br != null) {
            br.close();
        }
        if (is != null) {
            is.close();
        }
        return reString;
    }

    public boolean isExistColumn(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }
}

