/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.factory;

import java.lang.reflect.Field;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;
import net.risedata.jdbc.annotations.factory.Factory;
import net.risedata.jdbc.annotations.operation.Operate;
import net.risedata.jdbc.commons.TypeCheck;
import net.risedata.jdbc.factory.InstanceFactory;
import net.risedata.jdbc.factory.InstanceFactoryManager;
import net.risedata.jdbc.factory.impl.SingleInstanceFactory;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.OperationPack;
import net.risedata.jdbc.search.Operations;
import net.risedata.jdbc.search.exception.OperationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class OperationFactory {
    private static InstanceFactory defaultInstanceFactory;

    public static Operation getDefaultOperation(Field field) {
        Operate o = field.getAnnotation(Operate.class);
        if (o != null) {
            Object ao = OperationFactory.handleOperation(o);
            if (ao instanceof OperationPack) {
                throw new OperationException("The only operation requires a condition");
            }
            return (Operation)ao;
        }
        Id id = field.getAnnotation(Id.class);
        if (id != null) {
            return Operations.EQ;
        }
        if (TypeCheck.isNumber(field.getType())) {
            if (TypeCheck.isIntegerClass(field.getType())) {
                return Operations.EQ;
            }
            if (TypeCheck.isDoubleClass(field.getType())) {
                return Operations.GT;
            }
        } else {
            if (TypeCheck.isArrayType(field.getType())) {
                return Operations.IN;
            }
            if (field.getType() == String.class) {
                return Operations.LIKE;
            }
        }
        return Operations.EQ;
    }

    public static Object handleOperation(Operate operate) {
        Object op = operate.value().value;
        if (op == Operations.PLACEHOLDER) {
            if (operate.operation() != Operations.PLACEHOLDER.getClass()) {
                op = OperationFactory.getOperation(operate.operation());
            } else {
                throw new OperationException(" Use placeholders but do not define their own operations ");
            }
        }
        if (!StringUtils.isBlank((CharSequence)operate.expression())) {
            op = new OperationPack(operate.expression(), (Operation)op);
        }
        return op;
    }

    public static Operation getOperation(@NotNull Class<? extends Operation> operationClass) {
        assert (operationClass != null) : "operationClass is null";
        if (defaultInstanceFactory == null) {
            defaultInstanceFactory = InstanceFactoryManager.getInstanceFactory(SingleInstanceFactory.class);
        }
        Factory factory = (Factory)AnnotationUtils.findAnnotation(operationClass, Factory.class);
        try {
            if (factory == null) {
                return defaultInstanceFactory.getInstance(operationClass);
            }
            return InstanceFactoryManager.getInstanceFactory(factory.value()).getInstance(operationClass);
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                throw new OperationException("The specified factory is not registered factory manager");
            }
            throw new OperationException("create operation appear exception " + e.getMessage());
        }
    }

    public static InstanceFactory getDefaultInstanceFactory() {
        return defaultInstanceFactory;
    }

    public static void setDefaultInstanceFactory(InstanceFactory defaultInstanceFactory) {
        OperationFactory.defaultInstanceFactory = defaultInstanceFactory;
    }
}

