/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.factory;

import java.util.ArrayList;
import java.util.List;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.exception.ConfigException;
import net.risedata.jdbc.exception.InstanceException;
import net.risedata.jdbc.factory.BeanConfigFactory;

public class ObjectTransferFactory {
    public static <T> T transferInstance(Object transfer, Class<T> returnType) {
        BeanConfig transferConfig = BeanConfigFactory.getInstance(transfer);
        BeanConfig returnConfig = BeanConfigFactory.getInstance(returnType);
        if (transferConfig == null || returnConfig == null) {
            throw new ConfigException(transfer.getClass() + " or " + returnType + " is no bean config ");
        }
        List<FieldConfig> returnFieldConfigs = returnConfig.getAllFields();
        Object returnObject = null;
        try {
            returnObject = returnConfig.getConstructor().newInstance(new Object[0]);
            FieldConfig f = null;
            for (FieldConfig field : returnFieldConfigs) {
                f = transferConfig.getField(field.getFieldName());
                if (f == null || f.getFieldType() != field.getFieldType()) continue;
                field.getField().set(returnObject, f.getField().get(transfer));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InstanceException("An error occurred while creating the object " + e.getMessage());
        }
        return returnType.cast(returnObject);
    }

    public static <T> List<T> transferInstances(List<?> transfers, Class<T> returnType) {
        ArrayList<T> ret = new ArrayList<T>();
        for (Object object : transfers) {
            ret.add(ObjectTransferFactory.transferInstance(object, returnType));
        }
        return ret;
    }
}

