/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.factory;

import java.util.concurrent.ConcurrentHashMap;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.utils.ObjectBuilder;

public class ObjectBuilderFactory {
    private static ConcurrentHashMap<Class<?>, ThreadLocal<Object>> BEAN_MAP = new ConcurrentHashMap();
    private static Object THREAD_LOCK = new Object();

    public static <T> ObjectBuilder<T> builder(Class<T> objectClass) {
        BeanConfig bc = BeanConfigFactory.getInstance(objectClass);
        T value = ObjectBuilderFactory.getInstance(objectClass);
        return new ObjectBuilder<T>(bc, value);
    }

    public static <T> ObjectBuilder<T> newBuilder(Class<T> objectClass) {
        BeanConfig bc = BeanConfigFactory.getInstance(objectClass);
        Object value = null;
        try {
            value = objectClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ObjectBuilder<Object>(bc, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getInstance(Class<T> returnClass) {
        ThreadLocal<Object> threadLocal = ObjectBuilderFactory.getThreadLocal(returnClass);
        Object value = threadLocal.get();
        if (value == null) {
            ThreadLocal<Object> threadLocal2 = threadLocal;
            synchronized (threadLocal2) {
                value = threadLocal.get();
                if (value == null) {
                    try {
                        value = returnClass.newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    threadLocal.set(value);
                }
            }
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadLocal<Object> getThreadLocal(Class<?> classType) {
        ThreadLocal<Object> threadLocal = BEAN_MAP.get(classType);
        if (threadLocal == null) {
            Object object = THREAD_LOCK;
            synchronized (object) {
                threadLocal = BEAN_MAP.get(classType);
                if (threadLocal == null) {
                    threadLocal = new ThreadLocal();
                    BEAN_MAP.put(classType, threadLocal);
                }
            }
        }
        return threadLocal;
    }

    public static <T> ObjectBuilder<T> builder(Class<T> objectClass, String key, Object value) {
        ObjectBuilder<T> builder = ObjectBuilderFactory.builder(objectClass);
        return builder.set(key, value);
    }
}

