/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.factory;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import net.risedata.jdbc.annotations.factory.Factory;
import net.risedata.jdbc.exception.InstanceException;
import net.risedata.jdbc.factory.InstanceFactory;
import net.risedata.jdbc.factory.impl.MultitonInstanceFactory;
import net.risedata.jdbc.factory.impl.SingleInstanceFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class InstanceFactoryManager {
    private static final Map<Class<? extends InstanceFactory>, InstanceFactory> INSTANCEFACTORY_MAP = new HashMap<Class<? extends InstanceFactory>, InstanceFactory>();

    public static void init(@NotNull InstanceFactory factory) {
        assert (factory != null) : " factory is null";
        INSTANCEFACTORY_MAP.put(factory.getClass(), factory);
    }

    public static InstanceFactory getInstanceFactory(Class<? extends InstanceFactory> factoryClass) {
        assert (factoryClass != null) : " factory is null";
        return INSTANCEFACTORY_MAP.get(factoryClass);
    }

    public static <T> T getInstance(Class<T> type) {
        Factory factory = (Factory)AnnotationUtils.findAnnotation(type, Factory.class);
        try {
            if (factory != null) {
                InstanceFactory instanceFactory = InstanceFactoryManager.getInstanceFactory(factory.value());
                if (instanceFactory == null) {
                    throw new InstanceException("instance factory is null " + factory.value());
                }
                return instanceFactory.getInstance(type);
            }
            return InstanceFactoryManager.getInstanceFactory(MultitonInstanceFactory.class).getInstance(type);
        }
        catch (Exception e) {
            throw new InstanceException(type + " create instance error " + e.getMessage());
        }
    }

    static {
        InstanceFactoryManager.init(new SingleInstanceFactory());
        InstanceFactoryManager.init(new MultitonInstanceFactory());
    }
}

