/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.factory;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javassist.CtClass;
import javassist.CtMethod;
import net.risedata.jdbc.commons.exceptions.ParseException;
import net.risedata.jdbc.repository.model.ClassBuild;
import net.risedata.jdbc.repository.parse.MethodParseFactory;
import net.risedata.jdbc.repository.proxy.RepositoryCreateFactory;
import net.risedata.jdbc.utils.ClassUtils;

public class DynamicProxyFactory {
    public static <T> T getInstance(Class<T> type) {
        try {
            return DynamicProxyFactory.newProxyInstance(type);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T> T newProxyInstance(Class<T> interfaceClass) throws Throwable {
        ClassBuild proxy = RepositoryCreateFactory.create(interfaceClass);
        List<Class<?>> interfaces = ClassUtils.getInterfaces(interfaceClass);
        CtClass interfaceCc = proxy.getPool().get(interfaceClass.getName());
        ArrayList<CtMethod> ctMethods = new ArrayList<CtMethod>();
        for (Class<?> class1 : interfaces) {
            CtClass tempClass = proxy.getPool().get(class1.getName());
            proxy.getProxy().addInterface(tempClass);
            for (CtMethod method : tempClass.getDeclaredMethods()) {
                ctMethods.add(method);
            }
        }
        proxy.getProxy().addInterface(interfaceCc);
        Method[] methods = interfaceClass.getMethods();
        ctMethods.addAll(Arrays.asList(interfaceCc.getDeclaredMethods()));
        HashMap<CallSite, String> mothodBodyMap = new HashMap<CallSite, String>();
        for (int j = 0; j < methods.length; ++j) {
            String codeBody = MethodParseFactory.parseMethod(methods[j], proxy);
            if (codeBody == null) {
                throw new ParseException(methods[j] + " no parse");
            }
            mothodBodyMap.put((CallSite)((Object)(methods[j].getName() + methods[j].getParameterCount())), codeBody);
        }
        for (int i = 0; i < ctMethods.size(); ++i) {
            CtMethod newMethod = new CtMethod(((CtMethod)ctMethods.get(i)).getReturnType(), ((CtMethod)ctMethods.get(i)).getName(), ((CtMethod)ctMethods.get(i)).getParameterTypes(), proxy.getProxy());
            newMethod.setBody("{ " + (String)mothodBodyMap.get(newMethod.getName() + ((CtMethod)ctMethods.get(i)).getParameterTypes().length) + " }");
            proxy.getProxy().addMethod(newMethod);
        }
        Object instance = proxy.getProxy().toClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        RepositoryCreateFactory.instanceed(instance, proxy);
        return instance;
    }
}

