/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import net.risedata.jdbc.condition.Condition;
import net.risedata.jdbc.condition.parse.Parse;
import net.risedata.jdbc.condition.parse.impl.EQParse;
import net.risedata.jdbc.condition.parse.impl.GetValueParse;
import net.risedata.jdbc.condition.parse.impl.LikeParse;
import net.risedata.jdbc.condition.parse.impl.StringParse;
import net.risedata.jdbc.condition.parse.impl.ToStringParse;
import net.risedata.jdbc.condition.parse.impl.TypeParse;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.search.exception.IfHandleException;

public class ConditionProxyFactory {
    private static final List<Parse> PARSES = new ArrayList<Parse>();

    public static Condition getInstance(String expression, Class<?> beanClass) {
        String pare = ConditionProxyFactory.parseIf(expression, beanClass);
        try {
            return ConditionProxyFactory.newProxyInstance(Thread.currentThread().getContextClassLoader(), Condition.class, pare);
        }
        catch (Throwable e) {
            throw new IfHandleException(expression + "parse later " + pare + " expression error please check it " + e.getMessage() + " type :" + e);
        }
    }

    public static String parseIf(String expression, Class<?> beanClass) {
        StringBuilder parse = new StringBuilder("java.util.Map $value = (java.util.Map)$args[0];");
        BeanConfig bc = BeanConfigFactory.getInstance(beanClass);
        StringBuilder newexpression = new StringBuilder(expression);
        for (Parse p : PARSES) {
            Matcher m = p.getPattern().matcher(newexpression);
            while (m.find()) {
                String group = m.group();
                String temp = p.parse(group, bc, m);
                newexpression.replace(m.start(), m.end(), temp);
                m.reset(newexpression);
            }
        }
        parse.append("return " + newexpression + ";");
        return parse.toString();
    }

    private static <T> T newProxyInstance(ClassLoader loader, Class<T> interfaceClass, String methodBody) throws Throwable {
        ClassPool pool = ClassPool.getDefault();
        Random r = new Random();
        CtClass proxyCc = pool.makeClass("LProxy$" + r.nextInt() + "@" + r.nextInt());
        CtClass interfaceCc = pool.get(interfaceClass.getName());
        proxyCc.addInterface(interfaceCc);
        CtMethod[] ctMethods = interfaceCc.getDeclaredMethods();
        for (int i = 0; i < ctMethods.length; ++i) {
            CtMethod newMethod = new CtMethod(ctMethods[i].getReturnType(), ctMethods[i].getName(), ctMethods[i].getParameterTypes(), proxyCc);
            newMethod.setBody("{" + methodBody + "}");
            proxyCc.addMethod(newMethod);
        }
        Object proxy = proxyCc.toClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        return proxy;
    }

    static {
        PARSES.add(new GetValueParse());
        PARSES.add(new EQParse());
        PARSES.add(new TypeParse());
        PARSES.add(new ToStringParse());
        PARSES.add(new StringParse());
        PARSES.add(new LikeParse());
        ClassPool.getDefault().insertClassPath((ClassPath)new ClassClassPath(Condition.class));
    }
}

