/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.risedata.jdbc.config.Load;
import net.risedata.jdbc.config.model.BeanConfig;

public final class BeanConfigFactory {
    private static final Map<Object, BeanConfig> configs = new ConcurrentHashMap<Object, BeanConfig>();
    private static final Object lock = new Object();

    public static void putBeanConfig(Class<?> entiry, BeanConfig beanConfig) {
        configs.put(entiry, beanConfig);
    }

    public static void putBeanConfig(String id, BeanConfig beanConfig) {
        configs.put(id, beanConfig);
    }

    public static String getTableName(Class<?> type) {
        BeanConfig bc = BeanConfigFactory.getInstance(type);
        if (bc != null) {
            return bc.getTableName();
        }
        return null;
    }

    public static boolean has(Object id) {
        return configs.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanConfig getInstance(Object entiry) {
        BeanConfig config;
        Class<?> id = entiry;
        Class<?> entiryClass = entiry.getClass();
        if (entiryClass != Class.class && entiryClass != String.class) {
            id = entiry.getClass();
        }
        if ((config = configs.get(id)) == null && entiryClass != String.class) {
            Object object = lock;
            synchronized (object) {
                if (!configs.containsKey(id)) {
                    Load.loadBean(id);
                    config = configs.get(id);
                } else {
                    config = configs.get(id);
                }
            }
        }
        assert (config != null) : entiry + " Cannot load configuration";
        return config;
    }
}

