/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.executor.update.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.executor.jdbc.JDBC;
import net.risedata.jdbc.executor.jdbc.JdbcExecutor;
import net.risedata.jdbc.executor.update.UpdateExecutor;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.operation.Operation;

public class DefaultUpdateExecutor
extends JDBC
implements UpdateExecutor {
    private JdbcExecutor jdbcExecutor;

    public DefaultUpdateExecutor(JdbcExecutor jdbcExecutor) {
        this.jdbcExecutor = jdbcExecutor;
    }

    private static void createUpdateSql(StringBuilder sql, Collection<FieldConfig> fieldList, List<Object> args, Map<String, Object> valueMap) {
        sql.append(" SET");
        for (FieldConfig fieldConfig : fieldList) {
            if (fieldConfig.isId() || !fieldConfig.getDefaultOperation().update(fieldConfig, args, sql, valueMap)) continue;
            sql.append(",");
        }
        sql.delete(sql.length() - 1, sql.length());
    }

    public JdbcExecutor getJdbcExecutor() {
        return this.jdbcExecutor;
    }

    public void setJdbcExecutor(JdbcExecutor jdbcExecutor) {
        this.jdbcExecutor = jdbcExecutor;
    }

    @Override
    public int updateById(@NotNull Object id, Map<String, Object> valueMap, Map<String, Operation> operation) {
        BeanConfig bc = DefaultUpdateExecutor.getConfig(id);
        StringBuilder sql = new StringBuilder(50);
        sql.append("update " + bc.getTableName());
        ArrayList<Object> args = new ArrayList<Object>();
        valueMap = DefaultUpdateExecutor.createValueMap(id, valueMap, bc.getAllFields(), sql);
        if (bc.getCheckedField() != null && bc.getCheckedField().size() > 0 && DefaultUpdateExecutor.check(this.jdbcExecutor, bc, valueMap, true) == -1) {
            return -1;
        }
        DefaultUpdateExecutor.createUpdateSql(sql, bc.getAllFields(), args, valueMap);
        ArrayList<FieldConfig> fc = new ArrayList<FieldConfig>();
        for (FieldConfig fieldConfig : bc.getIdField()) {
            if (fieldConfig.isPlaceholder()) {
                if (operation == null || !operation.containsKey(fieldConfig.getFieldName())) continue;
                fc.add(fieldConfig);
                continue;
            }
            fc.add(fieldConfig);
        }
        DefaultUpdateExecutor.createWhereSql(bc, sql, fc, args, operation, valueMap);
        return this.jdbcExecutor.update(sql.toString(), args.toArray());
    }

    @Override
    public int updateById(@NotNull Object id, Map<String, Object> valueMap) {
        return this.updateById(id, valueMap, null);
    }

    @Override
    public int updateById(@NotNull Object id) {
        return this.updateById(id, null);
    }

    @Override
    public int update(@NotNull Object entiry, @NotNull List<String> wheres, Map<String, Object> valueMap, Map<String, Operation> operationMap) {
        BeanConfig bc = DefaultUpdateExecutor.getConfig(entiry);
        ArrayList<FieldConfig> whereField = new ArrayList<FieldConfig>();
        for (String where : wheres) {
            whereField.add(DefaultUpdateExecutor.getMap(where, bc.getFields(), FieldConfig.class));
        }
        HashSet<FieldConfig> setField = new HashSet<FieldConfig>(bc.getFieldlist());
        setField.removeAll(whereField);
        StringBuilder sql = new StringBuilder("update " + bc.getTableName());
        ArrayList<Object> args = new ArrayList<Object>();
        valueMap = DefaultUpdateExecutor.createValueMap(entiry, valueMap, bc.getFieldlist(), sql);
        DefaultUpdateExecutor.createUpdateSql(sql, setField, args, valueMap);
        DefaultUpdateExecutor.createWhereSql(bc, sql, whereField, args, operationMap, valueMap);
        return this.jdbcExecutor.update(sql.toString(), args.toArray());
    }

    @Override
    public int update(@NotNull Object entiry, @NotNull List<String> wheres, Map<String, Object> valueMap) {
        return this.update(entiry, wheres, valueMap, null);
    }

    @Override
    public int update(@NotNull Object entiry, @NotNull List<String> wheres) {
        return this.update(entiry, wheres, null);
    }

    @Override
    public int dynamicUpdate(String sql, Class<?> id, Object ... args) {
        BeanConfig bc = BeanConfigFactory.getInstance(id);
        if (bc != null && sql.contains("$TABLENAME")) {
            sql = sql.replace("$TABLENAME", bc.getTableName());
        }
        return this.jdbcExecutor.update(sql, args);
    }
}

