/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.executor.table.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.commons.LForEach;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.exception.ConfigException;
import net.risedata.jdbc.executor.jdbc.JDBC;
import net.risedata.jdbc.executor.jdbc.JdbcExecutor;
import net.risedata.jdbc.executor.table.TableExecutor;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.search.Operations;
import net.risedata.jdbc.search.Order;
import net.risedata.jdbc.search.exception.FieldException;
import net.risedata.jdbc.table.TableConfig;
import net.risedata.jdbc.table.TableField;
import net.risedata.jdbc.type.Types;
import org.apache.commons.lang3.StringUtils;

public class DefaultTableExecutor
extends JDBC
implements TableExecutor {
    private JdbcExecutor jdbcExecutor;

    public DefaultTableExecutor(JdbcExecutor jdbcExecutor) {
        this.jdbcExecutor = jdbcExecutor;
    }

    @Override
    public boolean hasTable(String tableName, String findTable) {
        Integer table = this.jdbcExecutor.queryForObject(String.format(findTable, tableName.toUpperCase()), Integer.class);
        return table > 0;
    }

    @Override
    public boolean deleteTable(String tableName, String findTable) {
        String drop = " drop table " + tableName;
        if (this.hasTable(tableName, findTable)) {
            this.jdbcExecutor.update(drop);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateTableName(String ovlTableName, String newName, String findTable) {
        String sql = "ALTER TABLE " + ovlTableName + " RENAME TO " + newName;
        if (this.hasTable(ovlTableName, findTable)) {
            this.jdbcExecutor.update(sql);
            return true;
        }
        return false;
    }

    @Override
    public boolean createTable(String findStr, TableConfig tc) {
        boolean has = this.deleteTable(tc.getTableName(), findStr);
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder sql = new StringBuilder(" create table " + tc.getTableName() + "( ");
        List<TableField> tableFields = tc.getFields();
        for (int i = 0; i < tableFields.size(); ++i) {
            sql.append(DefaultTableExecutor.createFieldString(tableFields.get(i)));
            if (i != tableFields.size() - 1) {
                sql.append(" , ");
                continue;
            }
            sql.append(" )");
        }
        sqls.add(sql.toString());
        for (TableField tableField : tableFields) {
            if (!StringUtils.isNotBlank((CharSequence)tableField.getAnnotation())) continue;
            sql = new StringBuilder("comment on column " + tc.getTableName() + "." + tableField.getFieldName() + " is '" + tableField.getAnnotation() + "'");
            sqls.add(sql.toString());
        }
        String[] sqlstr = new String[sqls.size()];
        this.jdbcExecutor.batchUpdate(sqls.toArray(sqlstr));
        return has;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConfig(TableConfig tc, String id, Map<String, Operation> operations, List<Order> orders) {
        if (StringUtils.isBlank((CharSequence)tc.getTableName()) || tc.getFields() == null || tc.getFields().size() < 1) {
            throw new ConfigException(id + "null table or fields ?");
        }
        BeanConfig bc = new BeanConfig();
        bc.setCountTableSql("select count(1) from " + tc.getTableName());
        bc.setSelectTableSql("select t.* from " + tc.getTableName() + " t");
        bc.setDelSql("delete from " + tc.getTableName());
        bc.setTableName(tc.getTableName());
        if (orders != null) {
            for (Order order : orders) {
                bc.addOrder(order);
            }
        }
        FieldConfig fc = null;
        Object var7_8 = null;
        List<TableField> tfs = tc.getFields();
        for (TableField tf : tfs) {
            void var7_12;
            Operation operation;
            fc = new FieldConfig();
            Operation operation2 = operation = operations == null ? Operations.getSqlTypeDefaultOperation(tf.getType()) : null;
            if (operation == null) {
                Operation operation3 = operations.get(tf.getFieldName()) == null ? Operations.getSqlTypeDefaultOperation(tf.getType()) : operations.get(tf.getFieldName());
            }
            fc.setColumn(tf.getFieldName());
            fc.setDefaultOperation((Operation)var7_12);
            fc.setId(tf.isKey());
            fc.setFieldType(Types.getSqlType(tf.getType()));
            fc.setFieldName(tf.getFieldName());
            bc.sort();
            bc.putField(tf.getFieldName(), fc);
        }
        BeanConfigFactory.putBeanConfig(id, bc);
    }

    @Override
    public void tableTransfer(String tableName, String transferName, Map<String, String> keyMapping, String where) {
        Object[] into = new String[keyMapping.keySet().size()];
        Object[] values = new String[keyMapping.keySet().size()];
        LForEach.ForEachUp(keyMapping.keySet(), (arg_0, arg_1) -> DefaultTableExecutor.lambda$tableTransfer$0((String[])into, (String[])values, keyMapping, arg_0, arg_1));
        String sql = "insert into " + tableName + "(" + StringUtils.join((Object[])into, (String)",") + ")  ( select " + StringUtils.join((Object[])values, (String)",") + " from " + transferName + (where == null ? "" : where) + ")";
        this.jdbcExecutor.update(sql);
    }

    private static String createFieldString(TableField tf) {
        StringBuilder sb = new StringBuilder(tf.getFieldName());
        if (StringUtils.isBlank((CharSequence)tf.getType()) || StringUtils.isBlank((CharSequence)tf.getFieldName())) {
            throw new FieldException(tf + " \u6ca1\u6709\u6307\u5b9a\u7c7b\u578b\u6216\u8005\u540d\u5b57 ");
        }
        sb.append("  " + tf.getType());
        if (tf.isKey()) {
            sb.append(" PRIMARY key ");
        } else if (tf.isRequired()) {
            sb.append(" not null ");
        } else if (StringUtils.isNotBlank((CharSequence)tf.getDefaultExpression())) {
            sb.append(" default(" + tf.getDefaultExpression() + ")");
        }
        return sb.toString();
    }

    private static /* synthetic */ void lambda$tableTransfer$0(String[] into, String[] values, Map keyMapping, String key, int index) {
        into[index] = key;
        values[index] = (String)keyMapping.get(key);
    }
}

