/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.executor.search.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.validation.constraints.NotNull;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.config.JdbcConfig;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.config.model.JoinConfig;
import net.risedata.jdbc.exception.ConfigException;
import net.risedata.jdbc.exception.SqlExecutionException;
import net.risedata.jdbc.executor.jdbc.JDBC;
import net.risedata.jdbc.executor.jdbc.JdbcExecutor;
import net.risedata.jdbc.executor.page.PageExecutor;
import net.risedata.jdbc.executor.search.SearchExecutor;
import net.risedata.jdbc.mapping.LRowMapping;
import net.risedata.jdbc.mapping.RowMapping;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.search.LPageable;
import net.risedata.jdbc.search.LSort;
import net.risedata.jdbc.search.Order;
import net.risedata.jdbc.utils.Sqlbuilder;
import org.springframework.dao.EmptyResultDataAccessException;

public class DefaultSearchExecutor
extends JDBC
implements SearchExecutor {
    private JdbcExecutor jdbcExecutor;
    private PageExecutor pageExecutor;
    private static final String COUNT_STR = "SELECT COUNT(1) COUNT ";

    public DefaultSearchExecutor(JdbcExecutor jdbcExecutor, PageExecutor pageExecutor) {
        if (pageExecutor == null) {
            throw new NullPointerException("pageExecutor is null");
        }
        this.jdbcExecutor = jdbcExecutor;
        this.pageExecutor = pageExecutor;
    }

    protected static void createOrders(List<Order> orders, StringBuilder sql, BeanConfig config, Map<String, Object> valueMap) {
        if (orders.size() > 0) {
            Order o = null;
            String column = null;
            FieldConfig fc = null;
            boolean flag = true;
            HashMap<String, Character> orderKeys = new HashMap<String, Character>();
            for (int i = 0; i < orders.size(); ++i) {
                o = orders.get(i);
                if (orderKeys.containsKey(o.getField()) || !o.If(valueMap)) continue;
                orderKeys.put(o.getField(), Character.valueOf('1'));
                fc = config.getField(o.getField());
                String string = column = fc != null ? fc.getColumn() : o.getField();
                if (flag) {
                    sql.append(" ORDER BY " + column + " " + o.getOrder());
                    flag = false;
                    continue;
                }
                sql.append(" , " + column + " " + o.getOrder());
            }
        }
    }

    protected static String parsePage(PageExecutor pageExecutor, StringBuilder sql, LPageable page, Object entiry, BeanConfig bc, Map<String, Object> valueMap, boolean isOrder) {
        LSort s;
        if (isOrder && (s = page.getSort()) != null) {
            List<Order> orders = s.getOrders();
            DefaultSearchExecutor.createOrders(orders, sql, bc, valueMap);
        }
        return pageExecutor.getPageSql(sql.toString(), page.getPageNo(), page.getPageSize());
    }

    protected static <T> List<T> queryForList(JdbcExecutor jdbcExecutor, String sql, Object[] args, Class<T> returnType, Collection<FieldConfig> fieldConfigs, boolean IsTransient, LRowMapping<T> romapping, BeanConfig bc) {
        try {
            if (bc != null && bc.getCla() != returnType) {
                bc = DefaultSearchExecutor.getConfig(returnType);
            }
            if (bc == null) {
                if (returnType == Map.class || returnType.isAssignableFrom(Map.class)) {
                    return jdbcExecutor.queryForListMap(sql, args);
                }
                return jdbcExecutor.queryForSimpleList(sql, returnType, args);
            }
            if (fieldConfigs != null) {
                fieldConfigs.addAll(bc.getRowMappingList());
                return jdbcExecutor.queryForList(sql, new RowMapping<T>(bc, fieldConfigs, romapping), args);
            }
            if (IsTransient) {
                return jdbcExecutor.queryForList(sql, new RowMapping<T>(bc, bc.getAllFields(), romapping), args);
            }
            return jdbcExecutor.queryForList(sql, new RowMapping<T>(bc, bc.getFieldlist(), romapping), args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SqlExecutionException("\u6267\u884csql \u51fa\u73b0\u5f02\u5e38sql:" + sql);
        }
    }

    protected static List<FieldConfig> createJoinSql(StringBuilder sql, BeanConfig bc, Map<String, Object> valueMap, boolean isAll) {
        List<JoinConfig> jcs = bc.getJoins();
        if (jcs == null) {
            return null;
        }
        ArrayList<? extends FieldConfig> fieldConfigs = null;
        int insertIndex = 7;
        for (JoinConfig joinConfig : jcs) {
            if (!joinConfig.isJoin(valueMap)) continue;
            if (fieldConfigs == null) {
                fieldConfigs = new ArrayList<FieldConfig>();
            }
            fieldConfigs.addAll(joinConfig.getFields());
            if (joinConfig.isFunction()) {
                sql.insert(insertIndex, joinConfig.getSql());
                insertIndex += joinConfig.getSql().length();
                continue;
            }
            sql.insert(insertIndex, joinConfig.getFieldSql() + ",");
            sql.append(joinConfig.getSql());
        }
        return fieldConfigs;
    }

    public JdbcExecutor getJdbcExecutor() {
        return this.jdbcExecutor;
    }

    public void setJdbcExecutor(JdbcExecutor jdbcExecutor) {
        this.jdbcExecutor = jdbcExecutor;
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, String field, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, boolean isOrder, boolean isNoJoin, LRowMapping<T> rowmapping, LSort sort, Class<T> returnType) {
        ArrayList<Object> args = new ArrayList<Object>();
        BeanConfig bc = DefaultSearchExecutor.getConfig(id);
        String selectsql = bc.getSelectTableSql(field, isTransient);
        StringBuilder sql = new StringBuilder(selectsql);
        valueMap = DefaultSearchExecutor.createValueMap(id, valueMap, bc.getFieldlist(), sql);
        List<FieldConfig> fields = null;
        if (!isNoJoin) {
            fields = DefaultSearchExecutor.createJoinSql(sql, bc, valueMap, isTransient);
        }
        DefaultSearchExecutor.createWhereSql(bc, sql, bc.getFieldlist(), args, operation, valueMap);
        if (isOrder && sort != null) {
            DefaultSearchExecutor.createOrders(this.doOrders(bc.getOrders(), sort.getOrders()), sql, bc, valueMap);
        } else if (isOrder) {
            DefaultSearchExecutor.createOrders(bc.getOrders(), sql, bc, valueMap);
        } else if (sort != null) {
            DefaultSearchExecutor.createOrders(sort.getOrders(), sql, bc, valueMap);
        }
        String selectSql = sql.toString();
        return DefaultSearchExecutor.queryForList(this.jdbcExecutor, selectSql, args.toArray(), returnType, fields, isTransient, rowmapping, bc);
    }

    private List<Order> doOrders(List<Order> base, List<Order> orders) {
        if (base == null) {
            Collections.sort(orders);
            return orders;
        }
        HashSet<Order> sets = new HashSet<Order>();
        sets.addAll(base);
        sets.addAll(orders);
        Collections.sort(orders);
        return Arrays.asList(sets.toArray(new Order[sets.size()]));
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, String field, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, LRowMapping<T> rowmapping, Class<T> returnType) {
        return this.searchForList(id, field, operation, valueMap, isTransient, true, rowmapping, returnType);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, String field, Map<String, Operation> operation, Map<String, Object> valueMap, LRowMapping<T> rowmapping, Class<T> returnType) {
        return this.searchForList(id, field, operation, valueMap, false, rowmapping, returnType);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, Map<String, Operation> operation, Map<String, Object> valueMap, LRowMapping<T> rowmapping, Class<T> returnType) {
        return this.searchForList(id, null, operation, valueMap, rowmapping, returnType);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, Map<String, Operation> operation, Map<String, Object> valueMap, Class<T> returnType) {
        return this.searchForList(id, operation, valueMap, null, returnType);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, Map<String, Operation> operation, Class<T> returnType) {
        return this.searchForList(id, operation, null, returnType);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, Class<T> returnType) {
        return this.searchForList(id, null, returnType);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, String field, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, boolean isOrder, LRowMapping<T> rowmapping, Class<T> returnType) {
        ArrayList<Object> args = new ArrayList<Object>();
        BeanConfig bc = DefaultSearchExecutor.getConfig(id);
        StringBuilder sql = new StringBuilder(bc.getSelectTableSql(field, isTransient));
        valueMap = DefaultSearchExecutor.createValueMap(id, valueMap, bc.getFieldlist(), sql);
        List<FieldConfig> fieldsConfigs = DefaultSearchExecutor.createJoinSql(sql, bc, valueMap, isTransient);
        DefaultSearchExecutor.createWhereSql(bc, sql, bc.getFieldlist(), args, operation, valueMap);
        return DefaultSearchExecutor.toPage(this.jdbcExecutor, this.pageExecutor, sql, pageable, id, args.toArray(), returnType, bc, fieldsConfigs, isTransient, isOrder, valueMap, rowmapping);
    }

    private static void joinPageOrders(BeanConfig bc, LPageable page) {
        List<Order> orders = null;
        HashSet<Order> sets = new HashSet<Order>();
        if (page.getSort() != null) {
            sets.addAll(bc.getOrders());
            sets.addAll(page.getSort().getOrders());
            orders = Arrays.asList(sets.toArray(new Order[sets.size()]));
            Collections.sort(orders);
        } else {
            orders = bc.getOrders();
        }
        LSort sort = page.getSort();
        if (sort == null) {
            sort = LSort.toSort(orders);
        } else {
            sort.setOrders(orders);
        }
        page.setSort(sort);
    }

    public static <T> LPage<T> toPage(JdbcExecutor jdbcExecutor, PageExecutor pageExecutor, StringBuilder sql, LPageable page, Object entiry, Object[] args, Class<T> cla, BeanConfig bc, List<FieldConfig> fields, boolean isTransient, boolean isOrder, Map<String, Object> valueMap, LRowMapping<T> rowmapping) {
        DefaultSearchExecutor.joinPageOrders(bc, page);
        int groupIndex = sql.indexOf(" GROUP BY ");
        String tempCountSql = null;
        tempCountSql = groupIndex != -1 ? "SELECT COUNT(1) COUNT  FROM ( " + sql + " ) " : COUNT_STR + sql.substring(sql.indexOf(bc.getTableFrom()), sql.length());
        String countSql = tempCountSql;
        String selectSql = DefaultSearchExecutor.parsePage(pageExecutor, sql, page, entiry, bc, valueMap, isOrder);
        LPage mypage = new LPage();
        mypage.setPagesize(page.getPageSize().intValue());
        mypage.setPageno(page.getPageNo().intValue());
        if (bc.isSync() && args.length > 0) {
            Future<Long> future = JdbcConfig.SYNC.submit(() -> jdbcExecutor.queryForSimpleObject(countSql, Long.TYPE, args));
            mypage.setContent(DefaultSearchExecutor.queryForList(jdbcExecutor, selectSql, args, cla, fields, isTransient, rowmapping, bc));
            if (page.getPageNo() <= 1 && mypage.getContent().size() < page.getPageSize()) {
                mypage.setTotal((long)mypage.getContent().size());
            } else {
                try {
                    mypage.setTotal(future.get().longValue());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        } else {
            mypage.setContent(DefaultSearchExecutor.queryForList(jdbcExecutor, selectSql, args, cla, fields, isTransient, rowmapping, bc));
            if (page.getPageNo() <= 1 && mypage.getContent().size() < page.getPageSize()) {
                mypage.setTotal((long)mypage.getContent().size());
            } else {
                mypage.setTotal(jdbcExecutor.queryForSimpleObject(countSql, Long.TYPE, args).longValue());
            }
        }
        return mypage;
    }

    public static LPage<Map<String, Object>> toPage(JdbcExecutor jdbcExecutor, PageExecutor pageExecutor, StringBuilder sql, String whereSql, LPageable page, Object entiry, Object[] args, BeanConfig bc, List<FieldConfig> fields, Map<String, Object> valueMap, boolean isOrder, boolean isGroup) {
        DefaultSearchExecutor.joinPageOrders(bc, page);
        String countSql = null;
        countSql = isGroup ? "select count(*) COUNT " + whereSql : bc.getCountTableSql() + whereSql;
        String selecsql = DefaultSearchExecutor.parsePage(pageExecutor, sql, page, entiry, bc, valueMap, isOrder);
        LPage mypage = new LPage();
        mypage.setPagesize(page.getPageSize().intValue());
        mypage.setPageno(page.getPageNo().intValue());
        mypage.setContent(jdbcExecutor.queryForListMap(selecsql, args));
        mypage.setTotal(jdbcExecutor.queryForSimpleObject(countSql, Long.TYPE, args).longValue());
        return mypage;
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, String field, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, LRowMapping<T> rowmapping, Class<T> returnType) {
        return this.searchForPage(id, field, pageable, operation, valueMap, isTransient, true, rowmapping, returnType);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, String field, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, LRowMapping<T> rowmapping, Class<T> returnType) {
        return this.searchForPage(id, field, pageable, operation, valueMap, false, rowmapping, returnType);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, LRowMapping<T> rowmapping, Class<T> returnType) {
        return this.searchForPage(id, null, pageable, operation, valueMap, rowmapping, returnType);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, Class<T> returnType) {
        return this.searchForPage(id, pageable, operation, valueMap, null, returnType);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, LPageable pageable, Map<String, Operation> operation, Class<T> returnType) {
        return this.searchForPage(id, pageable, operation, null, returnType);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, LPageable pageable, Class<T> returnType) {
        return this.searchForPage(id, pageable, null, returnType);
    }

    @Override
    public <T> LPage<T> searchSqlForPage(StringBuilder sql, String whereSql, LPageable page, Class<T> type, Object[] args, boolean isTransient, LRowMapping<T> rowMapping) {
        String countSql = this.getCountSql(whereSql);
        this.appendOrderSql(sql, page);
        String sreachSql = this.pageExecutor.getPageSql(sql.toString(), page.getPageNo(), page.getPageSize());
        LPage mypage = new LPage();
        mypage.setPagesize(page.getPageSize().intValue());
        mypage.setPageno(page.getPageNo().intValue());
        mypage.setContent(DefaultSearchExecutor.queryForList(this.jdbcExecutor, sreachSql, args, type, null, isTransient, rowMapping, null));
        mypage.setTotal((long)this.jdbcExecutor.queryForObject(countSql, Integer.class).intValue());
        return mypage;
    }

    @Override
    public LPage<Map<String, Object>> searchSqlForPage(StringBuilder sql, String whereSql, LPageable page, Object[] args) {
        String countSql = this.getCountSql(whereSql);
        this.appendOrderSql(sql, page);
        String sreachSql = this.pageExecutor.getPageSql(sql.toString(), page.getPageNo(), page.getPageSize());
        LPage mypage = new LPage();
        mypage.setPagesize(page.getPageSize().intValue());
        mypage.setPageno(page.getPageNo().intValue());
        mypage.setContent(this.jdbcExecutor.queryForListMap(sreachSql, args));
        mypage.setTotal((long)this.jdbcExecutor.queryForObject(countSql, Integer.class).intValue());
        return mypage;
    }

    private void appendOrderSql(StringBuilder sql, LPageable page) {
        List<Order> orders;
        LSort s = page.getSort();
        if (s != null && (orders = s.getOrders()).size() > 0) {
            Order o = null;
            for (int i = 0; i < orders.size(); ++i) {
                o = orders.get(i);
                if (i == 0) {
                    sql.append(" ORDER BY " + o.getField() + " " + o.getOrder());
                    continue;
                }
                sql.append(" , " + o.getField() + " " + o.getOrder());
            }
        }
    }

    private String getCountSql(String whereSql) {
        return "SELECT count(1) COUNT FROM" + whereSql;
    }

    @Override
    public <T> LPage<T> searchSqlForPage(StringBuilder sql, String whereSql, LPageable page, Class<T> type, Object[] args, LRowMapping<T> rowMapping) {
        return this.searchSqlForPage(sql, whereSql, page, type, args, false, rowMapping);
    }

    @Override
    public <T> T searchField(Object entiry, String field, Class<T> returnType, Map<String, Operation> operationMap, Map<String, Object> valueMap) {
        BeanConfig bc = DefaultSearchExecutor.getConfig(entiry);
        FieldConfig fc = bc.getField(field);
        String cloum = field;
        if (fc != null) {
            cloum = fc.getColumn();
        }
        StringBuilder sql = new StringBuilder(bc.getSelectTableSql(cloum, false));
        ArrayList<Object> args = new ArrayList<Object>();
        List<FieldConfig> fs = bc.getFieldlist();
        valueMap = DefaultSearchExecutor.createValueMap(entiry, valueMap, fs, sql);
        DefaultSearchExecutor.createWhereSql(bc, sql, fs, args, operationMap, valueMap);
        return this.jdbcExecutor.queryForSimpleObject(sql.toString(), returnType, args.toArray());
    }

    @Override
    public boolean hasById(Object t, Object ... ids) {
        BeanConfig bc = DefaultSearchExecutor.getConfig(t);
        Sqlbuilder countsql = new Sqlbuilder(bc.getCountTableSql());
        if (t instanceof Class) {
            DefaultSearchExecutor.createIdWhere(bc, countsql);
            return this.jdbcExecutor.queryForSimpleObject(countsql.toString(), Integer.class, ids) > 0;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Map<String, Object> valueMap = DefaultSearchExecutor.createValueMap(t, null, bc.getIdField(), countsql.getBuilder());
        DefaultSearchExecutor.createIdWhere(bc, countsql, args, valueMap);
        for (Object id : ids) {
            args.add(id);
        }
        return this.jdbcExecutor.queryForSimpleObject(countsql.toString(), Integer.class, args.toArray()) > 0;
    }

    @Override
    public <T> T findById(Object configId, String field, Class<T> returnType, Object ... ids) {
        BeanConfig bc = DefaultSearchExecutor.getConfig(configId);
        if (bc == null) {
            throw new ConfigException("id" + configId + "\u6ca1\u6709\u914d\u7f6e");
        }
        String selectSql = bc.getSelectTableSql(field, false);
        StringBuilder sql = new StringBuilder(selectSql);
        Sqlbuilder selectsql = new Sqlbuilder(sql);
        if (configId instanceof Class) {
            DefaultSearchExecutor.createIdWhere(bc, selectsql);
            return DefaultSearchExecutor.queryForObject(this.jdbcExecutor, selectsql.toString(), ids, bc, bc.getFieldlist(), returnType);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Map<String, Object> valueMap = DefaultSearchExecutor.createValueMap(configId, null, bc.getIdField(), sql);
        DefaultSearchExecutor.createIdWhere(bc, selectsql, args, valueMap);
        for (Object id : ids) {
            args.add(id);
        }
        return DefaultSearchExecutor.queryForObject(this.jdbcExecutor, selectsql.toString(), args.toArray(), bc, bc.getFieldlist(), returnType);
    }

    @Override
    public <T> T searchFieldById(Class<?> entiry, Class<T> type, String fieldName, Object ... ids) {
        BeanConfig bc = DefaultSearchExecutor.getConfig(entiry);
        FieldConfig fc = bc.getField(fieldName);
        String cloum = fc == null ? fieldName : fc.getColumn();
        Sqlbuilder countsql = new Sqlbuilder(bc.getSelectTableSql(cloum, false));
        DefaultSearchExecutor.createIdWhere(bc, countsql);
        return this.jdbcExecutor.queryForSimpleObject(countsql.toString(), type, ids);
    }

    @Override
    public <T> LPage<T> searchSqlForPage(StringBuilder sql, String whereSql, LPageable page, Class<T> type, Object[] args) {
        return this.searchSqlForPage(sql, whereSql, page, type, args, null);
    }

    @Override
    public <T> LPage<T> searchSqlForPage(StringBuilder sql, String whereSql, LPageable page, Class<T> type) {
        return this.searchSqlForPage(sql, whereSql, page, type, null);
    }

    @Override
    public <T> T findById(Object configId, Class<T> returnType, Object ... ids) {
        return this.findById(configId, null, returnType, ids);
    }

    @Override
    public List<Map<String, Object>> searchForList(@NotNull Object id, String select, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isOrder) {
        ArrayList<Object> args = new ArrayList<Object>();
        BeanConfig bc = DefaultSearchExecutor.getConfig(id);
        String selectsql = bc.getSelectTableSql(select, false);
        StringBuilder sql = new StringBuilder(selectsql);
        valueMap = DefaultSearchExecutor.createValueMap(id, valueMap, bc.getFieldlist(), sql);
        DefaultSearchExecutor.createWhereSql(bc, sql, bc.getFieldlist(), args, operation, valueMap);
        if (isOrder) {
            DefaultSearchExecutor.createOrders(bc.getOrders(), sql, bc, valueMap);
        }
        return this.jdbcExecutor.queryForListMap(sql.toString(), args.toArray());
    }

    @Override
    public List<Map<String, Object>> searchForList(@NotNull Object id, String select, Map<String, Operation> operation, Map<String, Object> valueMap) {
        return this.searchForList(id, select, operation, valueMap, true);
    }

    @Override
    public List<Map<String, Object>> searchForList(@NotNull Object id, String select, Map<String, Operation> operation) {
        return this.searchForList(id, select, operation, null);
    }

    @Override
    public List<Map<String, Object>> searchForList(@NotNull Object id, String select) {
        return this.searchForList(id, select, null);
    }

    @Override
    public List<Map<String, Object>> searchForList(@NotNull Object id) {
        return this.searchForList(id, null, null, null, true);
    }

    @Override
    public LPage<Map<String, Object>> searchForPage(Object id, String field, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isOrder) {
        ArrayList<Object> args = new ArrayList<Object>();
        BeanConfig bc = DefaultSearchExecutor.getConfig(id);
        StringBuilder sql = new StringBuilder(bc.getSelectTableSql(field, false));
        valueMap = DefaultSearchExecutor.createValueMap(id, valueMap, bc.getFieldlist(), sql);
        List<FieldConfig> fieldsConfigs = DefaultSearchExecutor.createJoinSql(sql, bc, valueMap, false);
        int start = sql.length();
        DefaultSearchExecutor.createWhereSql(bc, sql, bc.getFieldlist(), args, operation, valueMap);
        int groupIndex = sql.indexOf(" GROUP BY ");
        Object tempCountSql = null;
        tempCountSql = groupIndex != -1 ? " FROM ( " + sql + " ) as count2" : sql.substring(start, sql.length());
        return DefaultSearchExecutor.toPage(this.jdbcExecutor, this.pageExecutor, sql, (String)tempCountSql, pageable, id, args.toArray(), bc, fieldsConfigs, valueMap, isOrder, groupIndex != -1);
    }

    @Override
    public LPage<Map<String, Object>> searchForPage(Object id, String field, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap) {
        return this.searchForPage(id, field, pageable, operation, valueMap, true);
    }

    @Override
    public LPage<Map<String, Object>> searchForPage(Object id, String field, LPageable pageable, Map<String, Operation> operation) {
        return this.searchForPage(id, field, pageable, operation, null);
    }

    @Override
    public LPage<Map<String, Object>> searchForPage(Object id, String field, LPageable pageable) {
        return this.searchForPage(id, field, pageable, null);
    }

    @Override
    public LPage<Map<String, Object>> searchForPage(Object id, LPageable pageable) {
        return this.searchForPage(id, null, pageable, null);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, LRowMapping<T> rowmapping, Class<T> returnType) {
        return this.searchForPage(id, null, pageable, operation, valueMap, isTransient, rowmapping, returnType);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, Class<T> returnType) {
        return this.searchForPage(id, pageable, operation, valueMap, isTransient, null, returnType);
    }

    @Override
    public <T> T findOne(Object config, Map<String, Object> valueMap, Map<String, Operation> operationMap, boolean isTransient, Class<T> returnType) {
        ArrayList<Object> args = new ArrayList<Object>();
        BeanConfig bc = DefaultSearchExecutor.getConfig(config);
        String selectsql = bc.getSelectTableSql(null, isTransient);
        StringBuilder sql = new StringBuilder(selectsql);
        List<FieldConfig> fields = DefaultSearchExecutor.createJoinSql(sql, bc, valueMap = DefaultSearchExecutor.createValueMap(config, valueMap, bc.getFieldlist(), sql), isTransient);
        List<FieldConfig> fieldConfigs = fields;
        if (fieldConfigs != null && fieldConfigs.size() > 0) {
            fieldConfigs.addAll(isTransient ? bc.getAllFields() : bc.getFieldlist());
        } else {
            fieldConfigs = isTransient ? bc.getAllFields() : bc.getFieldlist();
        }
        DefaultSearchExecutor.createWhereSql(bc, sql, bc.getFieldlist(), args, operationMap, valueMap);
        try {
            return this.jdbcExecutor.queryForObject(sql.toString(), new RowMapping(bc, fieldConfigs, null), args.toArray());
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> T findOne(Object config, Map<String, Object> valueMap, Map<String, Operation> operationMap) {
        return this.findOne(config, valueMap, operationMap, false, null);
    }

    @Override
    public <T> T findOne(Object config, Map<String, Object> valueMap) {
        return this.findOne(config, valueMap, null);
    }

    @Override
    public <T> T findOne(Object config) {
        return this.findOne(config, null);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, String field, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isOrder, Class<T> returnType) {
        return this.searchForList(id, field, operation, valueMap, false, isOrder, null, returnType);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, String field, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, boolean isOrder, LRowMapping<T> rowmapping, Class<T> returnType) {
        return this.searchForList(id, field, operation, valueMap, isTransient, isOrder, rowmapping, null, returnType);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, Class<T> returnType, LSort sort) {
        return this.searchForList(id, null, null, null, false, false, null, sort, returnType);
    }

    @Override
    public <T> List<T> searchForList(@NotNull Object id, String field, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, boolean isOrder, LRowMapping<T> rowmapping, LSort sort, Class<T> returnType) {
        return this.searchForList(id, field, operation, valueMap, isTransient, isOrder, false, rowmapping, sort, returnType);
    }

    @Override
    public <T> List<T> searchForListJoin(@NotNull Object id, String field, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isNoJoin, LSort sort, Class<T> returnType) {
        return this.searchForList(id, field, operation, valueMap, false, true, false, null, sort, returnType);
    }

    @Override
    public <T> LPage<T> searchForPage(Object id, String field, LPageable pageable, Map<String, Operation> operation, Map<String, Object> valueMap, boolean isTransient, boolean isOrder, Class<T> returnType) {
        return this.searchForPage(id, field, pageable, operation, valueMap, isTransient, isOrder, null, returnType);
    }

    @Override
    public <T> List<T> findByIds(Object configId, Class<?> returnType, Object ... ids) {
        BeanConfig bc = DefaultSearchExecutor.getConfig(configId);
        if (bc == null) {
            throw new ConfigException("id" + configId + "\u6ca1\u6709\u914d\u7f6e");
        }
        String selectSql = bc.getSelectTableSql(null, false);
        StringBuilder sql = new StringBuilder(selectSql);
        Sqlbuilder selectsql = new Sqlbuilder(sql);
        String id = bc.getIdField().get(0).getColumn();
        selectsql.where(id + " in ").in(ids, true);
        return this.jdbcExecutor.queryForList(selectsql.toString(), new RowMapping(bc, bc.getFieldlist(), null), ids);
    }
}

