/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.executor.jdbc.impl;

import java.util.List;
import java.util.Map;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.executor.jdbc.JdbcExecutor;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.mapping.RowMapping;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class JdbcTemplateExecutor
implements JdbcExecutor {
    private JdbcTemplate jt;

    public JdbcTemplateExecutor(JdbcTemplate jt) {
        this.jt = jt;
    }

    @Override
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) {
        try {
            return (T)this.jt.queryForObject(sql, args, rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> T queryForSimpleObject(String sql, Class<T> requiredType, Object ... args) {
        try {
            return (T)this.jt.queryForObject(sql, args, requiredType);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> List<T> queryForSimpleList(String sql, Class<T> elementType, Object ... args) {
        return this.jt.queryForList(sql, args, elementType);
    }

    @Override
    public <T> List<T> queryForList(String sql, RowMapper<T> rowMapper, Object ... args) {
        return this.jt.query(sql, args, rowMapper);
    }

    @Override
    public Integer update(String sql, Object ... args) {
        return this.jt.update(sql, args);
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.jt.batchUpdate(sql, batchArgs);
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... args) {
        return this.jt.queryForMap(sql, args);
    }

    @Override
    public List<Map<String, Object>> queryForListMap(String sql, Object ... args) {
        return this.jt.queryForList(sql, args);
    }

    @Override
    public Map<String, Object> queryForMap(String sql) {
        return this.jt.queryForMap(sql);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> returnType) {
        return (T)this.jt.queryForObject(sql, returnType);
    }

    @Override
    public int[] batchUpdate(String[] array) {
        return this.jt.batchUpdate(array);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> returnType, Object ... args) {
        BeanConfig beanConfig = BeanConfigFactory.getInstance(returnType);
        if (beanConfig == null) {
            return this.queryForSimpleObject(sql, returnType, args);
        }
        return this.queryForObject(sql, new RowMapping(beanConfig, beanConfig.getAllFields()), args);
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType, Object ... args) {
        BeanConfig beanConfig = BeanConfigFactory.getInstance(elementType);
        if (beanConfig == null) {
            return this.queryForSimpleList(sql, elementType, args);
        }
        return this.queryForList(sql, new RowMapping(beanConfig, beanConfig.getAllFields()), args);
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType) {
        return this.queryForList(sql, elementType, new Object[0]);
    }

    @Override
    public Integer update(String sql) {
        return this.update(sql, new Object[0]);
    }
}

