/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.executor.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.risedata.jdbc.commons.TypeCheck;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.exception.ConfigException;
import net.risedata.jdbc.executor.jdbc.JdbcExecutor;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.mapping.RowMapping;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.utils.LCollection;
import net.risedata.jdbc.utils.Sqlbuilder;

public class JDBC {
    public static final String SQL_KEY = "$SQL";

    protected static <T> T queryForObject(JdbcExecutor jdbcExecutor, String sql, Object[] args, BeanConfig bc, Collection<FieldConfig> fcs, Class<T> returnrtpe) {
        assert (jdbcExecutor != null && returnrtpe != null) : "param is null";
        if (returnrtpe == Map.class || Map.class.isAssignableFrom(returnrtpe)) {
            return (T)jdbcExecutor.queryForMap(sql, args);
        }
        if (TypeCheck.isBaseType(returnrtpe)) {
            return jdbcExecutor.queryForSimpleObject(sql, returnrtpe, args);
        }
        return jdbcExecutor.queryForObject(sql, new RowMapping(bc, fcs), args);
    }

    protected static Map<String, Object> createValueMap(Object entiry, Map<String, Object> valueMap, Collection<FieldConfig> fields, StringBuilder sql) {
        Map<String, Object> retMap = null;
        boolean isInstance = !(entiry instanceof Class) && !(entiry instanceof String);
        retMap = isInstance && valueMap != null ? valueMap : new HashMap<String, Object>();
        retMap.put(SQL_KEY, sql);
        if (isInstance) {
            for (FieldConfig fieldConfig : fields) {
                try {
                    if (retMap.containsKey(fieldConfig.getFieldName())) continue;
                    retMap.put(fieldConfig.getFieldName(), fieldConfig.getValueField().get(entiry));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (valueMap != null && retMap != valueMap) {
            retMap.putAll(valueMap);
        }
        return retMap;
    }

    protected static BeanConfig getConfig(Object entiry) {
        return BeanConfigFactory.getInstance(entiry);
    }

    private static void sort(Map<String, Operation> operations, FieldConfig[] configs, BeanConfig bc) {
        FieldConfig temp = null;
        int index = 0;
        Integer oldIndex = 0;
        Set<String> set = operations.keySet();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(configs.length);
        for (int i = 0; i < configs.length; ++i) {
            indexMap.put(configs[i].getFieldName(), i);
        }
        for (String field : set) {
            index = operations.get(field).getOperate();
            if (index <= -1) continue;
            oldIndex = (Integer)indexMap.get(field);
            if (oldIndex == null) {
                throw new ConfigException(field + " \u4e0d\u5b58\u5728!");
            }
            if (index >= configs.length) {
                temp = configs[configs.length - 1];
                configs[configs.length - 1] = configs[oldIndex];
                configs[oldIndex.intValue()] = temp;
                continue;
            }
            temp = configs[index];
            configs[index] = configs[oldIndex];
            configs[oldIndex.intValue()] = temp;
        }
    }

    protected static void createWhereSql(BeanConfig config, StringBuilder sql, Collection<FieldConfig> fs, List<Object> args, Map<String, Operation> operationMap, Map<String, Object> valueMap) {
        boolean isWhere = false;
        HashMap<String, Object> excludeKey = null;
        boolean isOperation = operationMap != null;
        int length = -1;
        if (isOperation) {
            excludeKey = new HashMap<String, Object>();
            FieldConfig[] fss = new FieldConfig[fs.size()];
            fs.toArray(fss);
            JDBC.sort(operationMap, fss, config);
            fs = new LCollection<FieldConfig>(fss);
        }
        for (FieldConfig fieldConfig : fs) {
            Operation op = fieldConfig.getOperation(valueMap);
            if (isOperation) {
                if (excludeKey.containsKey(fieldConfig.getFieldName())) continue;
                if (operationMap.containsKey(fieldConfig.getFieldName())) {
                    op = operationMap.get(fieldConfig.getFieldName());
                }
            }
            length = sql.length();
            if (!op.where(fieldConfig, args, sql, valueMap, config, excludeKey)) continue;
            if (isWhere) {
                sql.insert(length, " AND ");
                continue;
            }
            sql.insert(length, " WHERE ");
            isWhere = true;
        }
    }

    protected static Sqlbuilder createIdWhere(BeanConfig bc, Sqlbuilder sqlbuild, List<Object> args, Map<String, Object> valueMap) {
        List<FieldConfig> idfc = bc.getIdField();
        for (FieldConfig fieldConfig : idfc) {
            if (fieldConfig.isPlaceholder()) continue;
            sqlbuild.where(fieldConfig.getColumn() + " = ?");
            if (valueMap == null || !valueMap.containsKey(fieldConfig.getFieldName())) continue;
            args.add(valueMap.get(fieldConfig.getFieldName()));
        }
        return sqlbuild;
    }

    protected static Sqlbuilder createIdWhere(BeanConfig bc, Sqlbuilder sqlbuild) {
        List<FieldConfig> idfc = bc.getIdField();
        for (FieldConfig fieldConfig : idfc) {
            if (fieldConfig.isPlaceholder()) continue;
            sqlbuild.where(fieldConfig.getColumn() + " = ?");
        }
        return sqlbuild;
    }

    protected static int check(JdbcExecutor jdbcExecutor, BeanConfig bc, Map<String, Object> valueMap, boolean update) {
        String checkSql = bc.getCheckSql();
        if (checkSql != null) {
            StringBuilder sql = new StringBuilder(checkSql);
            List<FieldConfig> checks = bc.getCheckedField();
            ArrayList<Object> args = new ArrayList<Object>();
            int length = sql.length();
            boolean isCheck = false;
            boolean flag = true;
            if (update) {
                for (FieldConfig field : bc.getIdField()) {
                    isCheck = JDBC.checkId(sql, valueMap, args, field);
                    if (isCheck) {
                        if (flag) {
                            sql.insert(length, " WHERE ");
                            flag = false;
                        } else {
                            sql.insert(length, " AND ");
                        }
                    }
                    length = sql.length();
                }
            }
            for (FieldConfig field : checks) {
                isCheck = field.getDefaultOperation().check(sql, valueMap, args, field);
                if (isCheck) {
                    if (flag) {
                        sql.insert(length, " WHERE ");
                        flag = false;
                    } else {
                        sql.insert(length, " AND ");
                    }
                }
                length = sql.length();
            }
            Integer count = jdbcExecutor.queryForSimpleObject(sql.toString(), Integer.class, args.toArray());
            if (count != null && count > 0) {
                return -1;
            }
        }
        return 1;
    }

    private static boolean checkId(StringBuilder sql, Map<String, Object> valueMap, List<Object> args, FieldConfig fc) {
        Object value = valueMap.get(fc.getFieldName());
        if (value != null) {
            sql.append(fc.getColumn() + " != ?");
            args.add(value);
            return true;
        }
        return false;
    }

    protected static <T> T getMap(String key, Map<String, T> map, Class<T> T) {
        T o = map.get(key);
        return o != null ? T.cast(o) : JDBC.toException(key + "\u4e0d\u5b58\u5728\u8be5field\u6620\u5c04", T);
    }

    protected static <T> T toException(String msg, Class<T> T) {
        throw new RuntimeException(msg);
    }
}

