/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.executor.insert.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.executor.insert.InsertExecutor;
import net.risedata.jdbc.executor.jdbc.JDBC;
import net.risedata.jdbc.executor.jdbc.JdbcExecutor;
import net.risedata.jdbc.search.exception.NoValueException;
import org.apache.commons.lang3.StringUtils;

public class DefaultInsertExecutor
extends JDBC
implements InsertExecutor {
    private JdbcExecutor jdbcExecutor;

    public DefaultInsertExecutor(JdbcExecutor jdbcExecutor) {
        this.jdbcExecutor = jdbcExecutor;
    }

    public JdbcExecutor getJdbcExecutor() {
        return this.jdbcExecutor;
    }

    public void setJdbcExecutor(JdbcExecutor jdbcExecutor) {
        this.jdbcExecutor = jdbcExecutor;
    }

    private static int createInsertSql(BeanConfig bc, List<FieldConfig> fields, List<Object> args, StringBuilder sql, Map<String, Object> valueMap, boolean isAll) {
        ArrayList<String> columns = new ArrayList<String>();
        for (FieldConfig fieldConfig : fields) {
            if (isAll) {
                columns.add(fieldConfig.getColumn());
                continue;
            }
            fieldConfig.getDefaultOperation().insert(args, columns, valueMap, fieldConfig);
        }
        sql.append("insert into " + bc.getTableName() + " (" + StringUtils.join(columns, (String)",") + ") values (");
        for (int i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        return columns.size();
    }

    @Override
    public int insert(Object entiry, Map<String, Object> valueMap) {
        BeanConfig bc = DefaultInsertExecutor.getConfig(entiry);
        StringBuilder sql = new StringBuilder();
        if (DefaultInsertExecutor.check(this.jdbcExecutor, bc, valueMap = DefaultInsertExecutor.createValueMap(entiry, valueMap, bc.getAllFields(), sql), false) == -1) {
            return -1;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        DefaultInsertExecutor.createInsertSql(bc, bc.getAllFields(), args, sql, valueMap, false);
        return this.jdbcExecutor.update(sql.toString(), args.toArray());
    }

    @Override
    public int insert(Object entiry) {
        return this.insert(entiry, null);
    }

    @Override
    public int[] batchInsert(Collection<?> entirys, String tableName) {
        if (entirys.size() < 1) {
            return new int[]{-1};
        }
        Object[] arr = entirys.toArray();
        Object entiry = arr[0];
        BeanConfig bc = DefaultInsertExecutor.getConfig(entiry);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        List<FieldConfig> fields = bc.getFieldlist();
        Map<String, Object> valueMap = DefaultInsertExecutor.createValueMap(entiry, null, fields, sql);
        int size = DefaultInsertExecutor.createInsertSql(bc, fields, args, sql, valueMap, true);
        ArrayList<Object[]> batchArgs2 = new ArrayList<Object[]>();
        for (Object object : arr) {
            args = new ArrayList();
            valueMap = DefaultInsertExecutor.createValueMap(object, null, fields, sql);
            for (FieldConfig fieldConfig : fields) {
                args.add(valueMap.get(fieldConfig.getFieldName()));
            }
            if (args.size() != size) {
                throw new NoValueException("entiry " + object + " \u7f3a\u5c11\u4e00\u4e2a\u5b57\u6bb5 \u6216\u8005\u8d85\u8fc7\u6ca1\u6709\u8bbe\u7f6e\u4e00\u4e2a\u5b57\u6bb5\u7684\u9ed8\u8ba4\u503c \u5b57\u6bb5\u4e2a\u6570\u7531 \u7b2c\u4e00\u4e2aentiry\u4e3a\u51c6insert sql" + sql.toString());
            }
            batchArgs2.add(args.toArray());
        }
        int[] reset = this.jdbcExecutor.batchUpdate(StringUtils.isNotEmpty((CharSequence)tableName) ? sql.toString().replace(bc.getTableName(), tableName) : sql.toString(), batchArgs2);
        return reset;
    }

    @Override
    public int[] batchInsert(String tableName, @NotNull Collection<Map<String, Object>> values) {
        int i;
        if (values == null || values.size() == 0) {
            return new int[]{-1};
        }
        StringBuilder sql = new StringBuilder();
        Object[] keys = values.iterator().next().keySet().toArray();
        sql.append("insert into ").append(tableName).append("(");
        for (i = 0; i < keys.length; ++i) {
            sql.append(keys[i]);
            if (i == keys.length - 1) continue;
            sql.append(",");
        }
        sql.append(") values (");
        for (i = 0; i < keys.length; ++i) {
            sql.append("?");
            if (i == keys.length - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (Map<String, Object> value : values) {
            Object[] tempArgs = new Object[keys.length];
            for (int i2 = 0; i2 < keys.length; ++i2) {
                tempArgs[i2] = value.get(keys[i2]);
            }
            args.add(tempArgs);
        }
        return this.jdbcExecutor.batchUpdate(sql.toString(), args);
    }

    @Override
    public int[] batchInsert(@NotNull Collection<?> entirys) {
        return this.batchInsert(entirys, null);
    }
}

