/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.config.model;

import java.util.List;
import net.risedata.jdbc.config.model.FieldConfig;
import org.apache.commons.lang3.StringUtils;

public class JoinFieldConfig {
    private FieldConfig fc;
    private List<FieldConfig> fields;
    private boolean isAutoFunction;
    private String function;
    private String column;
    private String returnCol;

    public boolean isAutoFunction() {
        return this.isAutoFunction;
    }

    public void setAutoFunction(boolean isAutoFunction) {
        this.isAutoFunction = isAutoFunction;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public List<FieldConfig> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldConfig> fields) {
        this.fields = fields;
    }

    public FieldConfig getFc() {
        return this.fc;
    }

    public void setFc(FieldConfig fc) {
        this.fc = fc;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void toSql(StringBuilder sql, String tableAs, String tableName) {
        if (StringUtils.isBlank((CharSequence)this.function)) {
            if (!this.fc.isEntiry()) {
                this.returnCol = tableAs + "_" + this.column;
                if (sql.indexOf(this.returnCol) == -1) {
                    sql.append(this.column + " as " + this.returnCol);
                }
                this.fc.setColumn(this.returnCol);
            } else {
                for (int i = 0; i < this.fields.size(); ++i) {
                    this.returnCol = tableAs + "_" + this.fields.get(i).getColumn();
                    if (sql.indexOf(this.returnCol) == -1) {
                        sql.append(" " + this.fields.get(i).getColumn() + " as " + this.returnCol + " , ");
                    }
                    this.fields.get(i).setColumn(this.returnCol);
                }
            }
        } else {
            this.returnCol = tableAs + "_" + this.column;
            if (this.isAutoFunction) {
                sql.append("(" + this.function + ")" + this.returnCol);
            } else {
                sql.append("( SELECT " + this.function + "(" + this.column + ") FROM " + tableName + " " + tableAs + " where $idrelation)" + this.returnCol);
            }
            this.fc.setColumn(this.returnCol);
        }
    }

    public String getReturnCol() {
        return this.returnCol;
    }

    public void toAs(StringBuilder sb, String as, String tableName) {
        if (this.fc.isEntiry()) {
            for (int i = 0; i < this.fields.size(); ++i) {
                sb.append(this.fields.get(i).getColumn());
                if (i == this.fields.size() - 1) continue;
                sb.append(",");
            }
        } else {
            sb.append(this.fc.getColumn());
        }
    }

    public String toString() {
        return "JoinFieldConfig [fc=" + this.fc + ", fields=" + this.fields + ", isAutoFunction=" + this.isAutoFunction + ", function=" + this.function + ", column=" + this.column + ", returnCol=" + this.returnCol + "]";
    }
}

