/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.config.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.condition.Condition;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.config.model.JoinFieldConfig;
import net.risedata.jdbc.search.exception.JoinException;
import org.apache.commons.lang3.StringUtils;

public class JoinConfig {
    public static final String MAIN_TABLE_NAME = "$table";
    private Class<?> tableClass;
    private Condition condition;
    private String tableName;
    private String where;
    private String[] toId;
    private String[] joinId;
    private List<FieldConfig> fields;
    private String as;
    private String sql;
    private BeanConfig joinBean;
    private BeanConfig myBean;
    private String fieldSql;
    private boolean isFunction = false;
    private List<JoinFieldConfig> fieldConfigs = new ArrayList<JoinFieldConfig>();
    public static final String IDRELATION = "$idrelation";

    public String getSql() {
        return this.sql;
    }

    public void addField(JoinFieldConfig field) {
        this.fieldConfigs.add(field);
        boolean flag = false;
        for (JoinFieldConfig joinFieldConfig : this.fieldConfigs) {
            if (StringUtils.isBlank((CharSequence)joinFieldConfig.getFunction())) {
                flag = true;
                if (!this.isFunction) continue;
                throw new JoinException(this.myBean + " \u975e\u4e00\u5bf9\u4e00\u5173\u7cfb\u4ee5\u53ca\u914d\u7f6e\u4e86\u805a\u5408\u5173\u7cfb");
            }
            this.isFunction = true;
            if (!flag) continue;
            throw new JoinException(this.myBean + " \u975e\u4e00\u5bf9\u4e00\u5173\u7cfb\u4ee5\u53ca\u914d\u7f6e\u4e86\u805a\u5408\u5173\u7cfb");
        }
    }

    public void setWhere(String where) {
        if (this.where != null) {
            throw new JoinException("\u8868\u5df2\u5b58\u5728where \u6761\u4ef6");
        }
        this.where = where;
    }

    public void toSql(String tableAs, String parentAs) {
        if (this.joinId != null && this.joinId.length != this.toId.length) {
            throw new JoinException("joinid and to id required corresponding joinid length = " + this.joinId.length + "toid lenght = " + this.toId.length);
        }
        StringBuilder sb = null;
        sb = this.isFunction ? new StringBuilder() : new StringBuilder(" LEFT JOIN (SELECT ");
        this.as = tableAs;
        this.fields = new ArrayList<FieldConfig>();
        StringBuilder fieldsSql = new StringBuilder();
        for (int i = 0; i < this.fieldConfigs.size(); ++i) {
            this.fieldConfigs.get(i).toSql(sb, this.as, this.tableName);
            if (this.fieldConfigs.get(i).getFc().isEntiry()) {
                this.fields.add(this.fieldConfigs.get(i).getFc());
            } else {
                this.fields.add(this.fieldConfigs.get(i).getFc());
                sb.append(",");
            }
            this.fieldConfigs.get(i).toAs(fieldsSql, this.as, this.tableName);
        }
        this.fieldSql = fieldsSql.toString();
        if (!this.isFunction) {
            int i;
            FieldConfig[] toFields = new FieldConfig[this.toId.length];
            String[] fieldCol = new String[this.toId.length];
            FieldConfig[] joinFields = new FieldConfig[this.joinId.length];
            boolean flag = false;
            for (i = 0; i < this.toId.length; ++i) {
                toFields[i] = this.joinBean.getField(this.toId[i]);
                joinFields[i] = this.myBean.getField(this.joinId[i]);
                if (toFields[i] == null) {
                    throw new JoinException("join field:" + this.toId[i] + " join bean no field");
                }
                if (joinFields[i] == null) {
                    throw new JoinException(" field: " + this.joinId[i] + " bean no field");
                }
                fieldCol[i] = this.as + "_" + toFields[i].getColumn();
                if (sb.indexOf(fieldCol[i]) != -1) continue;
                sb.append(toFields[i].getColumn() + " as " + fieldCol[i]);
                if (i != this.toId.length - 1) {
                    sb.append(",");
                }
                flag = true;
            }
            if (!flag) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(" from " + this.tableName + (String)(this.where == null ? "" : " where " + this.where) + ") " + this.as + " on " + (this.joinId.length > 1 ? "(" : ""));
            for (i = 0; i < this.joinId.length; ++i) {
                sb.append(this.as + "." + fieldCol[i] + "=" + parentAs + "." + joinFields[i].getColumn());
                if (i == this.joinId.length - 1) continue;
                sb.append(" and ");
            }
            if (this.joinId.length > 1) {
                sb.append(") ");
            }
            this.sql = sb.toString();
        } else {
            if (this.toId == null && this.joinId == null) {
                this.sql = sb.toString();
                return;
            }
            StringBuilder idBuilder = new StringBuilder();
            FieldConfig[] toFields = new FieldConfig[this.toId.length];
            FieldConfig[] joinFields = new FieldConfig[this.joinId.length];
            for (int i = 0; i < this.toId.length; ++i) {
                try {
                    toFields[i] = this.joinBean.getField(this.toId[i]);
                }
                catch (Exception e) {
                    System.out.println(this.joinBean);
                }
                joinFields[i] = this.myBean.getField(this.joinId[i]);
                if (toFields[i] == null) {
                    throw new JoinException("join field" + this.toId[i] + " join bean no field");
                }
                if (joinFields[i] == null) {
                    throw new JoinException(" field" + this.joinId[i] + " bean no field");
                }
                idBuilder.append(this.as + "." + toFields[i].getColumn() + " = " + parentAs + "." + joinFields[i].getColumn());
                if (i == this.joinId.length - 1) continue;
                idBuilder.append(" and ");
            }
            this.sql = sb.toString().replace(IDRELATION, idBuilder.toString() + (String)(this.where != null ? " and " + this.where : ""));
        }
        this.sql = this.sql.replace(MAIN_TABLE_NAME, this.myBean.getTableAs());
    }

    public String getTableAs() {
        return this.as;
    }

    public String getFieldAsForField(String field) {
        FieldConfig fieldConfig = this.joinBean.getField(field);
        if (fieldConfig != null) {
            return this.getTableAs() + "_" + fieldConfig.getColumn();
        }
        throw new NullPointerException(field + " is null config");
    }

    public String getFieldAsForCloum(String cloum) {
        return this.getTableAs() + "_" + cloum;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public boolean isJoin(Map<String, Object> o) {
        return this.condition == null ? true : this.condition.isHandle(o);
    }

    public BeanConfig getMyBean() {
        return this.myBean;
    }

    public void setMyBean(BeanConfig myBean) {
        this.myBean = myBean;
    }

    public String[] getToId() {
        return this.toId;
    }

    public void setToId(String[] toId) {
        this.toId = toId;
    }

    public String[] getJoinId() {
        return this.joinId;
    }

    public void setJoinId(String[] joinId) {
        this.joinId = joinId;
    }

    public Collection<? extends FieldConfig> getFields() {
        return this.fields;
    }

    public void setFunction(boolean isFunction) {
        this.isFunction = isFunction;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public String getTableName() {
        return this.tableName;
    }

    public BeanConfig getJoinBean() {
        return this.joinBean;
    }

    public void setJoinBean(BeanConfig joinBean) {
        this.joinBean = joinBean;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        return "JoinConfig [tableClass=" + this.tableClass + ", condition=" + this.condition + ", tableName=" + this.tableName + ", where=" + this.where + ", toId=" + Arrays.toString(this.toId) + ", joinId=" + Arrays.toString(this.joinId) + ", fields=" + this.fields + ", as=" + this.as + ", sql=" + this.sql + ", joinBean=" + this.joinBean.getCla() + ", myBean=" + this.myBean.getCla() + ", fieldSql=" + this.fieldSql + ", isFunction=" + this.isFunction + ", fieldConfigs=" + this.fieldConfigs + "]";
    }

    public String getFieldSql() {
        return this.fieldSql;
    }

    public void setFieldSql(String fieldSql) {
        this.fieldSql = fieldSql;
    }

    public Class<?> getTableClass() {
        return this.tableClass;
    }

    public void setTableClass(Class<?> tableClass) {
        this.tableClass = tableClass;
    }
}

