/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.config.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.commons.TypeCheck;
import net.risedata.jdbc.mapping.HandleMapping;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.OperationPack;

public class FieldConfig
implements Comparable<FieldConfig> {
    private boolean isUpdateId = false;
    private boolean updateWhere = false;
    private boolean updateCheck = false;
    private boolean isPlaceholder = false;
    private boolean isEntiry = false;
    private String fieldName;
    private boolean isTransient;
    private HandleMapping handle;
    private Field field;
    private Field valueField;
    private Field setValueField;
    private Class<?> fieldType;
    private boolean isId;
    private String column;
    private List<OperationPack> OperationPacks;
    private Operation defaultOperation;

    public Field getField() {
        return this.field;
    }

    public boolean isUpdateWhere() {
        return this.updateWhere;
    }

    public void setUpdateWhere(boolean updateWhere) {
        this.updateWhere = updateWhere;
    }

    public boolean isUpdateId() {
        return this.isUpdateId;
    }

    public void setUpdateId(boolean isUpdateId) {
        this.isUpdateId = isUpdateId;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean isEntiry() {
        return this.isEntiry;
    }

    public void setEntiry(boolean isEntiry) {
        this.isEntiry = isEntiry;
    }

    public String getColumn() {
        return this.column;
    }

    public Field getValueField() {
        return this.valueField;
    }

    public void setValueField(Field valueField) {
        valueField.setAccessible(true);
        this.valueField = valueField;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Class<?> fieldType) {
        this.fieldType = fieldType;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setId(boolean isId) {
        this.isId = isId;
    }

    public Operation getOperation(Map<String, Object> valueMap) {
        if (this.OperationPacks != null) {
            for (OperationPack operationPack : this.OperationPacks) {
                if (!operationPack.condition(valueMap)) continue;
                return operationPack.getOperation();
            }
        }
        return this.defaultOperation;
    }

    public Operation getDefaultOperation() {
        return this.defaultOperation;
    }

    public void setDefaultOperation(Operation defaultOperation) {
        this.defaultOperation = defaultOperation;
    }

    public void setOperation(Operation operation) {
        this.defaultOperation = operation;
    }

    public void addOperationPack(OperationPack op) {
        if (this.OperationPacks == null) {
            this.OperationPacks = new ArrayList<OperationPack>();
        }
        this.OperationPacks.add(op);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public String toString() {
        return "FieldConfig [ fieldName=" + this.fieldName + ", handle=" + this.handle + ", field=" + this.field + ", fieldType=" + this.fieldType + ", column=" + this.column + ", operation=" + this.OperationPacks + "]";
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Field getSetValueField() {
        return this.setValueField;
    }

    public void setSetValueField(Field setValueField) {
        this.setValueField = setValueField;
    }

    @Override
    public int compareTo(FieldConfig o) {
        return this.compare(o);
    }

    private int compare(FieldConfig o) {
        int operate = o.defaultOperation.getOperate();
        int myOperate = this.defaultOperation.getOperate();
        int index = myOperate - operate;
        if (index != 0) {
            return index;
        }
        if (o.isId && !this.isId) {
            return -1;
        }
        if (TypeCheck.isIntegerClass(o.getFieldType()) && !TypeCheck.isIntegerClass(this.getFieldType())) {
            return -1;
        }
        return 0;
    }

    public HandleMapping<?> getHandle() {
        return this.handle;
    }

    public void setHandle(HandleMapping<?> handle) {
        this.handle = handle;
    }

    public boolean isPlaceholder() {
        return this.isPlaceholder;
    }

    public void setPlaceholder(boolean isPlaceholder) {
        this.isPlaceholder = isPlaceholder;
    }

    public boolean isUpdateCheck() {
        return this.updateCheck;
    }

    public void setUpdateCheck(boolean updateCheck) {
        this.updateCheck = updateCheck;
    }

    public void init(Class<?> bean) {
        if (this.OperationPacks != null) {
            for (OperationPack operationPack : this.OperationPacks) {
                operationPack.init(bean);
            }
        }
    }
}

