/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.config.model;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.config.model.JoinConfig;
import net.risedata.jdbc.exception.InstanceException;
import net.risedata.jdbc.factory.ConditionProxyFactory;
import net.risedata.jdbc.mapping.ColumnMapping;
import net.risedata.jdbc.search.Order;
import org.apache.commons.lang3.StringUtils;

public class BeanConfig {
    public static final int SELECT_INSERT_INDEX = 7;
    private int fromLenth = -1;
    private String allSelects;
    private Class<?> cla;
    private boolean sync;
    private String tableFrom;
    List<FieldConfig> rowMappingList;
    private String tableName;
    private String delSql;
    private Constructor<?> constructor;
    private List<Order> orders = new ArrayList<Order>();
    private Map<String, FieldConfig> fields;
    private Map<String, Integer> indexMap;
    private List<FieldConfig> fieldlist = new ArrayList<FieldConfig>();
    private List<FieldConfig> idField = new ArrayList<FieldConfig>();
    private List<JoinConfig> joins;
    private String tableAsAll;
    private String tableAs;
    private String selectTableSql;
    private List<FieldConfig> checkedField;
    private List<FieldConfig> noIdFiled = new ArrayList<FieldConfig>();
    private List<FieldConfig> allFields = new ArrayList<FieldConfig>();
    private String countTableSql;
    private List<ColumnMapping> columnMappings;
    private String checkSql;

    public List<ColumnMapping> columnMappings() {
        return this.columnMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumnMapping(ColumnMapping columnMapping) {
        if (columnMapping == null) {
            return;
        }
        if (this.columnMappings == null) {
            BeanConfig beanConfig = this;
            synchronized (beanConfig) {
                if (this.columnMappings == null) {
                    this.columnMappings = new ArrayList<ColumnMapping>();
                }
            }
        }
        this.columnMappings.add(columnMapping);
    }

    public void addJoin(JoinConfig join) {
        if (this.joins == null) {
            this.joins = new ArrayList<JoinConfig>();
        }
        this.joins.add(join);
    }

    public Object getValue(Object value, String filedName) {
        FieldConfig fieldcConfig = this.getField(filedName);
        if (fieldcConfig == null) {
            return null;
        }
        try {
            return fieldcConfig.getField().get(value);
        }
        catch (Exception e) {
            throw new InstanceException("get value error " + e.getMessage());
        }
    }

    public JoinConfig getJoin(Class<?> tableClass) {
        if (this.joins == null) {
            this.joins = new ArrayList<JoinConfig>();
        }
        for (JoinConfig join : this.joins) {
            if (join.getTableClass() != tableClass) continue;
            return join;
        }
        return null;
    }

    public void putField(String fieldName, FieldConfig fc) {
        if (!fc.isTransient()) {
            this.fieldlist.add(fc);
        }
        this.allFields.add(fc);
        if (this.fields == null) {
            this.fields = new HashMap<String, FieldConfig>();
        }
        this.fields.put(fieldName, fc);
    }

    public FieldConfig getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public Integer getIndex(String field) {
        return this.indexMap.get(field);
    }

    public Map<String, Integer> getIndexMap() {
        return this.indexMap;
    }

    public void setDelSql(String delSql) {
        this.delSql = delSql;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public void setSelectTableSql(String selectTableSql) {
        this.selectTableSql = selectTableSql;
    }

    public void setCountTableSql(String countTableSql) {
        this.countTableSql = countTableSql;
    }

    public void sort() {
        Collections.sort(this.orders);
        for (Order order : this.orders) {
            if (!StringUtils.isNotBlank((CharSequence)order.getExpression()) || order.getCondition() != null) continue;
            order.setCondition(ConditionProxyFactory.getInstance(order.getExpression(), this.cla));
        }
        Collections.sort(this.fieldlist);
        this.indexMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.fieldlist.size(); ++i) {
            this.indexMap.put(this.fieldlist.get(i).getFieldName(), i);
        }
        this.idField.clear();
        for (FieldConfig fieldConfig : this.fieldlist) {
            if (fieldConfig.isUpdateCheck()) {
                if (this.checkedField == null) {
                    this.checkedField = new ArrayList<FieldConfig>();
                }
                this.checkedField.add(fieldConfig);
            }
            if (fieldConfig.isId() || fieldConfig.isUpdateId()) {
                this.idField.add(fieldConfig);
                if (fieldConfig.isUpdateWhere()) {
                    this.noIdFiled.add(fieldConfig);
                }
            } else {
                this.noIdFiled.add(fieldConfig);
            }
            fieldConfig.init(this.cla);
        }
        this.tableAs = BeanConfig.getBeanAsName(this.cla);
        int index = 0;
        if (this.joins != null) {
            for (JoinConfig jc : this.joins) {
                jc.toSql(this.tableAs + ++index, this.tableAs);
            }
        }
        this.tableAsAll = this.tableAs + ".*";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.fieldlist.size(); ++i) {
            stringBuilder.append(this.tableAs + "." + this.fieldlist.get(i).getColumn());
            if (i == this.fieldlist.size() - 1) continue;
            stringBuilder.append(",");
        }
        this.fromLenth = stringBuilder.length() + 7;
        if (this.selectTableSql != null) {
            return;
        }
        this.selectTableSql = "SELECT " + stringBuilder + " FROM " + this.tableName + " " + this.tableAs;
        if (this.allFields.size() > this.fieldlist.size()) {
            StringBuilder selectsAll = new StringBuilder();
            for (int i = 0; i < this.allFields.size(); ++i) {
                selectsAll.append(this.tableAs + "." + this.allFields.get(i).getColumn());
                if (i == this.allFields.size() - 1) continue;
                selectsAll.append(",");
            }
            this.allSelects = "SELECT " + selectsAll.toString() + " FROM " + this.tableName + " " + this.tableAs;
        } else {
            this.allSelects = stringBuilder.toString();
        }
        this.countTableSql = "SELECT COUNT(1) COUNT FROM " + this.tableName + " " + this.tableAs;
        this.tableFrom = "FROM " + this.tableName + " " + this.tableAs;
        this.delSql = "DELETE FROM " + this.tableName;
        if (this.checkedField != null) {
            this.checkSql = " SELECT COUNT(1) FROM " + this.tableName + " ";
        }
    }

    public String getCheckSql() {
        return this.checkSql;
    }

    public void setFields(Map<String, FieldConfig> fields) {
        this.fields = fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        return "BeanConfig [cla=" + this.cla + ", tableName=" + this.tableName + ", fields=" + this.fields + "]";
    }

    public List<FieldConfig> getIdField() {
        return this.idField;
    }

    public List<FieldConfig> getNoIdField() {
        return this.noIdFiled;
    }

    public String getTableFrom() {
        return this.tableFrom;
    }

    public void setTableFrom(String tableFrom) {
        this.tableFrom = tableFrom;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void addOrder(Order order) {
        this.orders.add(order);
    }

    public List<FieldConfig> getCheckedField() {
        return this.checkedField;
    }

    public Class<?> getCla() {
        return this.cla;
    }

    public List<FieldConfig> getAllFields() {
        return this.allFields;
    }

    public String getCountTableSql() {
        return this.countTableSql;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public void setCla(Class<?> cla) {
        this.cla = cla;
    }

    public Map<String, FieldConfig> getFields() {
        return this.fields;
    }

    public String getFieldColumnNames() {
        StringBuilder sb = new StringBuilder();
        for (FieldConfig fieldConfig : this.fieldlist) {
            sb.append(fieldConfig.getColumn() + ",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String getSelectTableSql(String field, boolean isAll) {
        if (field != null) {
            return "SELECT " + field + this.selectTableSql.substring(this.fromLenth);
        }
        if (isAll) {
            return this.allSelects;
        }
        return this.selectTableSql;
    }

    public String getDelSql() {
        return this.delSql;
    }

    public String getAllSelects() {
        return this.allSelects;
    }

    public String getTableAsAll() {
        return this.tableAsAll;
    }

    public List<JoinConfig> getJoins() {
        return this.joins;
    }

    public void setJoins(List<JoinConfig> joins) {
        this.joins = joins;
    }

    public List<FieldConfig> getFieldlist() {
        return this.fieldlist;
    }

    public String getTableAs() {
        return this.tableAs;
    }

    public static String getBeanAsName(Class<?> entiry) {
        return entiry.getSimpleName();
    }

    public List<FieldConfig> getRowMappingList() {
        return this.rowMappingList == null ? this.fieldlist : this.rowMappingList;
    }

    public void setRowMappingList(List<FieldConfig> rowMappingList) {
        this.rowMappingList = rowMappingList;
    }
}

