/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.risedata.jdbc.annotations.Exclude;
import net.risedata.jdbc.annotations.join.Join;
import net.risedata.jdbc.annotations.join.NULL;
import net.risedata.jdbc.annotations.operation.Operate;
import net.risedata.jdbc.annotations.operation.OperateCollection;
import net.risedata.jdbc.annotations.order.Asc;
import net.risedata.jdbc.annotations.order.Ascs;
import net.risedata.jdbc.annotations.order.Desc;
import net.risedata.jdbc.annotations.order.Descs;
import net.risedata.jdbc.annotations.search.Sync;
import net.risedata.jdbc.annotations.searchable.Searchable;
import net.risedata.jdbc.annotations.update.Check;
import net.risedata.jdbc.annotations.update.UpdateId;
import net.risedata.jdbc.config.JdbcConfig;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.config.model.JoinConfig;
import net.risedata.jdbc.config.model.JoinFieldConfig;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.factory.ColumnMappingFactory;
import net.risedata.jdbc.factory.ConditionProxyFactory;
import net.risedata.jdbc.factory.HandleMappingFactory;
import net.risedata.jdbc.factory.OperationFactory;
import net.risedata.jdbc.mapping.HandleMapping;
import net.risedata.jdbc.mapping.impl.EntiryHandle;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.OperationInit;
import net.risedata.jdbc.operation.OperationPack;
import net.risedata.jdbc.search.Operations;
import net.risedata.jdbc.search.Order;
import net.risedata.jdbc.search.exception.FieldException;
import net.risedata.jdbc.search.exception.JoinException;
import net.risedata.jdbc.search.exception.NoEntityException;
import net.risedata.jdbc.search.exception.OperationException;
import net.risedata.jdbc.utils.FieldUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class Load {
    public static void loadBean(Class<?> entiry) {
        BeanConfig bc = new BeanConfig();
        if (BeanConfigFactory.has(entiry.getName())) {
            return;
        }
        Searchable sreachable = (Searchable)AnnotationUtils.findAnnotation(entiry, Searchable.class);
        if (sreachable != null) {
            Load.loadSreachable(sreachable, entiry);
            return;
        }
        Table e = (Table)AnnotationUtils.findAnnotation(entiry, Table.class);
        if (e == null) {
            return;
        }
        String tableName = e.name();
        bc.setTableName(tableName);
        bc.setCla(entiry);
        bc.setSync(AnnotationUtils.findAnnotation(entiry, Sync.class) != null);
        if (bc.isSync()) {
            JdbcConfig.isSync = true;
        }
        try {
            bc.setConstructor(entiry.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        HashMap<String, FieldConfig> fs = new HashMap<String, FieldConfig>();
        bc.setFields(fs);
        Map<String, Field> fieldMap = Load.createFieldMap(entiry);
        Load.loadBean(entiry, bc, fieldMap, null);
    }

    private static Map<String, Field> createFieldMap(Class<?> entiry) {
        List<Field> fields = FieldUtils.getFields(entiry);
        HashMap<String, Field> FieldMap = new HashMap<String, Field>();
        fields.forEach(f -> {
            if (Modifier.isStatic(f.getModifiers())) {
                return;
            }
            FieldMap.put("get" + f.getName(), (Field)f);
            FieldMap.put("set" + f.getName(), (Field)f);
        });
        return FieldMap;
    }

    private static void loadBean(Class<?> entiry, BeanConfig bc, Map<String, Field> fieldMap, Map<String, String> cloumMap) {
        Field item;
        int i;
        List<Field> fields = FieldUtils.getFields(entiry);
        ArrayList<Field> joinFields = new ArrayList<Field>();
        for (i = 0; i < fields.size(); ++i) {
            item = fields.get(i);
            if (Modifier.isStatic(item.getModifiers())) continue;
            item.setAccessible(true);
            if (Load.loadFieldConfig(bc, item, fieldMap, cloumMap)) continue;
            joinFields.add(item);
        }
        BeanConfigFactory.putBeanConfig(entiry, bc);
        joinFields.forEach(field -> Load.loadJoin(bc, field, fieldMap));
        for (i = 0; i < fields.size(); ++i) {
            item = fields.get(i);
            if (Modifier.isStatic(item.getModifiers())) continue;
            bc.addColumnMapping(ColumnMappingFactory.getInstance(bc, item));
        }
        bc.sort();
    }

    private static void loadSreachable(Searchable sreachable, Class<?> entiry) {
        BeanConfig bc = BeanConfigFactory.getInstance(sreachable.value());
        if (bc == null) {
            throw new NoEntityException(sreachable.value() + " undefined entiry object");
        }
        BeanConfig sreachBeanConfig = new BeanConfig();
        bc.setSync(AnnotationUtils.findAnnotation(entiry, Sync.class) != null);
        String tableName = sreachable.tableName();
        sreachBeanConfig.setCla(bc.getCla());
        sreachBeanConfig.setConstructor(bc.getConstructor());
        if (bc.isSync()) {
            JdbcConfig.isSync = true;
        }
        if (StringUtils.isBlank((CharSequence)tableName)) {
            if (sreachable.rows()) {
                sreachBeanConfig.setSelectTableSql(bc.getSelectTableSql(null, false));
                sreachBeanConfig.setDelSql(bc.getDelSql());
                sreachBeanConfig.setCountTableSql(bc.getCountTableSql());
                sreachBeanConfig.setTableFrom(bc.getTableFrom());
                sreachBeanConfig.setRowMappingList(bc.getRowMappingList());
            }
            sreachBeanConfig.setTableName(bc.getTableName());
        } else {
            tableName = tableName.toUpperCase();
            if (sreachable.rows()) {
                sreachBeanConfig.setSelectTableSql(bc.getSelectTableSql(null, false).replace(bc.getTableName(), tableName));
                sreachBeanConfig.setDelSql(bc.getDelSql().replace(bc.getTableName(), tableName));
                sreachBeanConfig.setCountTableSql(bc.getCountTableSql().replace(bc.getTableName(), tableName));
                sreachBeanConfig.setTableFrom(bc.getTableFrom().replace(bc.getTableName(), tableName));
                sreachBeanConfig.setRowMappingList(bc.getRowMappingList());
            }
            sreachBeanConfig.setTableName(tableName);
        }
        List<FieldConfig> allFieldConfigs = bc.getAllFields();
        HashMap<String, String> cloumMap = new HashMap<String, String>();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        allFieldConfigs.forEach(fc -> cloumMap.put(fc.getFieldName(), fc.getColumn()));
        List<Field> bcFields = FieldUtils.getFields(bc.getCla());
        for (Field field : bcFields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldMap.put("set" + field.getName(), field);
        }
        List<Field> fields = FieldUtils.getFields(entiry);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldMap.put("get" + field.getName(), field);
        }
        Load.loadBean(entiry, sreachBeanConfig, fieldMap, cloumMap);
    }

    private static boolean loadFieldConfig(BeanConfig bc, Field item, Map<String, Field> fieldMap, Map<String, String> cloumMap) {
        UpdateId update;
        Descs descs;
        Order order;
        Column c = item.getAnnotation(Column.class);
        if (item.getAnnotation(Exclude.class) != null) {
            return true;
        }
        if (!(c != null || cloumMap != null && cloumMap.containsKey(item.getName()))) {
            return false;
        }
        String fieldName = item.getName();
        Field getField = Load.getGetField(fieldName, fieldMap, bc.getCla());
        Field setField = Load.getSetField(fieldName, fieldMap, bc.getCla());
        FieldConfig fc = new FieldConfig();
        String column = c == null ? cloumMap.get(item.getName()) : (StringUtils.isBlank((CharSequence)c.name()) ? fieldName.toUpperCase() : c.name().toUpperCase());
        column = column.trim();
        Class<?> type = setField.getType();
        HandleMapping handle = HandleMappingFactory.getInstance(type);
        if (handle == null) {
            throw new FieldException("field" + item.getName() + " type " + type + "no handle");
        }
        Ascs ascs = item.getAnnotation(Ascs.class);
        if (ascs != null) {
            Asc[] as = ascs.value();
            for (int i = 0; i < as.length; ++i) {
                order = new Order(column, "ASC", as[i].leve());
                order.setExpression(as[i].expression());
                bc.addOrder(order);
            }
        } else {
            Asc asc = item.getAnnotation(Asc.class);
            if (asc != null) {
                Order order2 = new Order(column, "ASC", asc.leve());
                order2.setExpression(asc.expression());
                bc.addOrder(order2);
            }
        }
        if ((descs = item.getAnnotation(Descs.class)) != null) {
            Desc[] ds = descs.value();
            for (int i = 0; i < ds.length; ++i) {
                Order order3 = new Order(column, "DESC", ds[i].leve());
                order3.setExpression(ds[i].expression());
                bc.addOrder(order3);
            }
        } else {
            Desc desc = item.getAnnotation(Desc.class);
            if (desc != null) {
                order = new Order(column, "DESC", desc.leve());
                order.setExpression(desc.expression());
                bc.addOrder(order);
            }
        }
        fc.setUpdateCheck(item.getAnnotation(Check.class) != null);
        fc.setTransient(item.getAnnotation(Transient.class) != null && item.getAnnotation(Join.class) == null);
        fc.setHandle(handle);
        fc.setFieldType(type);
        fc.setField(item);
        fc.setFieldName(item.getName());
        fc.setValueField(getField);
        fc.setColumn(column);
        Load.loadCollection(item, fc, bc);
        if (fc.getDefaultOperation() == null) {
            fc.setOperation(OperationFactory.getDefaultOperation(item));
        }
        fc.setSetValueField(setField);
        bc.putField(item.getName(), fc);
        if (item.getAnnotation(Id.class) != null) {
            fc.setId(true);
        }
        if ((update = item.getAnnotation(UpdateId.class)) != null) {
            fc.setUpdateId(true);
            fc.setUpdateWhere(update.isUpdate());
            fc.setPlaceholder(update.isPlaceholder());
        }
        return true;
    }

    private static void loadCollection(Field field, FieldConfig fc, BeanConfig bc) {
        Operate[] valuess;
        OperateCollection ops = field.getAnnotation(OperateCollection.class);
        Operation op = null;
        if (ops != null && (valuess = ops.value()).length > 0) {
            for (Operate operate : valuess) {
                op = operate.value().value;
                if (op == Operations.PLACEHOLDER) {
                    if (operate.operation() == Operations.PLACEHOLDER.getClass()) {
                        throw new OperationException(bc.getCla() + " filed " + field.getName() + " Use placeholders but do not define their own operations ");
                    }
                    op = OperationFactory.getOperation(operate.operation());
                    if (op instanceof OperationInit) {
                        OperationInit opInit = (OperationInit)((Object)op);
                        opInit.initial(bc.getCla(), field);
                    }
                }
                if (StringUtils.isBlank((CharSequence)operate.expression())) {
                    if (fc.getDefaultOperation() == null) {
                        fc.setDefaultOperation(op);
                        continue;
                    }
                    throw new OperationException(bc.getCla() + " filed " + field.getName() + " There can only be one default operation");
                }
                fc.addOperationPack(new OperationPack(operate.expression(), op));
            }
        }
    }

    private static Field getSetField(String fieldName, Map<String, Field> fieldMap, Class<?> boot) {
        String setName = "set" + fieldName;
        Field f = fieldMap.get(setName);
        if (f == null) {
            throw new NullPointerException(fieldName + " is set null");
        }
        f.setAccessible(true);
        return f;
    }

    private static Field getGetField(String fieldName, Map<String, Field> FieldMap, Class<?> boot) {
        Field f = FieldMap.get("get" + fieldName);
        if (f == null) {
            throw new NullPointerException(fieldName + "  is get null");
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean loadJoin(BeanConfig bc, Field item, Map<String, Field> fieldMap) {
        Join j = item.getAnnotation(Join.class);
        if (j == null) {
            return false;
        }
        JoinConfig jc = bc.getJoin(j.value());
        if (jc == null || jc.isFunction()) {
            jc = new JoinConfig();
            if (StringUtils.isNotBlank((CharSequence)j.function())) {
                jc.setFunction(true);
            }
            if (j.value() == NULL.class) {
                if (StringUtils.isBlank((CharSequence)j.function())) {
                    throw new JoinException("joined class no config or function is null");
                }
            } else {
                BeanConfig bc2 = BeanConfigFactory.getInstance(j.value());
                jc.setTableClass(j.value());
                if (bc2 == null) {
                    throw new JoinException("joined class no config ");
                }
                jc.setJoinBean(bc2);
                jc.setTableName(bc2.getTableName());
            }
            jc.setMyBean(bc);
            bc.addJoin(jc);
        }
        if (j.joinId().length > 0 && StringUtils.isNotBlank((CharSequence)j.joinId()[0])) {
            if (jc.getJoinId() != null) {
                throw new FieldException(item.getName() + "\u8fde\u63a5\u8868\u914d\u7f6e" + j.toId() + "\u4e00\u4e2a\u8868\u7684joinid\u5df2\u7ecf\u88ab\u914d\u7f6e\u4e86\u4e0d\u5141\u8bb8\u91cd\u590d\u914d\u7f6e \u5728\u4e00\u4e2a\u5b57\u6bb5\u4e0a\u914d\u7f6e\u5373\u53ef");
            }
            jc.setJoinId(j.joinId());
        }
        if (j.toId().length > 0 && StringUtils.isNotBlank((CharSequence)j.toId()[0])) {
            if (jc.getToId() != null) {
                throw new FieldException(item.getName() + "\u8fde\u63a5\u8868\u914d\u7f6e" + j.toId() + "\u4e00\u4e2a\u8868\u7684toid\u5df2\u7ecf\u88ab\u914d\u7f6e\u4e86\u4e0d\u5141\u8bb8\u91cd\u590d\u914d\u7f6e \u5728\u4e00\u4e2a\u5b57\u6bb5\u4e0a\u914d\u7f6e\u5373\u53ef");
            }
            jc.setToId(j.toId());
        }
        if (StringUtils.isNotBlank((CharSequence)j.where())) {
            jc.setWhere(j.where());
        }
        if (StringUtils.isNotBlank((CharSequence)j.field()) || EntiryHandle.isEntiryHandle(item.getType())) {
            JoinFieldConfig jfc = new JoinFieldConfig();
            Field setField = Load.getSetField(item.getName(), fieldMap, bc.getCla());
            FieldConfig fc = new FieldConfig();
            jfc.setFc(fc);
            fc.setSetValueField(setField);
            fc.setFieldType(setField.getType());
            fc.setField(item);
            fc.setId(false);
            jfc.setFunction(j.function());
            jfc.setAutoFunction(j.isAutoFunction());
            HandleMapping handle = HandleMappingFactory.getInstance(fc.getFieldType());
            if (handle == null) {
                if (!EntiryHandle.isEntiryHandle(setField.getType())) throw new FieldException(item.getName() + " null mapping handle ");
                BeanConfig fieldConfig = BeanConfigFactory.getInstance(setField.getType());
                ArrayList<FieldConfig> fields = new ArrayList<FieldConfig>();
                for (FieldConfig fc2 : fieldConfig.getFieldlist()) {
                    FieldConfig ff2 = new FieldConfig();
                    ff2.setHandle(fc2.getHandle());
                    ff2.setId(fc2.isId());
                    ff2.setField(fc2.getField());
                    ff2.setSetValueField(fc2.getSetValueField());
                    ff2.setFieldType(fc2.getFieldType());
                    ff2.setFieldName(fc2.getFieldName());
                    ff2.setColumn(fc2.getColumn());
                    fields.add(ff2);
                }
                fc.setEntiry(true);
                jfc.setFields(fields);
                fc.setHandle(new EntiryHandle(fields, fieldConfig));
            } else if (j.field().length() > 0) {
                jfc.setColumn(j.field());
            } else if (j.value() != NULL.class) {
                FieldConfig ff = BeanConfigFactory.getInstance(j.value()).getField(j.field());
                if (ff != null) {
                    jfc.setColumn(ff.getColumn());
                } else {
                    if (!jc.isFunction()) throw new FieldException(item.getName() + " null joined fieldConfig ");
                    jfc.setColumn(j.field());
                }
            } else {
                jfc.setColumn(item.getName());
            }
            if (!fc.isEntiry()) {
                fc.setHandle(handle);
            }
            jc.addField(jfc);
        }
        if (!StringUtils.isNotBlank((CharSequence)j.expression())) return true;
        if (jc.getCondition() != null) {
            throw new JoinException(item.getName() + " join table expression  exist!!");
        }
        jc.setCondition(ConditionProxyFactory.getInstance(j.expression(), bc.getCla()));
        return true;
    }
}

