/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.config;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.persistence.Table;
import javax.sql.DataSource;
import net.risedata.jdbc.commons.utils.ClassTools;
import net.risedata.jdbc.config.JdbcScan;
import net.risedata.jdbc.config.Load;
import net.risedata.jdbc.exception.ConfigException;
import net.risedata.jdbc.executor.delete.Delete;
import net.risedata.jdbc.executor.delete.DeleteExecutor;
import net.risedata.jdbc.executor.delete.impl.DefaultDeleteExecutor;
import net.risedata.jdbc.executor.insert.Insert;
import net.risedata.jdbc.executor.insert.InsertExecutor;
import net.risedata.jdbc.executor.insert.impl.DefaultInsertExecutor;
import net.risedata.jdbc.executor.jdbc.JdbcExecutor;
import net.risedata.jdbc.executor.jdbc.impl.JdbcTemplateExecutor;
import net.risedata.jdbc.executor.log.PrintExecutor;
import net.risedata.jdbc.executor.log.impl.DefaultPrintExecutor;
import net.risedata.jdbc.executor.page.PageExecutor;
import net.risedata.jdbc.executor.page.impl.DerbyPageExecutor;
import net.risedata.jdbc.executor.page.impl.MysqlPageExecutor;
import net.risedata.jdbc.executor.page.impl.OraclePageExecutor;
import net.risedata.jdbc.executor.search.Search;
import net.risedata.jdbc.executor.search.SearchExecutor;
import net.risedata.jdbc.executor.search.impl.DefaultSearchExecutor;
import net.risedata.jdbc.executor.sync.SyncService;
import net.risedata.jdbc.executor.table.TableExecutor;
import net.risedata.jdbc.executor.table.impl.DefaultTableExecutor;
import net.risedata.jdbc.executor.update.Update;
import net.risedata.jdbc.executor.update.UpdateExecutor;
import net.risedata.jdbc.executor.update.impl.DefaultUpdateExecutor;
import net.risedata.jdbc.factory.InstanceFactoryManager;
import net.risedata.jdbc.factory.impl.SpringApplicationFactory;
import net.risedata.jdbc.mapping.columns.OneToManyColumnMapping;
import net.risedata.jdbc.repository.proxy.RepositoryCreateFactory;
import net.risedata.jdbc.utils.Log;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class JdbcConfig
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcConfig.class);
    public static final String SHOW_SQL_CONFIG = "net.risedata.jdbc.show.sql";
    public static final String DATASOURCE_TYPE = "net.risedata.jdbc.type";
    private static final String DATASOURCE_TYPE_ORACLE = "oracle";
    private static final String DATASOURCE_TYPE_MYSQL = "mysql";
    private static final String DATASOURCE_TYPE_DERBY = "derby";
    @Value(value="${net.risedata.jdbc.show.sql:true}")
    private boolean isShow;
    @Value(value="${net.risedata.jdbc.type:}")
    private String type;
    public static SyncService SYNC;
    public static boolean isSync;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map objects = event.getApplicationContext().getBeansWithAnnotation(SpringBootApplication.class);
        Log.setDefaultPrintExecutor((PrintExecutor)event.getApplicationContext().getBean(PrintExecutor.class));
        Log.print("start ---- jdbc ");
        InstanceFactoryManager.init(new SpringApplicationFactory(event.getApplicationContext()));
        if (objects.keySet().size() > 0) {
            objects.forEach((k, v) -> {
                JdbcScan lScan = (JdbcScan)AnnotationUtils.findAnnotation(v.getClass(), JdbcScan.class);
                if (lScan != null) {
                    int count = 0;
                    long startTime = System.currentTimeMillis();
                    if (!StringUtils.isEmpty((CharSequence)lScan.value()[0])) {
                        List classs = null;
                        String[] paths = lScan.value();
                        for (int i = 0; i < paths.length; ++i) {
                            classs = ClassTools.getClasses((String)paths[i]);
                            for (Class class1 : classs) {
                                if (AnnotationUtils.findAnnotation((Class)class1, Table.class) == null) continue;
                                ++count;
                                Load.loadBean(class1);
                            }
                        }
                        Log.print("load entiry" + count + " time for " + (System.currentTimeMillis() - startTime));
                    }
                }
            });
        }
        if (isSync) {
            SYNC = (SyncService)event.getApplicationContext().getBean(SyncService.class);
        }
    }

    @ConditionalOnMissingBean(value={PageExecutor.class})
    @Bean
    public PageExecutor getPageExecutor(DataSource dataSource) {
        String url = null;
        try {
            if (StringUtils.isEmpty((CharSequence)this.type)) {
                url = dataSource.getConnection().getMetaData().getURL();
                this.type = url.substring(5, url.indexOf(":", 5));
            }
        }
        catch (SQLException e) {
            LOGGER.info("select page error:" + e.getMessage());
        }
        LOGGER.info("page type=" + this.type);
        switch (this.type) {
            case "oracle": 
            case "dm": {
                return new OraclePageExecutor();
            }
            case "mysql": 
            case "kingbase": 
            case "postgresql": {
                return new MysqlPageExecutor();
            }
            case "derby": {
                return new DerbyPageExecutor();
            }
        }
        throw new ConfigException(" The specified database does not have a corresponding paging implementation. Please add it manually");
    }

    @ConditionalOnMissingBean(value={JdbcExecutor.class})
    @Bean
    public JdbcExecutor getJdbcExecutor(JdbcTemplate jt, PrintExecutor print) {
        if (this.isShow) {
            return net.risedata.jdbc.factory.LoggerFactory.getInstance(new JdbcTemplateExecutor(jt), JdbcExecutor.class, print);
        }
        return new JdbcTemplateExecutor(jt);
    }

    @ConditionalOnMissingBean(value={SearchExecutor.class})
    @Bean
    public SearchExecutor getSearchExecutor(JdbcExecutor je, PageExecutor pageExecutor) {
        DefaultSearchExecutor search = new DefaultSearchExecutor(je, pageExecutor);
        Search.setSearchExecutor(search);
        return search;
    }

    @ConditionalOnMissingBean(value={InsertExecutor.class})
    @Bean
    public InsertExecutor getInsertExecutor(JdbcExecutor je) {
        DefaultInsertExecutor insertExecutor = new DefaultInsertExecutor(je);
        Insert.setInsertExecutor(insertExecutor);
        return insertExecutor;
    }

    @ConditionalOnMissingBean(value={UpdateExecutor.class})
    @Bean
    public UpdateExecutor getUpdateExecutor(JdbcExecutor je) {
        DefaultUpdateExecutor update = new DefaultUpdateExecutor(je);
        Update.setUpdateExecutor(update);
        return update;
    }

    @ConditionalOnMissingBean(value={DeleteExecutor.class})
    @Bean
    public DeleteExecutor getDeleteExecutor(JdbcExecutor je) {
        DefaultDeleteExecutor deleteExecutor = new DefaultDeleteExecutor(je);
        Delete.setDeleteExecutor(deleteExecutor);
        return deleteExecutor;
    }

    @ConditionalOnMissingBean(value={TableExecutor.class})
    @Bean
    public TableExecutor getTableExecutor(JdbcExecutor je) {
        return new DefaultTableExecutor(je);
    }

    @ConditionalOnMissingBean(value={PrintExecutor.class})
    @Bean
    public DefaultPrintExecutor getPrintExecutor() {
        return new DefaultPrintExecutor();
    }

    @Bean
    public OneToManyColumnMapping getOneToManyColumnMapping() {
        return new OneToManyColumnMapping();
    }

    @Bean
    public RepositoryCreateFactory getRepositoryCreateFactory() {
        return new RepositoryCreateFactory();
    }
}

