/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.condition.parse.impl;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.risedata.jdbc.condition.parse.impl.BaseParse;
import net.risedata.jdbc.condition.parse.impl.StringParse;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.search.exception.IfHandleException;

public class LikeParse
extends BaseParse {
    public static final String rgex = "\\#like\\{(.*?)\\}";
    public static final Pattern p = Pattern.compile("\\#like\\{(.*?)\\}");

    @Override
    public Pattern getPattern() {
        return p;
    }

    @Override
    public String parse(String group, BeanConfig bc, Matcher m) {
        String fieldName = m.group(1);
        List<String> parameters = this.getParameter(fieldName);
        if (parameters.size() != 2) {
            throw new IfHandleException(" eq parameter size != 2 ");
        }
        String p1 = this.getParameterValue(parameters.get(0));
        String p2 = this.getParameterValue(parameters.get(1));
        return "(" + StringParse.getStringOrToString(p1) + ".indexOf(" + StringParse.getStringOrToString(p2) + ") != -1)";
    }
}

