/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.condition.parse.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.risedata.jdbc.condition.parse.Parse;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;

public class GetValueParse
implements Parse {
    public static final String rgex = "\\#\\{(.*?)\\}";
    public static final Pattern p = Pattern.compile("\\#\\{(.*?)\\}");
    private static final Map<String, Class<?>> KEY_TYPE_MAPPING = new HashMap();

    @Override
    public Pattern getPattern() {
        return p;
    }

    @Override
    public String parse(String group, BeanConfig bc, Matcher m) {
        String fieldName = m.group(1);
        FieldConfig fc = bc.getField(fieldName);
        if (fc != null) {
            return "((" + fc.getValueField().getType().getName() + ")$value.get(\"" + fieldName + "\"))";
        }
        Class<?> typeClass = KEY_TYPE_MAPPING.get(fieldName);
        if (typeClass != null) {
            return "((" + typeClass.getName() + ")$value.get(\"" + fieldName + "\"))";
        }
        return "$value.get(\"" + fieldName + "\")";
    }

    public static String getType(String str) {
        if (GetValueParse.hasCast(str)) {
            return str.substring(2, str.indexOf(")"));
        }
        return null;
    }

    public static boolean hasCast(String str) {
        return str.charAt(0) == '(' && str.charAt(str.length() - 1) == ')' && str.charAt(1) == '(';
    }

    static {
        KEY_TYPE_MAPPING.put("$SQL", StringBuilder.class);
    }
}

