/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.condition.parse.impl;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.risedata.jdbc.condition.parse.impl.BaseParse;
import net.risedata.jdbc.condition.parse.impl.GetValueParse;
import net.risedata.jdbc.condition.parse.impl.TypeParse;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.search.exception.IfHandleException;
import net.risedata.jdbc.type.parse.TypeParseHandle;

public class EQParse
extends BaseParse {
    public static final String rgex = "\\#eq\\{(.*?)\\}";
    public static final Pattern p = Pattern.compile("\\#eq\\{(.*?)\\}");

    @Override
    public Pattern getPattern() {
        return p;
    }

    @Override
    public String parse(String group, BeanConfig bc, Matcher m) {
        TypeParseHandle tph;
        String type;
        String fieldName = m.group(1);
        List<String> parameters = this.getParameter(fieldName);
        if (parameters.size() != 2) {
            throw new IfHandleException(" eq parameter size != 2 ");
        }
        String p1 = this.getParameterValue(parameters.get(0));
        String p2 = this.getParameterValue(parameters.get(1));
        if (this.isNumber(p1) && (type = GetValueParse.getType(p2)) != null && (tph = TypeParse.getParse(type)) != null) {
            return tph.parseValue(p1, type) + " == " + p2;
        }
        return p1 + ".equals(" + p2 + ")";
    }
}

