/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.condition.parse.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.risedata.jdbc.condition.parse.Parse;

public abstract class BaseParse
implements Parse {
    public static final String rgex = "\\$\\<(.*?)\\>";
    public static final Pattern p = Pattern.compile("\\$\\<(.*?)\\>");
    public static final Pattern NUMBER = Pattern.compile("^-?\\d+(\\.\\d+)?$");

    protected boolean isNumber(String str) {
        return NUMBER.matcher(str).matches();
    }

    protected List<String> getParameter(String expression) {
        Matcher m = p.matcher(expression);
        ArrayList<String> ret = new ArrayList<String>();
        while (m.find()) {
            ret.add(m.group());
        }
        return ret;
    }

    protected String getParameterValue(String expression) {
        Matcher m = p.matcher(expression);
        return m.find() ? m.group(1) : null;
    }

    protected String getParameterStr(String expression) {
        return "$<" + expression + ">";
    }
}

