/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9.sqlddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPaginationUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlPaginationUtil.class);
    private static String dbType;
    private static int dbVersion;

    private SqlPaginationUtil() {
        throw new IllegalStateException("SqlPaginationUtil Utility class");
    }

    public static String generatePagedSql(DataSource ds, String sql, int start, int limit) throws Exception {
        String rSql = "";
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        if (dbType == null) {
            try (Connection connection = ds.getConnection();){
                DatabaseMetaData dbmd = connection.getMetaData();
                String databaseName = dbmd.getDatabaseProductName().toLowerCase();
                if (databaseName.indexOf("mysql") > -1) {
                    dbType = "mysql";
                } else if (databaseName.indexOf("oracle") > -1) {
                    dbType = "oracle";
                } else if (databaseName.indexOf("microsoft") > -1) {
                    dbType = "mssql";
                }
                dbVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (SQLException e) {
                log.error(e.getMessage());
            }
        }
        rSql = SqlPaginationUtil.generatePagedSql(dbType, dbVersion, sql, start, limit);
        return rSql;
    }

    public static String generatePagedSql(String databaseType, int databaseVersion, String sql, int start, int limit) throws Exception {
        Object rSql = "";
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        if ("mysql".equalsIgnoreCase(databaseType)) {
            rSql = sql + " limit " + start + "," + limit;
        } else if ("mssql".equalsIgnoreCase(databaseType)) {
            rSql = databaseVersion >= 12 ? (sql.toLowerCase().contains(" order by ") ? sql + " OFFSET " + start + " ROW FETCH NEXT " + limit + " rows only" : "SELECT TOP " + limit + " A.* FROM ( SELECT ROW_NUMBER() OVER (ORDER BY (select NULL)) AS RowNumber,B.* FROM ( " + sql + ") B ) A WHERE A.RowNumber > " + start) : "SELECT TOP " + limit + " A.* FROM ( SELECT ROW_NUMBER() OVER (ORDER BY (select NULL)) AS RowNumber,B.* FROM ( " + sql + ") B ) A WHERE A.RowNumber > " + start;
        } else if ("oracle".equalsIgnoreCase(databaseType)) {
            rSql = "select * from (select mytable.*,rownum as my_rownum from (" + sql + ") mytable) where my_rownum<=" + (start + limit) + " and my_rownum>" + start;
        }
        return rSql;
    }
}

