/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9.sqlddl;

import javax.sql.DataSource;
import net.risesoft.y9.sqlddl.DbMetaDataUtil;
import net.risesoft.y9.sqlddl.DdlDm;
import net.risesoft.y9.sqlddl.DdlKingbase;
import net.risesoft.y9.sqlddl.DdlMssql;
import net.risesoft.y9.sqlddl.DdlMysql;
import net.risesoft.y9.sqlddl.DdlOracle;

public class DdlUtil {
    private DdlUtil() {
        throw new IllegalStateException("Ddl Utility class");
    }

    public static void addTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        String dbType = DbMetaDataUtil.getDatabaseDialectName(dataSource);
        if ("mysql".equalsIgnoreCase(dbType)) {
            DdlMysql.addTableColumn(dataSource, tableName, jsonDbColumns);
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            DdlOracle.addTableColumn(dataSource, tableName, jsonDbColumns);
        } else if ("mssql".equalsIgnoreCase(dbType)) {
            DdlMssql.addTableColumn(dataSource, tableName, jsonDbColumns);
        } else if ("dm".equalsIgnoreCase(dbType)) {
            DdlDm.addTableColumn(dataSource, tableName, jsonDbColumns);
        } else if ("kingbase".equalsIgnoreCase(dbType)) {
            DdlKingbase.addTableColumn(dataSource, tableName, jsonDbColumns);
        }
    }

    public static void alterTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        String dbType = DbMetaDataUtil.getDatabaseDialectName(dataSource);
        if ("mysql".equalsIgnoreCase(dbType)) {
            DdlMysql.alterTableColumn(dataSource, tableName, jsonDbColumns);
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            DdlOracle.alterTableColumn(dataSource, tableName, jsonDbColumns);
        } else if ("mssql".equalsIgnoreCase(dbType)) {
            DdlMssql.alterTableColumn(dataSource, tableName, jsonDbColumns);
        } else if ("dm".equalsIgnoreCase(dbType)) {
            DdlDm.alterTableColumn(dataSource, tableName, jsonDbColumns);
        } else if ("kingbase".equalsIgnoreCase(dbType)) {
            DdlKingbase.alterTableColumn(dataSource, tableName, jsonDbColumns);
        }
    }

    public static void dropTable(DataSource dataSource, String tableName) throws Exception {
        String dbType = DbMetaDataUtil.getDatabaseDialectName(dataSource);
        if ("mysql".equalsIgnoreCase(dbType)) {
            DdlMysql.dropTable(dataSource, tableName);
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            DdlOracle.dropTable(dataSource, tableName);
        } else if ("mssql".equalsIgnoreCase(dbType)) {
            DdlMssql.dropTable(dataSource, tableName);
        } else if ("dm".equalsIgnoreCase(dbType)) {
            DdlDm.dropTable(dataSource, tableName);
        } else if ("kingbase".equalsIgnoreCase(dbType)) {
            DdlKingbase.dropTable(dataSource, tableName);
        }
    }

    public static void dropTableColumn(DataSource dataSource, String tableName, String columnName) throws Exception {
        String dbType = DbMetaDataUtil.getDatabaseDialectName(dataSource);
        if ("mysql".equalsIgnoreCase(dbType)) {
            DdlMysql.dropTableColumn(dataSource, tableName, columnName);
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            DdlOracle.dropTableColumn(dataSource, tableName, columnName);
        } else if ("mssql".equalsIgnoreCase(dbType)) {
            DdlMssql.dropTableColumn(dataSource, tableName, columnName);
        } else if ("dm".equalsIgnoreCase(dbType)) {
            DdlDm.dropTableColumn(dataSource, tableName, columnName);
        } else if ("kingbase".equalsIgnoreCase(dbType)) {
            DdlKingbase.dropTableColumn(dataSource, tableName, columnName);
        }
    }

    public static void renameTable(DataSource dataSource, String tableNameOld, String tableNameNew) throws Exception {
        String dbType = DbMetaDataUtil.getDatabaseDialectName(dataSource);
        if ("mysql".equalsIgnoreCase(dbType)) {
            DdlMysql.renameTable(dataSource, tableNameOld, tableNameNew);
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            DdlOracle.renameTable(dataSource, tableNameOld, tableNameNew);
        } else if ("mssql".equalsIgnoreCase(dbType)) {
            DdlMssql.renameTable(dataSource, tableNameOld, tableNameNew);
        } else if ("dm".equalsIgnoreCase(dbType)) {
            DdlDm.renameTable(dataSource, tableNameOld, tableNameNew);
        } else if ("kingbase".equalsIgnoreCase(dbType)) {
            DdlKingbase.renameTable(dataSource, tableNameOld, tableNameNew);
        }
    }
}

