/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9.sqlddl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import javax.sql.DataSource;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.sqlddl.DbMetaDataUtil;
import net.risesoft.y9.sqlddl.pojo.DbColumn;

public class DdlMysql {
    private DdlMysql() {
        throw new IllegalStateException("DdlMysql Utility class");
    }

    public static void addTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        DbColumn[] dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class));
        if (DbMetaDataUtil.checkTableExist(dataSource, tableName)) {
            for (DbColumn dbc : dbcs) {
                String ddl = "ALTER TABLE " + tableName + " ADD COLUMN " + dbc.getColumnName() + " ";
                String sType = dbc.getTypeName().toUpperCase();
                ddl = "CHAR".equals(sType) || "VARCHAR".equals(sType) ? ddl + sType + "(" + dbc.getDataLength() + ")" : ("DECIMAL".equals(sType) || "NUMERIC".equals(sType) ? (dbc.getDataScale() == null ? ddl + sType + "(" + dbc.getDataLength() + ")" : ddl + sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")") : ddl + sType);
                ddl = dbc.getNullable() != false ? ddl + " DEFAULT NULL" : ddl + " NOT NULL";
                if (dbc.getComment().length() > 0) {
                    ddl = ddl + " COMMENT '" + dbc.getComment() + "'";
                }
                DbMetaDataUtil.executeDdl(dataSource, ddl);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE " + tableName + " (\r\n").append("id varchar(38) NOT NULL, \r\n").append("processInstanceId varchar(64) NOT NULL, \r\n").append("createTime datetime NOT NULL, \r\n").append("updateTime datetime NOT NULL, \r\n").append("tabindex double DEFAULT 1, \r\n");
            for (DbColumn dbc : dbcs) {
                String columnName = dbc.getColumnName();
                if ("id".equalsIgnoreCase(columnName) || "processInstanceId".equalsIgnoreCase(columnName) || "createTime".equalsIgnoreCase(columnName) || "updateTime".equalsIgnoreCase(columnName) || "tabindex".equalsIgnoreCase(columnName)) continue;
                sb.append(columnName).append(" ");
                String sType = dbc.getTypeName().toUpperCase();
                if ("CHAR".equals(sType) || "VARCHAR".equals(sType)) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else if ("DECIMAL".equals(sType) || "NUMERIC".equals(sType)) {
                    if (dbc.getDataScale() == null) {
                        sb.append(sType + "(" + dbc.getDataLength() + ")");
                    } else {
                        sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                    }
                } else {
                    sb.append(sType);
                }
                if (!dbc.getNullable().booleanValue()) {
                    sb.append(" NOT NULL");
                }
                if (dbc.getComment().length() > 0) {
                    sb.append(" COMMENT '" + dbc.getComment() + "'");
                }
                sb.append(",\r\n");
            }
            sb.append("PRIMARY KEY (id) \r\n").append(")");
            DbMetaDataUtil.executeDdl(dataSource, sb.toString());
        }
    }

    public static void alterTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        DbColumn[] dbcs;
        if (!DbMetaDataUtil.checkTableExist(dataSource, tableName)) {
            throw new Exception("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8fd9\u4e2a\u8868\uff1a" + tableName);
        }
        for (DbColumn dbc : dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class))) {
            String ddl = "ALTER TABLE " + tableName;
            ddl = dbc.getColumnName().equalsIgnoreCase(dbc.getColumnNameOld()) ? ddl + " MODIFY COLUMN " + dbc.getColumnName() + " " : ddl + " CHANGE COLUMN " + dbc.getColumnNameOld() + " " + dbc.getColumnName() + " ";
            String sType = dbc.getTypeName().toUpperCase();
            ddl = "CHAR".equals(sType) || "VARCHAR".equals(sType) ? ddl + sType + "(" + dbc.getDataLength() + ")" : ("DECIMAL".equals(sType) || "NUMERIC".equals(sType) ? (dbc.getDataScale() == null ? ddl + sType + "(" + dbc.getDataLength() + ")" : ddl + sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")") : ddl + sType);
            ddl = dbc.getNullable() != false ? ddl + " DEFAULT NULL" : ddl + " NOT NULL";
            if (dbc.getComment().length() > 0) {
                ddl = ddl + " COMMENT '" + dbc.getComment() + "'";
            }
            DbMetaDataUtil.executeDdl(dataSource, ddl);
        }
    }

    public static void dropTable(DataSource dataSource, String tableName) throws Exception {
        DbMetaDataUtil.executeDdl(dataSource, "DROP TABLE " + tableName);
    }

    public static void dropTableColumn(DataSource dataSource, String tableName, String columnName) throws Exception {
        DbMetaDataUtil.executeDdl(dataSource, "ALTER TABLE " + tableName + " DROP COLUMN " + columnName);
    }

    public static void renameTable(DataSource dataSource, String tableNameOld, String tableNameNew) throws Exception {
        DbMetaDataUtil.executeDdl(dataSource, "ALTER TABLE " + tableNameOld + " RENAME " + tableNameNew);
    }
}

