/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9.sqlddl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.sqlddl.DbMetaDataUtil;
import net.risesoft.y9.sqlddl.pojo.DbColumn;
import org.apache.commons.lang3.StringUtils;

public class DdlKingbase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        StringBuilder sb = new StringBuilder();
        DbColumn[] dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class));
        if (DbMetaDataUtil.checkTableExist(dataSource, tableName)) {
            for (DbColumn dbc : dbcs) {
                String columnName = dbc.getColumnName();
                sb = new StringBuilder();
                sb.append("ALTER TABLE \"" + tableName + "\"");
                String nullable = "";
                String dbColumnName = "";
                try (ResultSet rs = null;
                     Connection connection = dataSource.getConnection();){
                    DatabaseMetaData dbmd = connection.getMetaData();
                    String tableSchema = dbmd.getUserName().toUpperCase();
                    rs = dbmd.getColumns(null, tableSchema, tableName, dbc.getColumnName().toUpperCase());
                    while (rs.next()) {
                        nullable = rs.getString("is_nullable");
                        dbColumnName = rs.getString("column_name".toLowerCase());
                    }
                }
                boolean add = false;
                if ("".equals(dbColumnName) && StringUtils.isBlank((CharSequence)dbc.getColumnNameOld())) {
                    sb.append(" ADD " + dbc.getColumnName() + " ");
                    add = true;
                } else if (columnName.equalsIgnoreCase(dbc.getColumnNameOld()) || StringUtils.isBlank((CharSequence)dbc.getColumnNameOld())) {
                    sb.append(" ALTER COLUMN " + dbc.getColumnName() + " TYPE ");
                } else {
                    try {
                        StringBuilder sb1 = new StringBuilder();
                        sb1.append("ALTER TABLE \"" + tableName + "\"");
                        DbMetaDataUtil.executeDdl(dataSource, sb1.append(" RENAME COLUMN " + dbc.getColumnNameOld() + " TO " + dbc.getColumnName()).toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    sb.append(" ALTER COLUMN " + dbc.getColumnName() + " TYPE ");
                }
                String sType = dbc.getTypeName().toUpperCase();
                if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                    sb.append(sType + "(" + dbc.getDataLength() + " char)");
                } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                    if (dbc.getDataScale() == null) {
                        sb.append(sType + "(" + dbc.getDataLength() + ")");
                    } else {
                        sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                    }
                } else {
                    sb.append(sType);
                }
                DbMetaDataUtil.executeDdl(dataSource, sb.toString());
                if ("".equals(nullable) && add) {
                    if (!Boolean.TRUE.equals(dbc.getNullable())) {
                        sb = new StringBuilder();
                        sb.append("ALTER TABLE \"" + tableName + "\"");
                        sb.append(" ALTER COLUMN " + dbc.getColumnName() + " SET NOT NULL");
                        DbMetaDataUtil.executeDdl(dataSource, sb.toString());
                    }
                } else {
                    if (Boolean.TRUE.equals(dbc.getNullable()) && "NO".equals(nullable)) {
                        sb = new StringBuilder();
                        sb.append("ALTER TABLE \"" + tableName + "\"");
                        sb.append(" ALTER COLUMN " + dbc.getColumnName() + " DROP NOT NULL");
                        DbMetaDataUtil.executeDdl(dataSource, sb.toString());
                    }
                    if (!Boolean.TRUE.equals(dbc.getNullable()) && "YES".equals(nullable)) {
                        sb = new StringBuilder();
                        sb.append("ALTER TABLE \"" + tableName + "\"");
                        sb.append(" ALTER COLUMN " + dbc.getColumnName() + " SET NOT NULL");
                        DbMetaDataUtil.executeDdl(dataSource, sb.toString());
                    }
                }
                if (!org.springframework.util.StringUtils.hasText((String)dbc.getComment())) continue;
                DbMetaDataUtil.executeDdl(dataSource, "COMMENT ON COLUMN \"" + tableName + "\"." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'");
            }
        }
    }

    public static void alterTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        DbColumn[] dbcs;
        if (!DbMetaDataUtil.checkTableExist(dataSource, tableName)) {
            throw new Exception("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8fd9\u4e2a\u8868\uff1a" + tableName);
        }
        for (DbColumn dbc : dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class))) {
            DbColumn column;
            if (!org.springframework.util.StringUtils.hasText((String)dbc.getColumnNameOld())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE \"" + tableName + "\"");
            if (!dbc.getColumnName().equalsIgnoreCase(dbc.getColumnNameOld())) {
                try {
                    DbMetaDataUtil.executeDdl(dataSource, sb.append(" RENAME COLUMN " + dbc.getColumnNameOld() + " TO " + dbc.getColumnName()).toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sb.append(" MODIFY " + dbc.getColumnName() + " ");
            String sType = dbc.getTypeName().toUpperCase();
            if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                sb.append(sType + "(" + dbc.getDataLength() + " char)");
            } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                if (dbc.getDataScale() == null) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else {
                    sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                }
            } else {
                sb.append(sType);
            }
            List<DbColumn> list = DbMetaDataUtil.listAllColumns(dataSource, tableName, dbc.getColumnNameOld());
            if (list != null && !list.isEmpty()) {
                column = list.get(0);
                if (Boolean.TRUE.equals(dbc.getNullable())) {
                    if (Boolean.FALSE.equals(column.getNullable())) {
                        sb.append(" NULL");
                    }
                } else if (Boolean.TRUE.equals(column.getNullable())) {
                    sb.append(" NOT NULL");
                }
            }
            DbMetaDataUtil.executeDdl(dataSource, sb.toString());
            if (!org.springframework.util.StringUtils.hasText((String)dbc.getComment()) || list == null || list.isEmpty() || (column = list.get(0)).getComment().equals(dbc.getComment())) continue;
            DbMetaDataUtil.executeDdl(dataSource, "COMMENT ON COLUMN \"" + tableName + "\"." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'");
        }
    }

    public static void createTable(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        StringBuilder sb = new StringBuilder();
        DbColumn[] dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class));
        sb.append("CREATE TABLE \"" + tableName + "\" (\r\n").append("GUID varchar2(38 char) NOT NULL, \r\n").append("PROCESSINSTANCEID varchar2(64 char) NOT NULL, \r\n");
        for (DbColumn dbc : dbcs) {
            String columnName = dbc.getColumnName();
            if ("GUID".equalsIgnoreCase(columnName) || "PROCESSINSTANCEID".equalsIgnoreCase(columnName)) continue;
            sb.append(columnName).append(" ");
            String sType = dbc.getTypeName().toUpperCase();
            if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                sb.append(sType + "(" + dbc.getDataLength() + " char)");
            } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                if (dbc.getDataScale() == null) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else {
                    sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                }
            } else {
                sb.append(sType);
            }
            if (Boolean.FALSE.equals(dbc.getNullable())) {
                sb.append(" NOT NULL");
            }
            sb.append(",\r\n");
        }
        sb.append("PRIMARY KEY (GUID) \r\n").append(")");
        DbMetaDataUtil.executeDdl(dataSource, sb.toString());
        for (DbColumn dbc : dbcs) {
            if (!org.springframework.util.StringUtils.hasText((String)dbc.getComment())) continue;
            DbMetaDataUtil.executeDdl(dataSource, "COMMENT ON COLUMN \"" + tableName + "\"." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'");
        }
    }

    public static void dropTable(DataSource dataSource, String tableName) throws Exception {
        if (DbMetaDataUtil.checkTableExist(dataSource, tableName)) {
            DbMetaDataUtil.executeDdl(dataSource, "DROP TABLE \"" + tableName + "\"");
        }
    }

    public static void dropTableColumn(DataSource dataSource, String tableName, String columnName) throws Exception {
        DbMetaDataUtil.executeDdl(dataSource, "ALTER TABLE \"" + tableName + "\" DROP COLUMN " + columnName);
    }

    public static void renameTable(DataSource dataSource, String tableNameOld, String tableNameNew) throws Exception {
        DbMetaDataUtil.executeDdl(dataSource, "RENAME \"" + tableNameOld + "\" TO \"" + tableNameNew + "\"");
    }

    @Generated
    private DdlKingbase() {
    }
}

