/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9.sqlddl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.sqlddl.DbMetaDataUtil;
import net.risesoft.y9.sqlddl.pojo.DbColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DdlDm {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DdlDm.class);

    private DdlDm() {
        throw new IllegalStateException("DdlDm Utility class");
    }

    public static void addTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        StringBuilder sb = new StringBuilder();
        DbColumn[] dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class));
        if (DbMetaDataUtil.checkTableExist(dataSource, tableName)) {
            for (DbColumn dbc : dbcs) {
                sb.append("ALTER TABLE " + tableName + " ADD " + dbc.getColumnName() + " ");
                String sType = dbc.getTypeName().toUpperCase();
                if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                    if (dbc.getDataScale() == null) {
                        sb.append(sType + "(" + dbc.getDataLength() + ")");
                    } else {
                        sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                    }
                } else {
                    sb.append(sType);
                }
                if (dbc.getNullable().booleanValue()) {
                    sb.append(" NULL");
                } else {
                    sb.append(" NOT NULL");
                }
                DbMetaDataUtil.executeDdl(dataSource, sb.toString());
                if (!StringUtils.hasText((String)dbc.getComment())) continue;
                DbMetaDataUtil.executeDdl(dataSource, "COMMENT ON COLUMN " + tableName.trim().toUpperCase() + "." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'");
            }
        } else {
            sb.append("CREATE TABLE " + tableName + " (\r\n").append("ID varchar2(38) NOT NULL, \r\n").append("PROCESSINSTANCEID nvarchar2(64) NOT NULL, \r\n").append("CREATETIME timestamp NOT NULL, \r\n").append("UPDATETIME timestamp NOT NULL, \r\n").append("TABINDEX NUMERIC(19,3) DEFAULT 1, \r\n");
            for (DbColumn dbc : dbcs) {
                String columnName = dbc.getColumnName();
                if ("ID".equalsIgnoreCase(columnName) || "PROCESSINSTANCEID".equalsIgnoreCase(columnName) || "CREATETIME".equalsIgnoreCase(columnName) || "UPDATETIME".equalsIgnoreCase(columnName) || "TABINDEX".equalsIgnoreCase(columnName)) continue;
                sb.append(columnName).append(" ");
                String sType = dbc.getTypeName().toUpperCase();
                if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                    if (dbc.getDataScale() == null) {
                        sb.append(sType + "(" + dbc.getDataLength() + ")");
                    } else {
                        sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                    }
                } else {
                    sb.append(sType);
                }
                if (!dbc.getNullable().booleanValue()) {
                    sb.append(" NOT NULL");
                }
                sb.append(",\r\n");
            }
            sb.append("PRIMARY KEY (ID) \r\n").append(")");
            DbMetaDataUtil.executeDdl(dataSource, sb.toString());
            for (DbColumn dbc : dbcs) {
                if (!StringUtils.hasText((String)dbc.getComment())) continue;
                DbMetaDataUtil.executeDdl(dataSource, "COMMENT ON COLUMN " + tableName.trim().toUpperCase() + "." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'");
            }
        }
    }

    public static void alterTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        DbColumn[] dbcs;
        if (!DbMetaDataUtil.checkTableExist(dataSource, tableName)) {
            throw new Exception("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8fd9\u4e2a\u8868\uff1a" + tableName);
        }
        for (DbColumn dbc : dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class))) {
            if (!StringUtils.hasText((String)dbc.getColumnNameOld())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE " + tableName);
            if (!dbc.getColumnName().equalsIgnoreCase(dbc.getColumnNameOld())) {
                try {
                    DbMetaDataUtil.executeDdl(dataSource, sb.append(" RENAME COLUMN " + dbc.getColumnNameOld() + " TO " + dbc.getColumnName()).toString());
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
            sb.append(" MODIFY " + dbc.getColumnName() + " ");
            String sType = dbc.getTypeName().toUpperCase();
            if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                sb.append(sType + "(" + dbc.getDataLength() + ")");
            } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                if (dbc.getDataScale() == null) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else {
                    sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                }
            } else {
                sb.append(sType);
            }
            List<DbColumn> list = DbMetaDataUtil.listAllColumns(dataSource, tableName, dbc.getColumnNameOld());
            if (dbc.getNullable().booleanValue()) {
                if (list.get(0).getNullable().booleanValue()) {
                    sb.append(" NULL");
                }
            } else if (!list.get(0).getNullable().booleanValue()) {
                sb.append(" NOT NULL");
            }
            DbMetaDataUtil.executeDdl(dataSource, sb.toString());
            if (!StringUtils.hasText((String)dbc.getComment()) || list.get(0).getComment().equals(dbc.getComment())) continue;
            DbMetaDataUtil.executeDdl(dataSource, "COMMENT ON COLUMN " + tableName.trim().toUpperCase() + "." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'");
        }
    }

    public static void dropTable(DataSource dataSource, String tableName) throws Exception {
        DbMetaDataUtil.executeDdl(dataSource, "DROP TABLE " + tableName);
    }

    public static void dropTableColumn(DataSource dataSource, String tableName, String columnName) throws Exception {
        DbMetaDataUtil.executeDdl(dataSource, "ALTER TABLE " + tableName + " DROP COLUMN " + columnName);
    }

    public static void renameTable(DataSource dataSource, String tableNameOld, String tableNameNew) throws Exception {
        DbMetaDataUtil.executeDdl(dataSource, "RENAME " + tableNameOld + " TO " + tableNameNew);
    }
}

