/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9.sqlddl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.y9.sqlddl.pojo.DbColumn;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.RowSetDynaClass;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMetaDataUtil {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMetaDataUtil.class);

    public static int[] batchExecuteDdl(DataSource dataSource, List<String> sqlList) throws SQLException {
        Statement stmt = null;
        String dialectName = DbMetaDataUtil.getDatabaseDialectName(dataSource);
        try {
            Object object;
            block20: {
                Connection connection = dataSource.getConnection();
                try {
                    stmt = connection.createStatement();
                    if ("mysql".equals(dialectName)) {
                        stmt.addBatch("SET FOREIGN_KEY_CHECKS=0");
                    }
                    for (String sql : sqlList) {
                        stmt.addBatch(sql);
                    }
                    if ("mysql".equals(dialectName)) {
                        stmt.addBatch("SET FOREIGN_KEY_CHECKS=1");
                    }
                    object = stmt.executeBatch();
                    if (connection == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        LOGGER.error("\u6267\u884cSQL\u8bed\u53e5\u5931\u8d25\uff01", (Throwable)e);
                        throw e;
                    }
                }
                connection.close();
            }
            return object;
        }
        finally {
            if (null != stmt && "mysql".equals(dialectName) && !stmt.isClosed()) {
                stmt.execute("SET FOREIGN_KEY_CHECKS=1");
            }
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static int[] batchExecuteDdl4Kingbase(DataSource dataSource, List<String> sqlList) throws SQLException {
        try (Statement stmt = null;){
            Object object;
            block13: {
                Connection connection = dataSource.getConnection();
                try {
                    stmt = connection.createStatement();
                    for (String sql : sqlList) {
                        stmt.addBatch(sql);
                    }
                    object = stmt.executeBatch();
                    if (connection == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        LOGGER.error("KINGBASE\u6267\u884cSQL\u8bed\u53e5\u5931\u8d25\uff01", (Throwable)e);
                        throw e;
                    }
                }
                connection.close();
            }
            return object;
        }
    }

    public static boolean checkTableExist(DataSource dataSource, String tableName) throws Exception {
        String databaseName = null;
        String tableSchema = null;
        try (ResultSet rs = null;){
            boolean bl;
            block25: {
                Connection connection = dataSource.getConnection();
                try {
                    String dialect;
                    databaseName = connection.getCatalog();
                    DatabaseMetaData dbmd = connection.getMetaData();
                    switch (dialect = DbMetaDataUtil.getDatabaseDialectNameByConnection(connection)) {
                        case "mysql": {
                            rs = dbmd.getTables(null, databaseName, tableName, new String[]{"TABLE"});
                            break;
                        }
                        case "mssql": {
                            rs = dbmd.getTables(databaseName, null, tableName, new String[]{"TABLE"});
                            break;
                        }
                        case "dm": 
                        case "oracle": {
                            tableSchema = dbmd.getUserName().toUpperCase();
                            rs = dbmd.getTables(null, tableSchema, tableName, new String[]{"TABLE"});
                            break;
                        }
                        case "kingbase": {
                            tableSchema = connection.getSchema();
                            rs = dbmd.getTables(null, tableSchema, tableName, new String[]{"TABLE"});
                            break;
                        }
                        default: {
                            rs = dbmd.getTables(null, databaseName, tableName, new String[]{"TABLE"});
                        }
                    }
                    boolean bl2 = bl = rs != null && rs.next();
                    if (connection == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u9a8c\u8bc1\u8868\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01", (Throwable)e);
                        throw e;
                    }
                }
                connection.close();
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Boolean executeDdl(DataSource dataSource, String sql) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            Boolean bl;
            block14: {
                Statement stmt = connection.createStatement();
                try {
                    bl = stmt.execute(sql);
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884c\u5355\u6761SQL\u8bed\u53e5\u5931\u8d25\uff01", (Throwable)e);
            throw e;
        }
    }

    private static ResultSet getColumns(String dialect, DatabaseMetaData dbmd, String databaseName, String tableName, String tableSchema, String columnNamePatten) throws SQLException {
        ResultSet rs = null;
        switch (dialect) {
            case "mysql": {
                rs = dbmd.getColumns(null, databaseName, tableName, columnNamePatten);
                break;
            }
            case "mssql": {
                rs = dbmd.getColumns(databaseName, null, tableName, columnNamePatten);
                break;
            }
            case "oracle": {
                rs = dbmd.getColumns(null, tableSchema, tableName, columnNamePatten);
                break;
            }
            case "dm": {
                rs = dbmd.getColumns(null, tableSchema, tableName, columnNamePatten);
                break;
            }
            case "kingbase": {
                rs = dbmd.getColumns(null, tableSchema, tableName, columnNamePatten);
                break;
            }
            default: {
                rs = dbmd.getColumns(null, databaseName, tableName, columnNamePatten);
            }
        }
        return rs;
    }

    public static String getDatabaseDialectName(DataSource dataSource) {
        String databaseName = "";
        try {
            databaseName = DbMetaDataUtil.getDatabaseProductName(dataSource).toLowerCase();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (databaseName.indexOf("mysql") > -1) {
            return "mysql";
        }
        if (databaseName.indexOf("oracle") > -1) {
            return "oracle";
        }
        if (databaseName.indexOf("dm") > -1) {
            return "dm";
        }
        if (databaseName.indexOf("microsoft") > -1) {
            return "mssql";
        }
        if (databaseName.indexOf("kingbase") > -1) {
            return "kingbase";
        }
        return "";
    }

    public static String getDatabaseDialectNameByConnection(Connection connection) {
        String databaseName = "";
        try {
            databaseName = DbMetaDataUtil.getDatabaseProductNameByConnection(connection).toLowerCase();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (databaseName.indexOf("mysql") > -1) {
            return "mysql";
        }
        if (databaseName.indexOf("oracle") > -1) {
            return "oracle";
        }
        if (databaseName.indexOf("dm") > -1) {
            return "dm";
        }
        if (databaseName.indexOf("microsoft") > -1) {
            return "mssql";
        }
        if (databaseName.indexOf("kingbase") > -1) {
            return "kingbase";
        }
        return "";
    }

    public static int getDatabaseMajorVersion(DataSource dataSource) throws SQLException {
        int n;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                n = dbmd.getDatabaseMajorVersion();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw e;
                }
            }
            connection.close();
        }
        return n;
    }

    public static int getDatabaseMinorVersion(DataSource dataSource) throws SQLException {
        int n;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                n = dbmd.getDatabaseMinorVersion();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw e;
                }
            }
            connection.close();
        }
        return n;
    }

    public static String getDatabaseProductName(DataSource dataSource) throws SQLException {
        String string;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                string = dbmd.getDatabaseProductName();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw e;
                }
            }
            connection.close();
        }
        return string;
    }

    public static String getDatabaseProductNameByConnection(Connection connection) throws SQLException {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            return dbmd.getDatabaseProductName();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    public static String getDatabaseProductVersion(DataSource dataSource) throws SQLException {
        String string;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                string = dbmd.getDatabaseProductVersion();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw e;
                }
            }
            connection.close();
        }
        return string;
    }

    private static ResultSet getPrimaryKeys(String dialect, DatabaseMetaData dbmd, String databaseName, String tableName, String tableSchema) throws SQLException {
        ResultSet rs = null;
        switch (dialect) {
            case "mysql": {
                rs = dbmd.getPrimaryKeys(null, databaseName, tableName);
                break;
            }
            case "mssql": {
                rs = dbmd.getPrimaryKeys(databaseName, null, tableName);
                break;
            }
            case "oracle": {
                rs = dbmd.getPrimaryKeys(null, tableSchema, tableName);
                break;
            }
            case "dm": {
                rs = dbmd.getPrimaryKeys(null, tableSchema, tableName);
                break;
            }
            case "kingbase": {
                rs = dbmd.getPrimaryKeys(null, tableSchema, tableName);
                break;
            }
            default: {
                rs = dbmd.getPrimaryKeys(null, databaseName, tableName);
            }
        }
        return rs;
    }

    public static List<DbColumn> listAllColumns(DataSource dataSource, String tableName, String columnNamePatten) throws Exception {
        String tableSchema = null;
        String databaseName = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<DbColumn> dbColumnList = new ArrayList<DbColumn>();
        if (DbMetaDataUtil.checkTableExist(dataSource, tableName)) {
            try (Connection connection = dataSource.getConnection();){
                databaseName = connection.getCatalog();
                DatabaseMetaData dbmd = connection.getMetaData();
                tableSchema = dbmd.getUserName().toUpperCase();
                String dialect = DbMetaDataUtil.getDatabaseDialectNameByConnection(connection);
                rs = DbMetaDataUtil.getPrimaryKeys(dialect, dbmd, databaseName, tableName, tableSchema);
                ArrayList<String> pkList = new ArrayList<String>();
                while (rs.next()) {
                    pkList.add(rs.getString("COLUMN_NAME"));
                }
                if (pkList.isEmpty()) {
                    LOGGER.error("***********\u6ca1\u6709\u4e3b\u952e\uff1f*************");
                }
                rs = DbMetaDataUtil.getColumns(dialect, dbmd, databaseName, tableName, tableSchema, columnNamePatten);
                while (rs.next()) {
                    DbColumn dbColumn = new DbColumn();
                    dbColumn.setTableName(rs.getString("table_name").toUpperCase());
                    String columnName = rs.getString("column_name".toLowerCase());
                    dbColumn.setColumnName(columnName);
                    dbColumn.setColumnNameOld(columnName);
                    dbColumn.setPrimaryKey(pkList.contains(columnName));
                    String remarks = rs.getString("remarks");
                    if (StringUtils.isBlank((CharSequence)remarks)) {
                        dbColumn.setComment(columnName.toUpperCase());
                    } else {
                        dbColumn.setComment(remarks);
                    }
                    int columnSize = rs.getInt("column_size");
                    dbColumn.setDataLength(columnSize);
                    int dataType = rs.getInt("data_type");
                    dbColumn.setDataType(dataType);
                    dbColumn.setTypeName(rs.getString("type_name").toLowerCase());
                    int decimalDigits = rs.getInt("decimal_digits");
                    dbColumn.setDataScale(decimalDigits);
                    String nullable = rs.getString("is_nullable");
                    Boolean bNullable = false;
                    if ("yes".equalsIgnoreCase(nullable)) {
                        bNullable = true;
                    }
                    dbColumn.setNullable(bNullable);
                    boolean exist = false;
                    for (DbColumn field : dbColumnList) {
                        if (!field.getColumnName().equalsIgnoreCase(columnName)) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    dbColumnList.add(dbColumn);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw e;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return dbColumnList;
    }

    public static List<DynaBean> listAllExportedKeys(DataSource dataSource, String tableName) throws Exception {
        ResultSet rs = null;
        ArrayList<DynaBean> rList = new ArrayList<DynaBean>();
        try {
            ArrayList<DynaBean> arrayList;
            block16: {
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData dbmd = connection.getMetaData();
                    rs = dbmd.getExportedKeys(null, null, tableName);
                    RowSetDynaClass rsdc = new RowSetDynaClass(rs, true);
                    rs.close();
                    rList.addAll(rsdc.getRows());
                    arrayList = rList;
                    if (connection == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw e;
                    }
                }
                connection.close();
            }
            return arrayList;
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (Exception e2) {
                LOGGER.warn(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    public static List<DynaBean> listAllImportedKeys(DataSource dataSource, String tableName) throws Exception {
        ResultSet rs = null;
        ArrayList<DynaBean> rList = new ArrayList<DynaBean>();
        try {
            ArrayList<DynaBean> arrayList;
            block12: {
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData dbmd = connection.getMetaData();
                    rs = dbmd.getImportedKeys(null, null, tableName);
                    RowSetDynaClass rsdc = new RowSetDynaClass(rs, true);
                    rs.close();
                    rList.addAll(rsdc.getRows());
                    arrayList = rList;
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw e;
                    }
                }
                connection.close();
            }
            return arrayList;
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
    }

    public static List<DynaBean> listAllIndexs(DataSource dataSource, String tableName) throws Exception {
        ResultSet rs = null;
        try {
            List list;
            block12: {
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData dbmd = connection.getMetaData();
                    rs = dbmd.getIndexInfo(null, null, tableName, false, false);
                    RowSetDynaClass rsdc = new RowSetDynaClass(rs, true);
                    list = rsdc.getRows();
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw e;
                    }
                }
                connection.close();
            }
            return list;
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
    }

    public static List<DynaBean> listAllRelations(DataSource dataSource, String tableName) throws Exception {
        ResultSet rs = null;
        ArrayList<DynaBean> rList = new ArrayList<DynaBean>();
        try {
            ArrayList<DynaBean> arrayList;
            block12: {
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData dbmd = connection.getMetaData();
                    rs = dbmd.getImportedKeys(null, null, tableName);
                    RowSetDynaClass rsdc = new RowSetDynaClass(rs, true);
                    rs.close();
                    rs = dbmd.getExportedKeys(null, null, tableName);
                    RowSetDynaClass rsdc2 = new RowSetDynaClass(rs, true);
                    rs.close();
                    rList.addAll(rsdc.getRows());
                    rList.addAll(rsdc2.getRows());
                    arrayList = rList;
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw e;
                    }
                }
                connection.close();
            }
            return arrayList;
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
    }

    public static List<Map<String, String>> listAllTables(DataSource dataSource, String tableNamePattern) throws Exception {
        ArrayList list = new ArrayList();
        ResultSet rs = null;
        try {
            Object object;
            block27: {
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData dbmd = connection.getMetaData();
                    String username = dbmd.getUserName().toUpperCase();
                    String dialect = DbMetaDataUtil.getDatabaseDialectNameByConnection(connection);
                    switch (dialect) {
                        case "mysql": {
                            rs = dbmd.getTables(null, connection.getCatalog(), tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        case "mssql": {
                            rs = dbmd.getTables(connection.getCatalog(), null, tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        case "oracle": {
                            rs = dbmd.getTables(null, username, tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        case "dm": {
                            rs = dbmd.getTables(null, username, tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        case "kingbase": {
                            rs = dbmd.getTables(null, username, tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        default: {
                            rs = dbmd.getTables(null, connection.getCatalog(), tableNamePattern, new String[]{"TABLE"});
                        }
                    }
                    while (rs.next()) {
                        if (rs.getString("TABLE_NAME").contains("$")) continue;
                        HashMap<String, String> map = new HashMap<String, String>(16);
                        map.put("catalog", rs.getString("TABLE_CAT"));
                        map.put("schema", rs.getString("TABLE_SCHEM"));
                        map.put("name", rs.getString("TABLE_NAME"));
                        list.add(map);
                    }
                    object = list;
                    if (connection == null) break block27;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw e;
                    }
                }
                connection.close();
            }
            return object;
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
    }

    public static List<DynaBean> listAllTables(DataSource dataSource, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws Exception {
        ResultSet rs = null;
        try {
            List list;
            block12: {
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData dbmd = connection.getMetaData();
                    rs = dbmd.getTables(catalog, schemaPattern, tableNamePattern, types);
                    RowSetDynaClass rsdc = new RowSetDynaClass(rs, true);
                    list = rsdc.getRows();
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw e;
                    }
                }
                connection.close();
            }
            return list;
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
    }

    public static String listAllTablesTree(DataSource dataSource, String tableNamePattern) throws Exception {
        ArrayList list = new ArrayList();
        ResultSet rs = null;
        ObjectMapper mapper = new ObjectMapper();
        String json = "[]";
        try {
            String string;
            block34: {
                Connection connection = dataSource.getConnection();
                try {
                    String dialect;
                    DatabaseMetaData dbmd = connection.getMetaData();
                    String username = dbmd.getUserName().toUpperCase();
                    switch (dialect = DbMetaDataUtil.getDatabaseDialectName(dataSource)) {
                        case "mysql": {
                            rs = dbmd.getTables(null, connection.getCatalog(), tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        case "mssql": {
                            rs = dbmd.getTables(connection.getCatalog(), null, tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        case "oracle": {
                            rs = dbmd.getTables(null, username, tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        case "dm": {
                            rs = dbmd.getTables(null, username, tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        case "kingbase": {
                            rs = dbmd.getTables(null, username, tableNamePattern, new String[]{"TABLE"});
                            break;
                        }
                        default: {
                            rs = dbmd.getTables(null, connection.getCatalog(), tableNamePattern, new String[]{"TABLE"});
                        }
                    }
                    String dbName = "";
                    while (rs.next()) {
                        if (rs.getString("TABLE_NAME").contains("$")) continue;
                        if ("mysql".equals(dialect)) {
                            dbName = rs.getString(1);
                        } else if ("oracle".equals(dialect)) {
                            dbName = dbmd.getUserName();
                        } else if ("dm".equals(dialect)) {
                            dbName = dbmd.getUserName();
                        } else if ("kingbase".equals(dialect)) {
                            dbName = dbmd.getUserName();
                        }
                        HashMap<String, Object> map = new HashMap<String, Object>(16);
                        map.put("text", rs.getString("TABLE_NAME"));
                        HashMap<String, String> attributes = new HashMap<String, String>(16);
                        attributes.put("catalog", rs.getString("TABLE_CAT"));
                        attributes.put("schema", rs.getString("TABLE_SCHEM"));
                        map.put("attributes", attributes);
                        list.add(map);
                    }
                    HashMap<String, Object> pNode = new HashMap<String, Object>(16);
                    pNode.put("id", 0);
                    pNode.put("text", dbName + "\u5e93\u8868\u5217\u8868");
                    pNode.put("iconCls", "icon-folder");
                    pNode.put("children", list);
                    ArrayList<HashMap<String, Object>> tree = new ArrayList<HashMap<String, Object>>();
                    tree.add(pNode);
                    string = json = mapper.writeValueAsString(tree);
                    if (connection == null) break block34;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw e;
                    }
                }
                connection.close();
            }
            return string;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public static List<Map<String, Object>> listAllTypes(DataSource dataSource) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (ResultSet rs = null;){
            ArrayList<Map<String, Object>> arrayList;
            block13: {
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData dbmd = connection.getMetaData();
                    rs = dbmd.getTypeInfo();
                    while (rs.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>(16);
                        map.put("TYPE_NAME", rs.getString("TYPE_NAME"));
                        map.put("DATA_TYPE", rs.getInt("DATA_TYPE"));
                        list.add(map);
                    }
                    arrayList = list;
                    if (connection == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw e;
                    }
                }
                connection.close();
            }
            return arrayList;
        }
    }

    @Generated
    public DbMetaDataUtil() {
    }
}

