/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.register.service;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import net.risedata.register.model.WatchProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="beta.discovery")
public class RegisterDiscoveryProperties
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RegisterDiscoveryProperties.class);
    @Value(value="${beta.discovery.service:${spring.application.name:}}")
    private String service;
    private String version;
    private String description;
    private String managerInfo;
    private String logPath;
    private String context;
    private Map<String, String> metadata = new HashMap<String, String>();
    private int weight;
    private boolean registerEnabled = true;
    private String ip;
    private String environment;
    private String networkInterface = "";
    private int port = -1;
    private boolean secure = false;
    private Integer heartBeatInterval = 30000;
    private Integer heartBeatTimeout = 90000;
    @Autowired(required=false)
    private InetUtils inetUtils;
    @Autowired
    private Environment environmentUtil;
    @Autowired(required=false)
    WatchProperties watchProperties;

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void init() throws SocketException {
        if (this.secure) {
            this.metadata.put("secure", "true");
        }
        if (StringUtils.isEmpty((Object)this.environment)) {
            this.environment = "Public";
        }
        if (StringUtils.isEmpty((Object)this.ip)) {
            if (StringUtils.isEmpty((Object)this.networkInterface)) {
                if (this.inetUtils != null) {
                    this.ip = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                } else {
                    try {
                        this.ip = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        throw new IllegalArgumentException("no such interface " + e.getMessage());
                    }
                }
            } else {
                NetworkInterface netInterface = NetworkInterface.getByName(this.networkInterface);
                if (null == netInterface) {
                    throw new IllegalArgumentException("no such interface " + this.networkInterface);
                }
                Enumeration<InetAddress> inetAddress = netInterface.getInetAddresses();
                while (inetAddress.hasMoreElements()) {
                    InetAddress currentAddress = inetAddress.nextElement();
                    if (!(currentAddress instanceof Inet4Address) || currentAddress.isLoopbackAddress()) continue;
                    this.ip = currentAddress.getHostAddress();
                    break;
                }
                if (StringUtils.isEmpty((Object)this.ip)) {
                    throw new RuntimeException("cannot find available ip from network interface " + this.networkInterface);
                }
            }
        }
        this.overrideFromEnv(this.environmentUtil);
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getManagerInfo() {
        return this.managerInfo;
    }

    public void setManagerInfo(String managerInfo) {
        this.managerInfo = managerInfo;
    }

    public void setInetUtils(InetUtils inetUtils) {
        this.inetUtils = inetUtils;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Integer getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setHeartBeatInterval(Integer heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    public Integer getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public void setHeartBeatTimeout(Integer heartBeatTimeout) {
        this.heartBeatTimeout = heartBeatTimeout;
    }

    public void overrideFromEnv(Environment env) {
        if (this.getPort() == -1) {
            this.setPort(Integer.parseInt(env.resolvePlaceholders("${server.port}")));
        }
        log.debug(this.toString());
    }

    public String toString() {
        return "RegisterDiscoveryProperties{service='" + this.service + "', version='" + this.version + "', description='" + this.description + "', managerInfo='" + this.managerInfo + "', metadata=" + this.metadata + ", registerEnabled=" + this.registerEnabled + ", ip='" + this.ip + "', networkInterface='" + this.networkInterface + "', port=" + this.port + ", secure=" + this.secure + ", heartBeatInterval=" + this.heartBeatInterval + ", heartBeatTimeout=" + this.heartBeatTimeout + ", watchProperties=" + this.watchProperties + "}";
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }
}

