/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.register.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class CompareUtil<T> {
    private Field[] fields;

    public CompareUtil(Class<T> compareClass) {
        Field[] fields2 = compareClass.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : fields2) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            fieldList.add(field);
        }
        this.fields = fieldList.toArray(new Field[fieldList.size()]);
    }

    public boolean compare(T t1, T t2) {
        try {
            for (Field field : this.fields) {
                Object temp = field.get(t1);
                Object temp2 = field.get(t2);
                if (temp == null && temp2 != null) {
                    return true;
                }
                if (temp2 == null && temp != null) {
                    return true;
                }
                if (temp.toString().equals(temp2.toString())) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return false;
    }

    public void toValue(T t1, T newT) {
        try {
            for (Field field : this.fields) {
                Object temp2 = field.get(newT);
                field.set(t1, temp2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

