/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.platform.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import net.risesoft.api.platform.org.dto.CreatePersonDTO;
import net.risesoft.api.platform.org.dto.PersonInfoDTO;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.PersonExt;
import net.risesoft.model.platform.Position;
import net.risesoft.model.platform.Role;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface PersonApi {
    @GetMapping(value={"/checkLoginName"})
    public Y9Result<Boolean> checkLoginName(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="loginName") @NotBlank String var3);

    @PostMapping(value={"/delete"})
    public Y9Result<Object> delete(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @PostMapping(value={"/disable"})
    public Y9Result<Object> disable(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @GetMapping(value={"/get"})
    public Y9Result<Person> get(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @GetMapping(value={"/getByLoginName"})
    public Y9Result<Person> getByLoginName(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="loginName") @NotBlank String var2);

    @GetMapping(value={"/getByCaId"})
    public Y9Result<Person> getByCaId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="caId") @NotBlank String var2);

    @GetMapping(value={"/getByLoginNameAndParentId"})
    public Y9Result<Person> getByLoginNameAndParentId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="loginName") @NotBlank String var2, @RequestParam(value="parentId") @NotBlank String var3);

    @GetMapping(value={"/getPersonExtByPersonId"})
    public Y9Result<PersonExt> getPersonExtByPersonId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @GetMapping(value={"/getPersonPhoto"})
    public Y9Result<String> getPersonPhoto(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @GetMapping(value={"/list"})
    public Y9Result<List<Person>> list(@RequestParam(value="tenantId") @NotBlank String var1);

    @GetMapping(value={"/listByIdTypeAndIdNum"})
    public Y9Result<List<Person>> listByIdTypeAndIdNum(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="idType") @NotBlank String var2, @RequestParam(value="idNum") @NotBlank String var3);

    @GetMapping(value={"/listByName"})
    public Y9Result<List<Person>> listByName(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(name="name", required=false) String var2);

    @GetMapping(value={"/listByParentId"})
    public Y9Result<List<Person>> listByParentId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="parentId") @NotBlank String var2);

    @GetMapping(value={"/listByParentIdAndDisabled"})
    public Y9Result<List<Person>> listByParentIdAndDisabled(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="parentId") @NotBlank String var2, @RequestParam(value="disabled") Boolean var3);

    @GetMapping(value={"/listGroupsByPersonId"})
    public Y9Result<List<Group>> listGroupsByPersonId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @GetMapping(value={"/listParentsByPersonId"})
    public Y9Result<List<OrgUnit>> listParentsByPersonId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @GetMapping(value={"/listPersonInfoByName"})
    public Y9Result<List<PersonInfoDTO>> listPersonInfoByName(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(name="name", required=false) String var2);

    @GetMapping(value={"/listPositionsByPersonId"})
    public Y9Result<List<Position>> listPositionsByPersonId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @GetMapping(value={"/listRecursivelyByParentId"})
    public Y9Result<List<Person>> listRecursivelyByParentId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="parentId") @NotBlank String var2);

    @GetMapping(value={"/listRecursivelyByParentIdAndName"})
    public Y9Result<List<Person>> listRecursivelyByParentIdAndName(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="parentId") @NotBlank String var2, @RequestParam(value="name") @NotBlank String var3);

    @GetMapping(value={"/listRoles"})
    public Y9Result<List<Role>> listRoles(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @PostMapping(value={"/modifyPassword"})
    public Y9Result<Person> modifyPassword(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="oldPassword") @NotBlank String var3, @RequestParam(value="newPassword") @NotBlank String var4);

    @GetMapping(value={"/pageByName"})
    public Y9Page<Person> pageByName(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(required=false) String var2, @Validated Y9PageQuery var3);

    @GetMapping(value={"/pageByParentId"})
    public Y9Page<Person> pageByParentId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="parentId") @NotBlank String var2, @RequestParam(value="disabled") boolean var3, @Validated Y9PageQuery var4);

    @GetMapping(value={"/pageByParentIdAndName"})
    public Y9Page<Person> pageByParentIdAndName(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="parentId") @NotBlank String var2, @RequestParam(value="disabled") boolean var3, @RequestParam(value="name", required=false) String var4, Y9PageQuery var5);

    @PostMapping(value={"/savePersonAvatar"})
    public Y9Result<Person> savePersonAvatar(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="avatar") @NotBlank String var3);

    @PostMapping(value={"/savePersonPhoto"})
    public Y9Result<Object> savePersonPhoto(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="photo") @NotBlank String var3);

    @PostMapping(value={"/savePersonSign"})
    public Y9Result<Object> savePersonSign(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="sign") @NotBlank String var3);

    @PostMapping(value={"/savePersonWeixinId"})
    public Y9Result<Person> savePersonWeixinId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="weixinId") @NotBlank String var3);

    @PostMapping(value={"/savePersonWithExt"})
    public Y9Result<Person> savePersonWithExt(@RequestParam(value="tenantId") @NotBlank String var1, @RequestBody @Validated CreatePersonDTO var2);
}

