/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.platform.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import net.risesoft.api.platform.org.dto.CreateDepartmentDTO;
import net.risesoft.enums.platform.DepartmentPropCategoryEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.DepartmentProp;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.pojo.Y9Result;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface DepartmentApi {
    @PostMapping(value={"/create"})
    public Y9Result<Department> create(@RequestParam(value="tenantId") @NotBlank String var1, @Validated @RequestBody CreateDepartmentDTO var2);

    @PostMapping(value={"/delete"})
    public Y9Result<Object> delete(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="departmentId") @NotBlank String var2);

    @PostMapping(value={"/disable"})
    public Y9Result<Object> disable(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="departmentId") @NotBlank String var2);

    @GetMapping(value={"/get"})
    public Y9Result<Department> get(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="departmentId") @NotBlank String var2);

    @GetMapping(value={"/listBureauByNameLike"})
    public Y9Result<List<Department>> listBureauByNameLike(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(name="name", required=false) String var2);

    @GetMapping(value={"/listByIds"})
    public Y9Result<List<Department>> listByIds(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="ids") @NotEmpty List<String> var2);

    @GetMapping(value={"/listByName"})
    public Y9Result<List<Department>> listByName(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="name") @NotBlank String var2);

    @GetMapping(value={"/listByParentId"})
    public Y9Result<List<Department>> listByParentId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="parentId") @NotBlank String var2);

    @GetMapping(value={"/listDepartmentPropByOrgUnitIdAndCategory"})
    public Y9Result<List<DepartmentProp>> listDepartmentPropByOrgUnitIdAndCategory(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="orgUnitId") @NotBlank String var2, @RequestParam(value="category") DepartmentPropCategoryEnum var3);

    @GetMapping(value={"/listDepartmentPropOrgUnits"})
    public Y9Result<List<OrgUnit>> listDepartmentPropOrgUnits(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="departmentId") @NotBlank String var2, @RequestParam Integer var3);

    @GetMapping(value={"/listRecursivelyByParentId"})
    public Y9Result<List<Department>> listRecursivelyByParentId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="parentId") @NotBlank String var2);
}

