/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.platform.customgroup;

import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.CustomGroup;
import net.risesoft.model.platform.CustomGroupMember;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface CustomGroupApi {
    @PostMapping(value={"/addMember"})
    public Y9Result<Object> addMember(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="customGroupId") @NotBlank String var2, @RequestParam(value="orgUnitList") @NotEmpty List<String> var3);

    @PostMapping(value={"/deleteAllGroup"})
    public Y9Result<Object> deleteAllGroup(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="groupIds") @NotEmpty List<String> var2);

    @GetMapping(value={"/findCustomGroupByCustomId"})
    public Y9Result<CustomGroup> findCustomGroupByCustomId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="customId") @NotBlank String var2);

    @GetMapping(value={"/findCustomGroupById"})
    public Y9Result<CustomGroup> findCustomGroupById(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="groupId") @NotBlank String var3);

    @GetMapping(value={"/listAllPersonByGroupId"})
    public Y9Result<List<Person>> listAllPersonByGroupId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="groupId") @NotBlank String var2);

    @GetMapping(value={"/listCustomGroupByUserId"})
    public Y9Result<List<CustomGroup>> listCustomGroupByPersonId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2);

    @GetMapping(value={"/listCustomGroupMemberByGroupId"})
    public Y9Result<List<CustomGroupMember>> listCustomGroupMemberByGroupId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="groupId") @NotBlank String var3);

    @GetMapping(value={"/listCustomGroupMemberByGroupIdAndMemberType"})
    public Y9Result<List<CustomGroupMember>> listCustomGroupMemberByGroupIdAndMemberType(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") String var2, @RequestParam(value="groupId") @NotBlank String var3, @RequestParam(value="memberType") OrgTypeEnum var4);

    @GetMapping(value={"/pageCustomGroupByPersonId"})
    public Y9Page<CustomGroup> pageCustomGroupByPersonId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @Validated Y9PageQuery var3);

    @GetMapping(value={"/pageCustomGroupMemberByGroupId"})
    public Y9Page<CustomGroupMember> pageCustomGroupMemberByGroupId(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="groupId") @NotBlank String var2, @Validated Y9PageQuery var3);

    @GetMapping(value={"/pageCustomGroupMemberByGroupIdAndMemberType"})
    public Y9Page<CustomGroupMember> pageCustomGroupMemberByGroupIdAndMemberType(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="groupId") @NotBlank String var2, @RequestParam(value="memberType") OrgTypeEnum var3, @Validated Y9PageQuery var4);

    @PostMapping(value={"/removeMembers"})
    public Y9Result<Object> removeMembers(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="memberIds") @NotEmpty List<String> var2);

    @PostMapping(value={"/saveCustomGroup"})
    public Y9Result<CustomGroup> saveCustomGroup(@RequestParam(value="tenantId") @NotBlank String var1, @RequestBody CustomGroup var2);

    @PostMapping(value={"/saveCustomGroupOrder"})
    public Y9Result<Object> saveCustomGroupOrder(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="sortIds") @NotEmpty List<String> var2);

    @PostMapping(value={"/saveMemberOrder"})
    public Y9Result<Object> saveMemberOrder(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="memberIds") @NotEmpty List<String> var2);

    @PostMapping(value={"/saveOrUpdateCustomGroup"})
    public Y9Result<CustomGroup> saveOrUpdateCustomGroup(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personId") @NotBlank String var2, @RequestParam(value="personIds") @NotEmpty List<String> var3, @RequestParam(value="groupId") String var4, @RequestParam(value="groupName") @NotBlank String var5);

    @PostMapping(value={"/shareCustomGroup"})
    public Y9Result<Object> shareCustomGroup(@RequestParam(value="tenantId") @NotBlank String var1, @RequestParam(value="personIds") @NotEmpty List<String> var2, @RequestParam(value="groupIds") @NotEmpty List<String> var3);
}

