/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import java.io.Serializable;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.database.postgres.PostgresWriter;
import net.revenj.database.postgres.converters.ArrayTuple;
import net.revenj.database.postgres.converters.BoolConverter$;
import net.revenj.database.postgres.converters.IntConverter$;
import net.revenj.database.postgres.converters.PostgresTuple;
import net.revenj.database.postgres.converters.PostgresTuple$;
import net.revenj.database.postgres.converters.RecordTuple$;
import net.revenj.patterns.Equality;
import net.revenj.patterns.Identifiable;
import org.postgresql.util.PGobject;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.concurrent.TrieMap;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ArrayTuple$ {
    public static final ArrayTuple$ MODULE$ = new ArrayTuple$();
    private static final PostgresTuple EMPTY = new ArrayTuple.EmptyArrayTuple();
    private static final PostgresTuple NULL = new ArrayTuple.NullTuple();
    private static final TrieMap<String, String> escapingCache = new TrieMap();
    private static final Some<IndexedSeq<Nothing$>> someEmptyCollection = new Some((Object)IndexedSeq$.MODULE$.empty());
    private static final Some<IndexedSeq<Option<Nothing$>>> someEmptyOptionCollection = new Some((Object)IndexedSeq$.MODULE$.empty());

    public PostgresTuple EMPTY() {
        return EMPTY;
    }

    public PostgresTuple NULL() {
        return NULL;
    }

    private TrieMap<String, String> escapingCache() {
        return escapingCache;
    }

    public String nextEscape(String input) {
        if (input.length() < 16) {
            return (String)this.escapingCache().getOrElseUpdate((Object)input, (Function0 & Serializable)() -> PostgresTuple$.MODULE$.buildNextEscape(input, '0'));
        }
        return PostgresTuple$.MODULE$.buildNextEscape(input, '0');
    }

    public PostgresTuple apply(PostgresTuple[] elements) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.length == 0) {
            return this.EMPTY();
        }
        return new ArrayTuple(elements);
    }

    public <T> PostgresTuple createIndexed(IndexedSeq<T> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            tuples[i] = (PostgresTuple)converter.apply(elements.apply(i));
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createIndexedOption(IndexedSeq<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            Option option = (Option)elements.apply(i);
            if (option instanceof Some) {
                Object el = ((Some)option).value();
                tuples[i] = (PostgresTuple)converter.apply(el);
                continue;
            }
            tuples[i] = PostgresTuple$.MODULE$.NULL();
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createSeq(Seq<T> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            tuples[i] = (PostgresTuple)converter.apply(it.next());
            ++i;
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createSeqOption(Seq<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        for (Option option : elements) {
            if (option instanceof Some) {
                Object el = ((Some)option).value();
                tuples[i] = (PostgresTuple)converter.apply(el);
            } else {
                tuples[i] = PostgresTuple$.MODULE$.NULL();
            }
            ++i;
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createSet(Set<T> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            tuples[i] = (PostgresTuple)converter.apply(it.next());
            ++i;
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createSetOption(Set<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        for (Option option : elements) {
            if (option instanceof Some) {
                Object el = ((Some)option).value();
                tuples[i] = (PostgresTuple)converter.apply(el);
            } else {
                tuples[i] = PostgresTuple$.MODULE$.NULL();
            }
            ++i;
        }
        return new ArrayTuple(tuples);
    }

    private Some<IndexedSeq<Nothing$>> someEmptyCollection() {
        return someEmptyCollection;
    }

    private Some<IndexedSeq<Option<Nothing$>>> someEmptyOptionCollection() {
        return someEmptyOptionCollection;
    }

    public <T> Option<IndexedSeq<T>> parse(PostgresReader reader, int context, Function2<PostgresReader, Object, T> converter, Function0<T> function0) {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return None$.MODULE$;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return this.someEmptyCollection();
        }
        ArrayBuffer result = new ArrayBuffer(4);
        int arrayContext = Math.max(context << 1, 1);
        int recordContext = arrayContext << 1;
        while (cur != -1 && cur != 125) {
            boolean innerEscaped;
            cur = reader.read();
            if (cur == 78) {
                cur = reader.read(4);
                result.$plus$eq(function0.apply());
                continue;
            }
            boolean bl2 = innerEscaped = cur != 40;
            if (innerEscaped) {
                reader.read(arrayContext);
            }
            result.$plus$eq(converter.apply((Object)reader, (Object)BoxesRunTime.boxToInteger((int)recordContext)));
            if (innerEscaped) {
                cur = reader.read(arrayContext + 1);
                continue;
            }
            cur = reader.read();
        }
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return new Some((Object)result);
    }

    public <T> Option<IndexedSeq<Option<T>>> parseOption(PostgresReader reader, int context, Function2<PostgresReader, Object, T> converter) {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return None$.MODULE$;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return this.someEmptyOptionCollection();
        }
        ArrayBuffer result = new ArrayBuffer(4);
        int arrayContext = Math.max(context << 1, 1);
        int recordContext = arrayContext << 1;
        while (cur != -1 && cur != 125) {
            boolean innerEscaped;
            cur = reader.read();
            if (cur == 78) {
                cur = reader.read(4);
                result.$plus$eq((Object)None$.MODULE$);
                continue;
            }
            boolean bl2 = innerEscaped = cur != 40;
            if (innerEscaped) {
                reader.read(arrayContext);
            }
            result.$plus$eq((Object)new Some(converter.apply((Object)reader, (Object)BoxesRunTime.boxToInteger((int)recordContext))));
            if (innerEscaped) {
                cur = reader.read(arrayContext + 1);
                continue;
            }
            cur = reader.read();
        }
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return new Some((Object)result);
    }

    public PGobject toParameter(PostgresWriter sw, String arrayType, Iterable<PostgresTuple[]> data) {
        sw.reset();
        ArrayTuple array = new ArrayTuple((PostgresTuple[])((IterableOnceOps)data.map((Function1 & Serializable)a -> RecordTuple$.MODULE$.apply((PostgresTuple[])a))).toArray(ClassTag$.MODULE$.apply(PostgresTuple.class)));
        PGobject pgo = new PGobject();
        pgo.setType(arrayType);
        array.buildTuple(sw, false);
        pgo.setValue(sw.bufferToString());
        sw.reset();
        return pgo;
    }

    private PGobject emptyPGO(String arrayType) {
        PGobject pgo = new PGobject();
        pgo.setType(arrayType);
        return pgo;
    }

    public <T> PGobject toParameterSimple(PostgresWriter sw, Seq<T> collection, String arrayType, Function1<T, PostgresTuple> toTuple) {
        if (collection.nonEmpty()) {
            return this.toParameter(sw, arrayType, (Iterable<PostgresTuple[]>)((Iterable)((IterableOps)collection.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Object item = x0$1._1();
                    int ind = x0$1._2$mcI$sp();
                    return new PostgresTuple[]{IntConverter$.MODULE$.toTuple(ind), (PostgresTuple)toTuple.apply(item)};
                }
                throw new MatchError(null);
            })));
        }
        return this.emptyPGO(arrayType);
    }

    public <T> PGobject toParameterPair(PostgresWriter sw, Seq<Tuple2<T, T>> collection, String arrayType, Function1<T, PostgresTuple> toTupleUpdate, Function1<T, PostgresTuple> toTupleTable) {
        if (collection.nonEmpty()) {
            return this.toParameter(sw, arrayType, (Iterable<PostgresTuple[]>)((Iterable)((IterableOps)collection.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Tuple2 tuple2 = (Tuple2)x0$1._1();
                    int ind = x0$1._2$mcI$sp();
                    if (tuple2 != null) {
                        Object oldValue = tuple2._1();
                        Object newValue = tuple2._2();
                        return new PostgresTuple[]{IntConverter$.MODULE$.toTuple(ind), oldValue == null ? PostgresTuple$.MODULE$.NULL() : (PostgresTuple)toTupleUpdate.apply(oldValue), newValue == null ? PostgresTuple$.MODULE$.NULL() : (PostgresTuple)toTupleTable.apply(newValue)};
                    }
                }
                throw new MatchError(x0$1);
            })));
        }
        return this.emptyPGO(arrayType);
    }

    public <T> PGobject toParameterNew(PostgresWriter sw, Seq<PostgresWriter.NewTuple<T>> collection, String arrayType, Function1<T, PostgresTuple> toTuple) {
        if (collection.nonEmpty()) {
            return this.toParameter(sw, arrayType, (Iterable<PostgresTuple[]>)((Iterable)collection.map((Function1 & Serializable)tuple -> new PostgresTuple[]{IntConverter$.MODULE$.toTuple(tuple.index()), IntConverter$.MODULE$.toTuple(tuple.element()), (PostgresTuple)toTuple.apply(tuple.value())})));
        }
        return this.emptyPGO(arrayType);
    }

    public <T extends Equality<T> & Identifiable> PGobject toParameterDiff(PostgresWriter sw, Seq<PostgresWriter.CollectionDiff<T>> collection, String arrayType, Function1<T, PostgresTuple> toTuple) {
        if (collection.nonEmpty()) {
            return this.toParameter(sw, arrayType, (Iterable<PostgresTuple[]>)((Iterable)collection.map((Function1 & Serializable)it -> new PostgresTuple[]{IntConverter$.MODULE$.toTuple(it.index()), IntConverter$.MODULE$.toTuple(it.element()), it.oldValue().isEmpty() ? PostgresTuple$.MODULE$.NULL() : (PostgresTuple)toTuple.apply(it.oldValue().get()), it.changedValue().isEmpty() ? PostgresTuple$.MODULE$.NULL() : (PostgresTuple)toTuple.apply(it.changedValue().get()), it.newValue().isEmpty() ? PostgresTuple$.MODULE$.NULL() : (PostgresTuple)toTuple.apply(it.newValue().get()), BoolConverter$.MODULE$.toTuple(it.isNew())})));
        }
        return this.emptyPGO(arrayType);
    }

    private ArrayTuple$() {
    }
}

