/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import org.postgresql.PGProperty;
import org.postgresql.core.PGStream;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.SetupQueryRunner;
import org.postgresql.core.SocketFactoryFactory;
import org.postgresql.core.Tuple;
import org.postgresql.core.Utils;
import org.postgresql.core.Version;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.gss.MakeGSS;
import org.postgresql.hostchooser.CandidateHost;
import org.postgresql.hostchooser.GlobalHostStatusTracker;
import org.postgresql.hostchooser.HostChooser;
import org.postgresql.hostchooser.HostChooserFactory;
import org.postgresql.hostchooser.HostRequirement;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.jdbc.GSSEncMode;
import org.postgresql.jdbc.SslMode;
import org.postgresql.jre7.sasl.ScramAuthenticator;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.sspi.ISSPIClient;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.internal.Nullness;
import org.postgresql.util.internal.Unsafe;

public class ConnectionFactoryRevenj {
    private static final Logger LOGGER = Logger.getLogger(ConnectionFactoryRevenj.class.getName());
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    private static final int AUTH_REQ_SASL = 10;
    private static final int AUTH_REQ_SASL_CONTINUE = 11;
    private static final int AUTH_REQ_SASL_FINAL = 12;

    public static PGStream openConnection(HostSpec[] hostSpecArray, String string, String string2, String string3, String string4, Properties properties) throws SQLException {
        String string5 = PGProperty.PROTOCOL_VERSION.get(properties);
        if (string5 == null || string5.isEmpty() || "3".equals(string5)) {
            ConnectionFactoryRevenj connectionFactoryRevenj = new ConnectionFactoryRevenj();
            return connectionFactoryRevenj.openConnectionImpl(hostSpecArray, string, string2, string3, string4, properties);
        }
        throw new PSQLException(GT.tr((String)"A connection could not be made using the requested protocol {0}.", (Object[])new Object[]{string5}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private ISSPIClient createSSPI(PGStream pGStream, String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName("org.postgresql.sspi.SSPIClient");
            return (ISSPIClient)clazz.getDeclaredConstructor(PGStream.class, String.class, Boolean.TYPE).newInstance(pGStream, string, bl);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to load org.postgresql.sspi.SSPIClient. Please check that SSPIClient is included in your pgjdbc distribution.", exception);
        }
    }

    private PGStream tryConnect(String string, String string2, String string3, Properties properties, SocketFactory socketFactory, HostSpec hostSpec, SslMode sslMode, GSSEncMode gSSEncMode) throws SQLException, IOException {
        int n;
        int n2 = PGProperty.CONNECT_TIMEOUT.getInt(properties) * 1000;
        PGStream pGStream = new PGStream(socketFactory, hostSpec, n2);
        int n3 = PGProperty.SOCKET_TIMEOUT.getInt(properties);
        if (n3 > 0) {
            pGStream.setNetworkTimeout(n3 * 1000);
        }
        String string4 = PGProperty.MAX_RESULT_BUFFER.get(properties);
        pGStream.setMaxResultBuffer(string4);
        boolean bl = PGProperty.TCP_KEEP_ALIVE.getBoolean(properties);
        pGStream.getSocket().setKeepAlive(bl);
        int n4 = PGProperty.RECEIVE_BUFFER_SIZE.getInt(properties);
        if (n4 > -1) {
            if (n4 > 0) {
                pGStream.getSocket().setReceiveBufferSize(n4);
            } else {
                LOGGER.log(Level.WARNING, "Ignore invalid value for receiveBufferSize: {0}", n4);
            }
        }
        if ((n = PGProperty.SEND_BUFFER_SIZE.getInt(properties)) > -1) {
            if (n > 0) {
                pGStream.getSocket().setSendBufferSize(n);
            } else {
                LOGGER.log(Level.WARNING, "Ignore invalid value for sendBufferSize: {0}", n);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Receive Buffer Size is {0}", pGStream.getSocket().getReceiveBufferSize());
            LOGGER.log(Level.FINE, "Send Buffer Size is {0}", pGStream.getSocket().getSendBufferSize());
        }
        if (!(pGStream = this.enableGSSEncrypted(pGStream, gSSEncMode, hostSpec.getHost(), string, properties, n2)).isGssEncrypted()) {
            pGStream = this.enableSSL(pGStream, sslMode, properties, n2);
        }
        if (n3 > 0) {
            pGStream.setNetworkTimeout(n3 * 1000);
        }
        List<String[]> list = this.getParametersForStartup(string, string3, properties);
        this.sendStartupPacket(pGStream, list);
        this.doAuthentication(pGStream, hostSpec.getHost(), string, string2, properties);
        return pGStream;
    }

    public PGStream openConnectionImpl(HostSpec[] hostSpecArray, String string, String string2, String string3, String string4, Properties properties) throws SQLException {
        HostRequirement hostRequirement;
        SslMode sslMode = SslMode.of((Properties)properties);
        GSSEncMode gSSEncMode = GSSEncMode.of((Properties)properties);
        String string5 = (String)Nullness.castNonNull((Object)PGProperty.TARGET_SERVER_TYPE.get(properties));
        try {
            hostRequirement = HostRequirement.getTargetServerType((String)string5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PSQLException(GT.tr((String)"Invalid targetServerType value: {0}", (Object[])new Object[]{string5}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory((Properties)properties);
        HostChooser hostChooser = HostChooserFactory.createHostChooser((HostSpec[])hostSpecArray, (HostRequirement)hostRequirement, (Properties)properties);
        Iterator iterator = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> hashMap = new HashMap<HostSpec, HostStatus>();
        while (iterator.hasNext()) {
            CandidateHost candidateHost = (CandidateHost)iterator.next();
            HostSpec hostSpec = candidateHost.hostSpec;
            LOGGER.log(Level.FINE, "Trying to establish a protocol version 3 connection to {0}", hostSpec);
            HostStatus hostStatus = (HostStatus)hashMap.get(hostSpec);
            if (hostStatus != null && !candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Known status of host {0} is {1}, and required status was {2}. Will try next host", new Object[]{hostSpec, hostStatus, candidateHost.targetServerType});
                continue;
            }
            PGStream pGStream = null;
            try {
                Exception exception;
                try {
                    pGStream = this.tryConnect(string, string2, string3, properties, socketFactory, hostSpec, sslMode, gSSEncMode);
                }
                catch (SQLException sQLException) {
                    if (sslMode == SslMode.PREFER && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(sQLException.getSQLState())) {
                        exception = null;
                        try {
                            pGStream = this.tryConnect(string, string2, string3, properties, socketFactory, hostSpec, SslMode.DISABLE, gSSEncMode);
                            LOGGER.log(Level.FINE, "Downgraded to non-encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException sQLException2) {
                            exception = sQLException2;
                        }
                        catch (IOException iOException) {
                            exception = iOException;
                        }
                        if (exception != null) {
                            ConnectionFactoryRevenj.log(Level.FINE, "sslMode==PREFER, however non-SSL connection failed as well", exception, new Object[0]);
                            sQLException.addSuppressed(exception);
                            throw sQLException;
                        }
                    }
                    if (sslMode == SslMode.ALLOW && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(sQLException.getSQLState())) {
                        exception = null;
                        try {
                            pGStream = this.tryConnect(string, string2, string3, properties, socketFactory, hostSpec, SslMode.REQUIRE, gSSEncMode);
                            LOGGER.log(Level.FINE, "Upgraded to encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException sQLException3) {
                            exception = sQLException3;
                        }
                        catch (IOException iOException) {
                            exception = iOException;
                        }
                        if (exception != null) {
                            ConnectionFactoryRevenj.log(Level.FINE, "sslMode==ALLOW, however SSL connection failed as well", exception, new Object[0]);
                            sQLException.addSuppressed(exception);
                            throw sQLException;
                        }
                    }
                    throw sQLException;
                }
                int n = PGProperty.CANCEL_SIGNAL_TIMEOUT.getInt(properties) * 1000;
                Nullness.castNonNull((Object)pGStream);
                exception = new QueryExecutorImpl(pGStream, string, string3, n, properties);
                HostStatus hostStatus2 = HostStatus.ConnectOK;
                if (candidateHost.targetServerType != HostRequirement.any) {
                    hostStatus2 = this.isPrimary((QueryExecutor)exception) ? HostStatus.Primary : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus((HostSpec)hostSpec, (HostStatus)hostStatus2);
                hashMap.put(hostSpec, hostStatus2);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus2)) {
                    exception.close();
                    continue;
                }
                this.runInitialQueries((QueryExecutor)exception, string4, properties);
                return pGStream;
            }
            catch (ConnectException connectException) {
                GlobalHostStatusTracker.reportHostStatus((HostSpec)hostSpec, (HostStatus)HostStatus.ConnectFail);
                hashMap.put(hostSpec, HostStatus.ConnectFail);
                if (iterator.hasNext()) {
                    ConnectionFactoryRevenj.log(Level.FINE, "ConnectException occurred while connecting to {0}", connectException, hostSpec);
                    continue;
                }
                throw new PSQLException(GT.tr((String)"Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", (Object[])new Object[]{hostSpec}), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)connectException);
            }
            catch (IOException iOException) {
                this.closeStream(pGStream);
                GlobalHostStatusTracker.reportHostStatus((HostSpec)hostSpec, (HostStatus)HostStatus.ConnectFail);
                hashMap.put(hostSpec, HostStatus.ConnectFail);
                if (iterator.hasNext()) {
                    ConnectionFactoryRevenj.log(Level.FINE, "IOException occurred while connecting to {0}", iOException, hostSpec);
                    continue;
                }
                throw new PSQLException(GT.tr((String)"The connection attempt failed.", (Object[])new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)iOException);
            }
            catch (SQLException sQLException) {
                this.closeStream(pGStream);
                GlobalHostStatusTracker.reportHostStatus((HostSpec)hostSpec, (HostStatus)HostStatus.ConnectFail);
                hashMap.put(hostSpec, HostStatus.ConnectFail);
                if (iterator.hasNext()) {
                    ConnectionFactoryRevenj.log(Level.FINE, "SQLException occurred while connecting to {0}", sQLException, hostSpec);
                    continue;
                }
                throw sQLException;
            }
        }
        throw new PSQLException(GT.tr((String)"Could not find a server with specified targetServerType: {0}", (Object[])new Object[]{hostRequirement}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<String[]> getParametersForStartup(String string, String string2, Properties properties) {
        String string3;
        String string4;
        String string5;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"user", string});
        arrayList.add(new String[]{"database", string2});
        arrayList.add(new String[]{"client_encoding", "UTF8"});
        arrayList.add(new String[]{"DateStyle", "ISO"});
        arrayList.add(new String[]{"TimeZone", ConnectionFactoryRevenj.createPostgresTimeZone()});
        Version version = ServerVersion.from((String)PGProperty.ASSUME_MIN_SERVER_VERSION.get(properties));
        if (version.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            arrayList.add(new String[]{"extra_float_digits", "3"});
            string5 = PGProperty.APPLICATION_NAME.get(properties);
            if (string5 != null) {
                arrayList.add(new String[]{"application_name", string5});
            }
        } else {
            arrayList.add(new String[]{"extra_float_digits", "2"});
        }
        string5 = PGProperty.REPLICATION.get(properties);
        if (string5 != null && version.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            arrayList.add(new String[]{"replication", string5});
        }
        if ((string4 = PGProperty.CURRENT_SCHEMA.get(properties)) != null) {
            arrayList.add(new String[]{"search_path", string4});
        }
        if ((string3 = PGProperty.OPTIONS.get(properties)) != null) {
            arrayList.add(new String[]{"options", string3});
        }
        return arrayList;
    }

    private static void log(Level level, String string, Throwable throwable, Object ... objectArray) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setLoggerName(LOGGER.getName());
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        LOGGER.log(logRecord);
    }

    private static String createPostgresTimeZone() {
        String string;
        String string2 = TimeZone.getDefault().getID();
        if (string2.length() <= 3 || !string2.startsWith("GMT")) {
            return string2;
        }
        char c = string2.charAt(3);
        switch (c) {
            case '+': {
                string = "GMT-";
                break;
            }
            case '-': {
                string = "GMT+";
                break;
            }
            default: {
                return string2;
            }
        }
        return string + string2.substring(4);
    }

    private boolean credentialCacheExists() {
        return Unsafe.credentialCacheExists();
    }

    private PGStream enableGSSEncrypted(PGStream pGStream, GSSEncMode gSSEncMode, String string, String string2, Properties properties, int n) throws IOException, PSQLException {
        if (gSSEncMode == GSSEncMode.DISABLE) {
            return pGStream;
        }
        if (gSSEncMode == GSSEncMode.ALLOW) {
            return pGStream;
        }
        if (!this.credentialCacheExists()) {
            if (gSSEncMode == GSSEncMode.REQUIRE) {
                throw new PSQLException("GSSAPI encryption required but was impossible (possibly no credential cache)", PSQLState.CONNECTION_REJECTED);
            }
            return pGStream;
        }
        String string3 = PGProperty.PASSWORD.get(properties);
        LOGGER.log(Level.FINEST, " FE=> GSSENCRequest");
        pGStream.sendInteger4(8);
        pGStream.sendInteger2(1234);
        pGStream.sendInteger2(5680);
        pGStream.flush();
        int n2 = pGStream.receiveChar();
        switch (n2) {
            case 69: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncrypted Error");
                if (gSSEncMode.requireEncryption()) {
                    throw new PSQLException(GT.tr((String)"The server does not support GSS Encoding.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                pGStream.close();
                return new PGStream(pGStream.getSocketFactory(), pGStream.getHostSpec(), n);
            }
            case 78: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncrypted Refused");
                if (gSSEncMode.requireEncryption()) {
                    throw new PSQLException(GT.tr((String)"The server does not support GSS Encryption.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pGStream;
            }
            case 71: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncryptedOk");
                try {
                    MakeGSS.authenticate((boolean)true, (PGStream)pGStream, (String)string, (String)string2, (String)string3, (String)PGProperty.JAAS_APPLICATION_NAME.get(properties), (String)PGProperty.KERBEROS_SERVER_NAME.get(properties), (boolean)false, (boolean)PGProperty.JAAS_LOGIN.getBoolean(properties), (boolean)PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(properties));
                    return pGStream;
                }
                catch (PSQLException pSQLException) {
                    if (gSSEncMode != GSSEncMode.PREFER) break;
                    return new PGStream(pGStream, n);
                }
            }
        }
        throw new PSQLException(GT.tr((String)"An error occurred while setting up the GSS Encoded connection.", (Object[])new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private PGStream enableSSL(PGStream pGStream, SslMode sslMode, Properties properties, int n) throws IOException, PSQLException {
        if (sslMode == SslMode.DISABLE) {
            return pGStream;
        }
        if (sslMode == SslMode.ALLOW) {
            return pGStream;
        }
        LOGGER.log(Level.FINEST, " FE=> SSLRequest");
        pGStream.sendInteger4(8);
        pGStream.sendInteger2(1234);
        pGStream.sendInteger2(5679);
        pGStream.flush();
        int n2 = pGStream.receiveChar();
        switch (n2) {
            case 69: {
                LOGGER.log(Level.FINEST, " <=BE SSLError");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr((String)"The server does not support SSL.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return new PGStream(pGStream, n);
            }
            case 78: {
                LOGGER.log(Level.FINEST, " <=BE SSLRefused");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr((String)"The server does not support SSL.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pGStream;
            }
            case 83: {
                LOGGER.log(Level.FINEST, " <=BE SSLOk");
                MakeSSL.convert((PGStream)pGStream, (Properties)properties);
                return pGStream;
            }
        }
        throw new PSQLException(GT.tr((String)"An error occurred while setting up the SSL connection.", (Object[])new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(PGStream pGStream, List<String[]> list) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(list.get(i)[0]);
                stringBuilder.append("=");
                stringBuilder.append(list.get(i)[1]);
            }
            LOGGER.log(Level.FINEST, " FE=> StartupPacket({0})", stringBuilder);
        }
        int n = 8;
        byte[][] byArrayArray = new byte[list.size() * 2][];
        for (int i = 0; i < list.size(); ++i) {
            byArrayArray[i * 2] = list.get(i)[0].getBytes(StandardCharsets.UTF_8);
            byArrayArray[i * 2 + 1] = list.get(i)[1].getBytes(StandardCharsets.UTF_8);
            n += byArrayArray[i * 2].length + 1 + byArrayArray[i * 2 + 1].length + 1;
        }
        pGStream.sendInteger4(++n);
        pGStream.sendInteger2(3);
        pGStream.sendInteger2(0);
        for (byte[] byArray : byArrayArray) {
            pGStream.send(byArray);
            pGStream.sendChar(0);
        }
        pGStream.sendChar(0);
        pGStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuthentication(PGStream pGStream, String string, String string2, String string3, Properties properties) throws IOException, SQLException {
        block37: {
            ISSPIClient iSSPIClient = null;
            ScramAuthenticator scramAuthenticator = null;
            try {
                while (true) {
                    int n = pGStream.receiveChar();
                    block3 : switch (n) {
                        case 69: {
                            int n2 = pGStream.receiveInteger4();
                            ServerErrorMessage serverErrorMessage = new ServerErrorMessage(pGStream.receiveErrorString(n2 - 4));
                            LOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", serverErrorMessage);
                            throw new PSQLException(serverErrorMessage, PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(properties));
                        }
                        case 82: {
                            int n3 = pGStream.receiveInteger4();
                            int n4 = pGStream.receiveInteger4();
                            switch (n4) {
                                case 5: {
                                    Object object = pGStream.receive(4);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqMD5(salt={0})", Utils.toHexString((byte[])object));
                                    }
                                    if (string3 == null) {
                                        throw new PSQLException(GT.tr((String)"The server requested password-based authentication, but no password was provided.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] byArray = MD5Digest.encode((byte[])string2.getBytes(StandardCharsets.UTF_8), (byte[])string3.getBytes(StandardCharsets.UTF_8), (byte[])object);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " FE=> Password(md5digest={0})", new String(byArray, StandardCharsets.US_ASCII));
                                    }
                                    pGStream.sendChar(112);
                                    pGStream.sendInteger4(4 + byArray.length + 1);
                                    pGStream.send(byArray);
                                    pGStream.sendChar(0);
                                    pGStream.flush();
                                    break block3;
                                }
                                case 3: {
                                    LOGGER.log(Level.FINEST, "<=BE AuthenticationReqPassword");
                                    LOGGER.log(Level.FINEST, " FE=> Password(password=<not shown>)");
                                    if (string3 == null) {
                                        throw new PSQLException(GT.tr((String)"The server requested password-based authentication, but no password was provided.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                                    }
                                    Object object = string3.getBytes(StandardCharsets.UTF_8);
                                    pGStream.sendChar(112);
                                    pGStream.sendInteger4(4 + ((byte[])object).length + 1);
                                    pGStream.send(object);
                                    pGStream.sendChar(0);
                                    pGStream.flush();
                                    break block3;
                                }
                                case 7: 
                                case 9: {
                                    Object object = PGProperty.GSS_LIB.get(properties);
                                    boolean bl = PGProperty.USE_SPNEGO.getBoolean(properties);
                                    boolean bl2 = false;
                                    if ("gssapi".equals(object)) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, param gsslib=gssapi");
                                    } else if (n4 == 7 && !"sspi".equals(object)) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced");
                                    } else {
                                        iSSPIClient = this.createSSPI(pGStream, PGProperty.SSPI_SERVICE_CLASS.get(properties), n4 == 9 || n4 == 7 && bl);
                                        bl2 = iSSPIClient.isSSPISupported();
                                        LOGGER.log(Level.FINE, "SSPI support detected: {0}", bl2);
                                        if (!bl2) {
                                            iSSPIClient = null;
                                            if ("sspi".equals(object)) {
                                                throw new PSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                            }
                                        }
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Using SSPI: {0}, gsslib={1} and SSPI support detected", new Object[]{bl2, object});
                                        }
                                    }
                                    if (bl2) {
                                        ((ISSPIClient)Nullness.castNonNull(iSSPIClient)).startSSPI();
                                        break block3;
                                    }
                                    MakeGSS.authenticate((boolean)false, (PGStream)pGStream, (String)string, (String)string2, (String)string3, (String)PGProperty.JAAS_APPLICATION_NAME.get(properties), (String)PGProperty.KERBEROS_SERVER_NAME.get(properties), (boolean)bl, (boolean)PGProperty.JAAS_LOGIN.getBoolean(properties), (boolean)PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(properties));
                                    break block3;
                                }
                                case 8: {
                                    ((ISSPIClient)Nullness.castNonNull(iSSPIClient)).continueSSPI(n3 - 8);
                                    break block3;
                                }
                                case 10: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationSASL");
                                    if (string3 == null) {
                                        throw new PSQLException(GT.tr((String)"The server requested SCRAM-based authentication, but no password was provided.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                                    }
                                    if (string3.equals("")) {
                                        throw new PSQLException(GT.tr((String)"The server requested SCRAM-based authentication, but the password is an empty string.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                                    }
                                    scramAuthenticator = new ScramAuthenticator(string2, (String)Nullness.castNonNull((Object)string3), pGStream);
                                    scramAuthenticator.processServerMechanismsAndInit();
                                    scramAuthenticator.sendScramClientFirstMessage();
                                    break block3;
                                }
                                case 11: {
                                    ((ScramAuthenticator)Nullness.castNonNull(scramAuthenticator)).processServerFirstMessage(n3 - 4 - 4);
                                    break block3;
                                }
                                case 12: {
                                    ((ScramAuthenticator)Nullness.castNonNull(scramAuthenticator)).verifyServerSignature(n3 - 4 - 4);
                                    break block3;
                                }
                                case 0: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationOk");
                                    break block37;
                                }
                                default: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationReq (unsupported type {0})", n4);
                                    throw new PSQLException(GT.tr((String)"The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", (Object[])new Object[]{n4}), PSQLState.CONNECTION_REJECTED);
                                }
                            }
                        }
                        default: {
                            throw new PSQLException(GT.tr((String)"Protocol error.  Session setup failed.", (Object[])new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                        }
                    }
                }
            }
            finally {
                if (iSSPIClient != null) {
                    try {
                        iSSPIClient.dispose();
                    }
                    catch (RuntimeException runtimeException) {
                        LOGGER.log(Level.FINE, "Unexpected error during SSPI context disposal", runtimeException);
                    }
                }
            }
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutor, String string, Properties properties) throws SQLException {
        String string2 = PGProperty.ASSUME_MIN_SERVER_VERSION.get(properties);
        if (Utils.parseServerVersionStr((String)string2) >= ServerVersion.v9_0.getVersionNum()) {
            return;
        }
        int n = queryExecutor.getServerVersionNum();
        if (n >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run((QueryExecutor)queryExecutor, (String)"BEGIN", (boolean)false);
        }
        if (n >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run((QueryExecutor)queryExecutor, (String)"SET extra_float_digits = 3", (boolean)false);
        }
        String string3 = string = string != null ? string : PGProperty.APPLICATION_NAME.get(properties);
        if (string != null && n >= ServerVersion.v9_0.getVersionNum()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SET application_name = '");
            Utils.escapeLiteral((StringBuilder)stringBuilder, (String)string, (boolean)queryExecutor.getStandardConformingStrings());
            stringBuilder.append("'");
            SetupQueryRunner.run((QueryExecutor)queryExecutor, (String)stringBuilder.toString(), (boolean)false);
        }
        if (n >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run((QueryExecutor)queryExecutor, (String)"COMMIT", (boolean)false);
        }
    }

    private boolean isPrimary(QueryExecutor queryExecutor) throws SQLException, IOException {
        Tuple tuple = SetupQueryRunner.run((QueryExecutor)queryExecutor, (String)"show transaction_read_only", (boolean)true);
        Tuple tuple2 = (Tuple)Nullness.castNonNull((Object)tuple);
        String string = queryExecutor.getEncoding().decode((byte[])Nullness.castNonNull((Object)tuple2.get(0)));
        return string.equalsIgnoreCase("off");
    }

    protected void closeStream(PGStream pGStream) {
        if (pGStream != null) {
            try {
                pGStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

