/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import net.revenj.database.postgres.PostgresWriter;
import net.revenj.database.postgres.converters.PostgresTuple;
import net.revenj.database.postgres.converters.PostgresTuple$;
import net.revenj.database.postgres.converters.ValueTuple$;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\u000f\u001e\u0001!B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003A\u0011!1\u0005A!b\u0001\n\u0003!\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b!\u0003A\u0011A%\t\u000b=\u0003A\u0011\t)\t\u000bM\u0003A\u0011\u0002+\t\u000b-\u0004A\u0011\u00017\t\u000bA\u0004A\u0011I9\b\u000bUl\u0002\u0012\u0001<\u0007\u000bqi\u0002\u0012A<\t\u000b!kA\u0011\u0001=\t\u000fel!\u0019!C\u0001u\"110\u0004Q\u0001\n=2A\u0001`\u0007\u0005{\")\u0001*\u0005C\u0001}\"91)\u0005b\u0001\n\u0003!\u0005BB#\u0012A\u0003%\u0001\tC\u0004G#\t\u0007I\u0011\u0001#\t\r\u001d\u000b\u0002\u0015!\u0003A\u0011\u0019Y\u0017\u0003\"\u0001\u0002\u0004!1q*\u0005C!\u0003\u0017Aq!a\u0004\u000e\t\u0003\t\t\u0002C\u0004\u0002\u00165!\t!a\u0006\t\u000f\u0005=Q\u0002\"\u0001\u0002\u001c\tQa+\u00197vKR+\b\u000f\\3\u000b\u0005yy\u0012AC2p]Z,'\u000f^3sg*\u0011\u0001%I\u0001\ta>\u001cHo\u001a:fg*\u0011!eI\u0001\tI\u0006$\u0018MY1tK*\u0011A%J\u0001\u0007e\u00164XM\u001c6\u000b\u0003\u0019\n1A\\3u\u0007\u0001\u00192\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001'M\u0007\u0002;%\u0011!'\b\u0002\u000e!>\u001cHo\u001a:fgR+\b\u000f\\3\u0002\u000bY\fG.^3\u0011\u0005UbdB\u0001\u001c;!\t94&D\u00019\u0015\tIt%\u0001\u0004=e>|GOP\u0005\u0003w-\na\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111hK\u0001\u000bQ\u0006\u001cX*\u0019:lKJ\u001c\bC\u0001\u0016B\u0013\t\u00115FA\u0004C_>dW-\u00198\u0002!5,8\u000f^#tG\u0006\u0004XMU3d_J$W#\u0001!\u0002#5,8\u000f^#tG\u0006\u0004XMU3d_J$\u0007%A\bnkN$Xi]2ba\u0016\f%O]1z\u0003AiWo\u001d;Fg\u000e\f\u0007/Z!se\u0006L\b%\u0001\u0004=S:LGO\u0010\u000b\u0006\u0015.cUJ\u0014\t\u0003a\u0001AQaM\u0004A\u0002QBQaP\u0004A\u0002\u0001CQaQ\u0004A\u0002\u0001CQAR\u0004A\u0002\u0001\u000b!BY;jY\u0012$V\u000f\u001d7f)\t!\u0014\u000bC\u0003S\u0011\u0001\u0007\u0001)A\u0003rk>$X-\u0001\u0004fg\u000e\f\u0007/\u001a\u000b\u0005+bs\u0006\r\u0005\u0002+-&\u0011qk\u000b\u0002\u0005+:LG\u000fC\u0003Z\u0013\u0001\u0007!,\u0001\u0002toB\u00111\fX\u0007\u0002?%\u0011Ql\b\u0002\u000f!>\u001cHo\u001a:fg^\u0013\u0018\u000e^3s\u0011\u0015y\u0016\u00021\u00015\u0003!)7oY1qS:<\u0007\"B1\n\u0001\u0004\u0011\u0017\u0001C7baBLgnZ:\u0011\u0007)\u001aW-\u0003\u0002eW\t1q\n\u001d;j_:\u0004RA\u000b4[QVK!aZ\u0016\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\u0016j\u0013\tQ7F\u0001\u0003DQ\u0006\u0014\u0018\u0001D5og\u0016\u0014HOU3d_J$G\u0003B+n]>DQ!\u0017\u0006A\u0002iCQa\u0018\u0006A\u0002QBQ!\u0019\u0006A\u0002\t\f1\"\u001b8tKJ$\u0018I\u001d:bsR!QK]:u\u0011\u0015I6\u00021\u0001[\u0011\u0015y6\u00021\u00015\u0011\u0015\t7\u00021\u0001c\u0003)1\u0016\r\\;f)V\u0004H.\u001a\t\u0003a5\u0019\"!D\u0015\u0015\u0003Y\fQ!R'Q)f+\u0012aL\u0001\u0007\u000b6\u0003F+\u0017\u0011\u0003\u001f\u0015k\u0007\u000f^=WC2,X\rV;qY\u0016\u001c2!E\u00150)\u0005y\bcAA\u0001#5\tQ\u0002F\u0004V\u0003\u000b\t9!!\u0003\t\u000be;\u0002\u0019\u0001.\t\u000b};\u0002\u0019\u0001\u001b\t\u000b\u0005<\u0002\u0019\u00012\u0015\u0007Q\ni\u0001C\u0003S1\u0001\u0007\u0001)A\u0003baBd\u0017\u0010F\u0002K\u0003'AQaM\rA\u0002Q\nAA\u001a:p[R\u0019q&!\u0007\t\u000bMR\u0002\u0019\u0001\u001b\u0015\u000fU\u000bi\"a\b\u0002$!)1g\u0007a\u0001i!1\u0011\u0011E\u000eA\u0002\u0001\u000baA]3d_J$\u0007BBA\u00137\u0001\u0007\u0001)A\u0003beJ\f\u0017\u0010")
public class ValueTuple
implements PostgresTuple {
    private final String value;
    private final boolean hasMarkers;
    private final boolean mustEscapeRecord;
    private final boolean mustEscapeArray;

    public static void apply(String value, boolean record, boolean array) {
        ValueTuple$.MODULE$.apply(value, record, array);
    }

    public static PostgresTuple from(String value) {
        return ValueTuple$.MODULE$.from(value);
    }

    public static ValueTuple apply(String value) {
        return ValueTuple$.MODULE$.apply(value);
    }

    public static PostgresTuple EMPTY() {
        return ValueTuple$.MODULE$.EMPTY();
    }

    @Override
    public void buildTuple(PostgresWriter sw, boolean quote) {
        PostgresTuple.buildTuple$(this, sw, quote);
    }

    @Override
    public boolean mustEscapeRecord() {
        return this.mustEscapeRecord;
    }

    @Override
    public boolean mustEscapeArray() {
        return this.mustEscapeArray;
    }

    @Override
    public String buildTuple(boolean quote) {
        if (this.value == null) {
            return "NULL";
        }
        if (quote) {
            return new StringBuilder(2).append("'").append(this.value.replace("'", "''")).append("'").toString();
        }
        return this.value;
    }

    private void escape(PostgresWriter sw, String escaping, Option<Function2<PostgresWriter, Object, BoxedUnit>> mappings) {
        LazyRef quoteEscape$lzy = new LazyRef();
        LazyRef slashEscape$lzy = new LazyRef();
        if (mappings instanceof Some) {
            Function2 m = (Function2)((Some)mappings).value();
            for (int i = 0; i < this.value.length(); ++i) {
                char c = this.value.charAt(i);
                if (c == '\"') {
                    for (int x = 0; x < ValueTuple.quoteEscape$1(quoteEscape$lzy, escaping).length(); ++x) {
                        m.apply((Object)sw, (Object)BoxesRunTime.boxToCharacter((char)ValueTuple.quoteEscape$1(quoteEscape$lzy, escaping).charAt(x)));
                    }
                    continue;
                }
                if (c == '\\') {
                    for (int x = 0; x < ValueTuple.slashEscape$1(slashEscape$lzy, escaping).length(); ++x) {
                        m.apply((Object)sw, (Object)BoxesRunTime.boxToCharacter((char)ValueTuple.slashEscape$1(slashEscape$lzy, escaping).charAt(x)));
                    }
                    continue;
                }
                m.apply((Object)sw, (Object)BoxesRunTime.boxToCharacter((char)c));
            }
            return;
        }
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\"') {
                sw.write(ValueTuple.quoteEscape$1(quoteEscape$lzy, escaping));
                continue;
            }
            if (c == '\\') {
                sw.write(ValueTuple.slashEscape$1(slashEscape$lzy, escaping));
                continue;
            }
            sw.write(c);
        }
    }

    @Override
    public void insertRecord(PostgresWriter sw, String escaping, Option<Function2<PostgresWriter, Object, BoxedUnit>> mappings) {
        if (this.hasMarkers) {
            this.escape(sw, escaping, mappings);
            return;
        }
        if (mappings instanceof Some) {
            Function2 m = (Function2)((Some)mappings).value();
            for (int x = 0; x < this.value.length(); ++x) {
                m.apply((Object)sw, (Object)BoxesRunTime.boxToCharacter((char)this.value.charAt(x)));
            }
            return;
        }
        if (this.value != null) {
            sw.write(this.value);
            return;
        }
    }

    @Override
    public void insertArray(PostgresWriter sw, String escaping, Option<Function2<PostgresWriter, Object, BoxedUnit>> mappings) {
        if (this.value == null) {
            sw.write("NULL");
            return;
        }
        if (this.hasMarkers) {
            this.escape(sw, escaping, mappings);
            return;
        }
        if (mappings instanceof Some) {
            Function2 m = (Function2)((Some)mappings).value();
            for (int x = 0; x < this.value.length(); ++x) {
                m.apply((Object)sw, (Object)BoxesRunTime.boxToCharacter((char)this.value.charAt(x)));
            }
            return;
        }
        sw.write(this.value);
    }

    private static final /* synthetic */ String quoteEscape$lzycompute$1(LazyRef quoteEscape$lzy$1, String escaping$1) {
        synchronized (quoteEscape$lzy$1) {
            String string = quoteEscape$lzy$1.initialized() ? (String)quoteEscape$lzy$1.value() : (String)quoteEscape$lzy$1.initialize((Object)PostgresTuple$.MODULE$.buildQuoteEscape(escaping$1));
            return string;
        }
    }

    private static final String quoteEscape$1(LazyRef quoteEscape$lzy$1, String escaping$1) {
        if (quoteEscape$lzy$1.initialized()) {
            return (String)quoteEscape$lzy$1.value();
        }
        return ValueTuple.quoteEscape$lzycompute$1(quoteEscape$lzy$1, escaping$1);
    }

    private static final /* synthetic */ String slashEscape$lzycompute$1(LazyRef slashEscape$lzy$1, String escaping$1) {
        synchronized (slashEscape$lzy$1) {
            String string = slashEscape$lzy$1.initialized() ? (String)slashEscape$lzy$1.value() : (String)slashEscape$lzy$1.initialize((Object)PostgresTuple$.MODULE$.buildSlashEscape(escaping$1.length()));
            return string;
        }
    }

    private static final String slashEscape$1(LazyRef slashEscape$lzy$1, String escaping$1) {
        if (slashEscape$lzy$1.initialized()) {
            return (String)slashEscape$lzy$1.value();
        }
        return ValueTuple.slashEscape$lzycompute$1(slashEscape$lzy$1, escaping$1);
    }

    public ValueTuple(String value, boolean hasMarkers, boolean mustEscapeRecord, boolean mustEscapeArray) {
        this.value = value;
        this.hasMarkers = hasMarkers;
        this.mustEscapeRecord = mustEscapeRecord;
        this.mustEscapeArray = mustEscapeArray;
        PostgresTuple.$init$(this);
    }

    private static class EmptyValueTuple
    implements PostgresTuple {
        private final boolean mustEscapeRecord;
        private final boolean mustEscapeArray;

        @Override
        public void insertArray(PostgresWriter writer, String escaping, Option<Function2<PostgresWriter, Object, BoxedUnit>> mappings) {
            PostgresTuple.insertArray$(this, writer, escaping, mappings);
        }

        @Override
        public void buildTuple(PostgresWriter sw, boolean quote) {
            PostgresTuple.buildTuple$(this, sw, quote);
        }

        @Override
        public boolean mustEscapeRecord() {
            return this.mustEscapeRecord;
        }

        @Override
        public boolean mustEscapeArray() {
            return this.mustEscapeArray;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, Option<Function2<PostgresWriter, Object, BoxedUnit>> mappings) {
        }

        @Override
        public String buildTuple(boolean quote) {
            if (quote) {
                return "'\"\"'";
            }
            return "\"\"";
        }

        public EmptyValueTuple() {
            PostgresTuple.$init$(this);
            this.mustEscapeRecord = true;
            this.mustEscapeArray = true;
        }
    }
}

