/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import net.revenj.database.postgres.converters.PostgresTuple;
import net.revenj.database.postgres.converters.PostgresTuple$;
import net.revenj.database.postgres.converters.ValueTuple;

public final class ValueTuple$ {
    public static final ValueTuple$ MODULE$ = new ValueTuple$();
    private static final PostgresTuple EMPTY = new ValueTuple.EmptyValueTuple();

    public PostgresTuple EMPTY() {
        return EMPTY;
    }

    public ValueTuple apply(String value) {
        if (value != null) {
            boolean hasMarkers = false;
            boolean escapeRecord = value.length() == 0;
            boolean escapeArray = value.length() == 0 || value.equals("NULL");
            boolean hasWhitespace = false;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\\' || c == '\"') {
                    hasMarkers = true;
                    escapeRecord = true;
                    escapeArray = true;
                    i = value.length();
                    continue;
                }
                if (c == ',') {
                    escapeRecord = true;
                    escapeArray = true;
                    continue;
                }
                if (c == '(' || c == ')') {
                    escapeRecord = true;
                    continue;
                }
                if (c == '{' || c == '}') {
                    escapeArray = true;
                    continue;
                }
                if (hasWhitespace) continue;
                hasWhitespace = Character.isWhitespace(c);
            }
            return new ValueTuple(value, hasMarkers, hasMarkers || escapeRecord || hasWhitespace, hasMarkers || escapeArray || hasWhitespace);
        }
        return new ValueTuple(null, false, false, true);
    }

    public PostgresTuple from(String value) {
        if (value == null) {
            return PostgresTuple$.MODULE$.NULL();
        }
        if (value.length() == 0) {
            return this.EMPTY();
        }
        return this.apply(value);
    }

    public void apply(String value, boolean record, boolean array) {
        new ValueTuple(value, record || array, record, array);
    }

    private ValueTuple$() {
    }
}

