/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres;

import java.io.IOException;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.patterns.ServiceLocator;
import scala.Option;
import scala.Option$;

public final class PostgresReader$ {
    public static final PostgresReader$ MODULE$ = new PostgresReader$();

    public PostgresReader create(ServiceLocator locator) {
        return new PostgresReader((Option<ServiceLocator>)Option$.MODULE$.apply((Object)locator));
    }

    private int findEscapedChar(String input) {
        int found = -1;
        for (int i = 0; found == -1 && i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != '\\' && c != '/') continue;
            found = i;
        }
        return found;
    }

    public void parseCompositeURI(String uri, String[] result) {
        int index = 0;
        int i = this.findEscapedChar(uri);
        if (i == -1) {
            result[0] = uri;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uri, 0, i);
        while (i < uri.length()) {
            char c = uri.charAt(i);
            if (c == '\\') {
                sb.append(uri.charAt(++i));
            } else if (c == '/') {
                result[index] = sb.toString();
                if (++index == result.length) {
                    throw new IOException(new StringBuilder(50).append("Invalid URI provided: ").append(uri).append(". Number of expected parts: ").append(result.length).toString());
                }
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            ++i;
        }
        sb.append(uri, i, uri.length());
        result[index] = sb.toString();
    }

    private PostgresReader$() {
    }
}

