/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres;

import java.io.Closeable;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import net.revenj.patterns.DataChangeNotification;
import net.revenj.patterns.DataChangeNotification$NotifyInfo$;
import net.revenj.patterns.DataChangeNotification$Operation$Change$;
import net.revenj.patterns.DataChangeNotification$Operation$Delete$;
import net.revenj.patterns.DataChangeNotification$Operation$Insert$;
import net.revenj.patterns.DataChangeNotification$Operation$Update$;
import net.revenj.patterns.EagerNotification;
import net.revenj.patterns.Identifiable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\u0006\r\u0001UA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)\u0001\b\u0001C\u0001s!Aa\b\u0001EC\u0002\u0013%q\bC\u0004Y\u0001\t\u0007I\u0011B-\t\ru\u0003\u0001\u0015!\u0003[\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0019q\u0006\u0001\"\u0001\u0002\u0018!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0002\u001a\t\u0006$\u0018MY1tK:{G/\u001b4jG\u0006$\u0018n\u001c8Rk\u0016,XM\u0003\u0002\u000e\u001d\u0005A\u0001o\\:uOJ,7O\u0003\u0002\u0010!\u0005AA-\u0019;bE\u0006\u001cXM\u0003\u0002\u0012%\u00051!/\u001a<f]*T\u0011aE\u0001\u0004]\u0016$8\u0001A\n\u0004\u0001Yq\u0002CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011a\u0017M\\4\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005R\u0012AA5p\u0013\t\u0019\u0003EA\u0005DY>\u001cX-\u00192mK\u0006ian\u001c;jM&\u001c\u0017\r^5p]N\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\t\u0002\u0011A\fG\u000f^3s]NL!AK\u0014\u0003#\u0015\u000bw-\u001a:O_RLg-[2bi&|g.A\u000bue\u0006t7/Y2uS>t7i\u001c8oK\u000e$\u0018n\u001c8\u0011\u00075\u0002$'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019y\u0005\u000f^5p]B\u00111GN\u0007\u0002i)\u0011QGG\u0001\u0004gFd\u0017BA\u001c5\u0005)\u0019uN\u001c8fGRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ibT\b\u0005\u0002<\u00015\tA\u0002C\u0003%\u0007\u0001\u0007Q\u0005C\u0003,\u0007\u0001\u0007A&A\u0003rk\u0016,X-F\u0001A!\r\te\tS\u0007\u0002\u0005*\u00111\tR\u0001\u000bG>t7-\u001e:sK:$(BA#\u001b\u0003\u0011)H/\u001b7\n\u0005\u001d\u0013%a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007CA%V\u001d\tQ5K\u0004\u0002L%:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001fR\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0005E\u0011\u0012B\u0001\u0015\u0011\u0013\t!v%\u0001\fECR\f7\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u0013\t1vK\u0001\u0006O_RLg-_%oM>T!\u0001V\u0014\u0002\u0017%t\u0017+^3vK6{G-Z\u000b\u00025B\u0011QfW\u0005\u00039:\u0012qAQ8pY\u0016\fg.\u0001\u0007j]F+X-^3N_\u0012,\u0007%A\u0007o_RLg-_(s#V,W/Z\u000b\u0003Aj$\u0002\"\u00193ga\u0006\u001d\u00111\u0003\t\u0003[\tL!a\u0019\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\u001e\u0001\rAM\u0001\u000bG>tg.Z2uS>t\u0007\"B4\b\u0001\u0004A\u0017\u0001\u00028b[\u0016\u0004\"![7\u000f\u0005)\\\u0007CA'/\u0013\tag&\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u0014aa\u0015;sS:<'B\u00017/\u0011\u0015\tx\u00011\u0001s\u0003\u0019Ign]3siB\u00191O\u001e=\u000e\u0003QT!!\u001e\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002xi\n\u00191+Z9\u0011\u0005eTH\u0002\u0001\u0003\u0006w\u001e\u0011\r\u0001 \u0002\u0002)F\u0019Q0!\u0001\u0011\u00055r\u0018BA@/\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AJA\u0002\u0013\r\t)a\n\u0002\r\u0013\u0012,g\u000e^5gS\u0006\u0014G.\u001a\u0005\b\u0003\u00139\u0001\u0019AA\u0006\u0003\u0019)\b\u000fZ1uKB!1O^A\u0007!\u0015i\u0013q\u0002=y\u0013\r\t\tB\f\u0002\u0007)V\u0004H.\u001a\u001a\t\r\u0005Uq\u00011\u0001s\u0003\u0019!W\r\\3uKV!\u0011\u0011DA\u0013)\u001d\t\u00171DA\u000f\u0003?AQ!\u001a\u0005A\u0002IBQa\u001a\u0005A\u0002!Da!\u001d\u0005A\u0002\u0005\u0005\u0002\u0003B:w\u0003G\u00012!_A\u0013\t\u0015Y\bB1\u0001}\u0003%\tX/Z;f'&TX-\u0006\u0002\u0002,A\u0019Q&!\f\n\u0007\u0005=bFA\u0002J]R\fQa\u00197pg\u0016$\u0012!\u0019")
public class DatabaseNotificationQueue
implements Closeable {
    private LinkedBlockingQueue<DataChangeNotification.NotifyInfo> queue;
    private final EagerNotification notifications;
    private final Option<Connection> transactionConnection;
    private final boolean inQueueMode;
    private volatile boolean bitmap$0;

    private LinkedBlockingQueue<DataChangeNotification.NotifyInfo> queue$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.queue = new LinkedBlockingQueue();
                this.bitmap$0 = true;
            }
        }
        return this.queue;
    }

    private LinkedBlockingQueue<DataChangeNotification.NotifyInfo> queue() {
        if (!this.bitmap$0) {
            return this.queue$lzycompute();
        }
        return this.queue;
    }

    private boolean inQueueMode() {
        return this.inQueueMode;
    }

    public <T extends Identifiable> void notifyOrQueue(Connection connection, String name, Seq<T> insert, Seq<Tuple2<T, T>> update, Seq<T> delete) {
        if (this.inQueueMode() && this.transactionConnection.get() == connection) {
            if (insert != null && insert.nonEmpty()) {
                this.queue().add(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Insert$.MODULE$, insert));
            }
            if (update != null && update.nonEmpty()) {
                this.queue().add(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Update$.MODULE$, (Seq)update.map((Function1 & Serializable)x$1 -> (Identifiable)x$1._2())));
                if (((Seq)update.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DatabaseNotificationQueue.$anonfun$notifyOrQueue$2(x0$1)))).nonEmpty()) {
                    this.queue().add(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Change$.MODULE$, (Seq)update.map((Function1 & Serializable)x$2 -> (Identifiable)x$2._1())));
                }
            }
            if (delete != null && delete.nonEmpty()) {
                this.queue().add(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Delete$.MODULE$, delete));
                return;
            }
            return;
        }
        if (connection.getAutoCommit()) {
            if (insert != null && insert.nonEmpty()) {
                this.notifications.notify(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Insert$.MODULE$, insert));
            }
            if (update != null && update.nonEmpty()) {
                this.notifications.notify(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Update$.MODULE$, (Seq)update.map((Function1 & Serializable)x$3 -> (Identifiable)x$3._2())));
                if (((Seq)update.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DatabaseNotificationQueue.$anonfun$notifyOrQueue$5(x0$2)))).nonEmpty()) {
                    this.notifications.notify(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Change$.MODULE$, (Seq)update.map((Function1 & Serializable)x$4 -> (Identifiable)x$4._1())));
                }
            }
            if (delete != null && delete.nonEmpty()) {
                this.notifications.notify(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Delete$.MODULE$, delete));
                return;
            }
            return;
        }
    }

    public <T extends Identifiable> void notifyOrQueue(Connection connection, String name, Seq<T> insert) {
        if (this.inQueueMode() && this.transactionConnection.get() == connection) {
            if (insert != null && insert.nonEmpty()) {
                this.queue().add(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Insert$.MODULE$, insert));
                return;
            }
            return;
        }
        if (connection.getAutoCommit()) {
            if (insert != null && insert.nonEmpty()) {
                this.notifications.notify(DataChangeNotification$NotifyInfo$.MODULE$.apply(name, DataChangeNotification$Operation$Insert$.MODULE$, insert));
                return;
            }
            return;
        }
    }

    public int queueSize() {
        if (this.inQueueMode()) {
            return this.queue().size();
        }
        return 0;
    }

    @Override
    public void close() {
        if (this.inQueueMode()) {
            Connection connection = (Connection)this.transactionConnection.get();
            if (connection.isClosed() || connection.getAutoCommit()) {
                Iterator<DataChangeNotification.NotifyInfo> iter = this.queue().iterator();
                while (iter.hasNext()) {
                    this.notifications.notify(iter.next());
                }
                this.queue().clear();
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$notifyOrQueue$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            Identifiable l = (Identifiable)x0$1._1();
            Identifiable r = (Identifiable)x0$1._2();
            if (l != null) {
                String string = l.URI();
                String string2 = r.URI();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$notifyOrQueue$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            Identifiable l = (Identifiable)x0$2._1();
            Identifiable r = (Identifiable)x0$2._2();
            if (l != null) {
                String string = l.URI();
                String string2 = r.URI();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public DatabaseNotificationQueue(EagerNotification notifications, Option<Connection> transactionConnection) {
        this.notifications = notifications;
        this.transactionConnection = transactionConnection;
        this.inQueueMode = transactionConnection.isDefined() && !((Connection)transactionConnection.get()).getAutoCommit();
    }
}

