/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.cache;

import java.io.Serializable;
import net.revenj.patterns.DataCache;
import net.revenj.patterns.Identifiable;
import net.revenj.patterns.Repository;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.ref.WeakReference;
import scala.ref.WeakReference$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005A4A!\u0003\u0006\u0001#!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u0003/\u0001\u0011\u0005q\u0006\u0003\u0005\f\u0001!\u0015\r\u0011\"\u00034\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015i\u0006\u0001\"\u0003_\u0011\u0015i\u0006\u0001\"\u0003f\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015Y\u0007\u0001\"\u0011o\u000559V-Y6ECR\f7)Y2iK*\u00111\u0002D\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003\u001b9\taA]3wK:T'\"A\b\u0002\u00079,Go\u0001\u0001\u0016\u0005I\t3c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u00042AG\u000f \u001b\u0005Y\"B\u0001\u000f\r\u0003!\u0001\u0018\r\u001e;fe:\u001c\u0018B\u0001\u0010\u001c\u0005%!\u0015\r^1DC\u000eDW\r\u0005\u0002!C1\u0001A!\u0002\u0012\u0001\u0005\u0004\u0019#!\u0001+\u0012\u0005\u0011:\u0003C\u0001\u000b&\u0013\t1SCA\u0004O_RD\u0017N\\4\u0011\u0005iA\u0013BA\u0015\u001c\u00051IE-\u001a8uS\u001aL\u0017M\u00197f\u0003)\u0011X\r]8tSR|'/\u001f\t\u000451z\u0012BA\u0017\u001c\u0005)\u0011V\r]8tSR|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0012\u0004cA\u0019\u0001?5\t!\u0002C\u0003+\u0005\u0001\u00071&F\u00015!\r)\u0004HO\u0007\u0002m)\u0011q'F\u0001\u0004e\u00164\u0017BA\u001d7\u000559V-Y6SK\u001a,'/\u001a8dKB!1\b\u0011\" \u001b\u0005a$BA\u001f?\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u007fU\t!bY8mY\u0016\u001cG/[8o\u0013\t\tEHA\u0004Ue&,W*\u00199\u0011\u0005\rSeB\u0001#I!\t)U#D\u0001G\u0015\t9\u0005#\u0001\u0004=e>|GOP\u0005\u0003\u0013V\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011*F\u0001\u000bS:4\u0018\r\\5eCR,GCA(X!\r\u0001&\u000bV\u0007\u0002#*\u0011Q(F\u0005\u0003'F\u0013aAR;ukJ,\u0007C\u0001\u000bV\u0013\t1VC\u0001\u0003V]&$\b\"\u0002-\u0005\u0001\u0004I\u0016\u0001B;sSN\u00042AW.C\u001b\u0005q\u0014B\u0001/?\u0005\r\u0019V-]\u0001\rM&tG-\u00118e\u0007\u0006\u001c\u0007.\u001a\u000b\u0003?\u000e\u00042\u0001\u0015*a!\r!\u0012mH\u0005\u0003EV\u0011aa\u00149uS>t\u0007\"\u00023\u0006\u0001\u0004\u0011\u0015aA;sSR\u0011aM\u001b\t\u0004!J;\u0007c\u0001.i?%\u0011\u0011N\u0010\u0002\u000b\u0013:$W\r_3e'\u0016\f\b\"\u0002-\u0007\u0001\u0004I\u0016\u0001\u00024j]\u0012$\"aX7\t\u000b\u0011<\u0001\u0019\u0001\"\u0015\u0005\u0019|\u0007\"\u0002-\t\u0001\u0004I\u0006")
public class WeakDataCache<T extends Identifiable>
implements DataCache<T> {
    private WeakReference<TrieMap<String, T>> cache;
    private final Repository<T> repository;
    private volatile boolean bitmap$0;

    private WeakReference<TrieMap<String, T>> cache$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.cache = WeakReference$.MODULE$.apply((Object)new TrieMap());
                this.bitmap$0 = true;
            }
        }
        return this.cache;
    }

    private WeakReference<TrieMap<String, T>> cache() {
        if (!this.bitmap$0) {
            return this.cache$lzycompute();
        }
        return this.cache;
    }

    @Override
    public Future<BoxedUnit> invalidate(Seq<String> uris) {
        Option option = this.cache().get();
        if (option instanceof Some) {
            TrieMap wr = (TrieMap)((Some)option).value();
            if (uris != null && uris.nonEmpty()) {
                uris.foreach((Function1 & Serializable)k -> wr.remove(k));
            }
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private Future<Option<T>> findAndCache(String uri) {
        return this.repository.find(uri).map((Function1 & Serializable)found -> {
            if (found.isDefined()) {
                ((TrieMap)this.cache().apply()).put((Object)uri, found.get());
            }
            return found;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<IndexedSeq<T>> findAndCache(Seq<String> uris) {
        TrieMap wr = (TrieMap)this.cache().apply();
        return this.repository.find(uris).map((Function1 & Serializable)found -> {
            found.foreach((Function1 & Serializable)it -> wr.put((Object)it.URI(), it));
            return found;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public Future<Option<T>> find(String uri) {
        Option option = this.cache().get();
        if (option instanceof Some) {
            TrieMap wr = (TrieMap)((Some)option).value();
            if (uri != null) {
                Option option2 = wr.get((Object)uri);
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    return Future$.MODULE$.successful((Object)some);
                }
                return this.findAndCache(uri);
            }
        }
        return this.findAndCache(uri);
    }

    @Override
    public Future<IndexedSeq<T>> find(Seq<String> uris) {
        Option option = this.cache().get();
        if (option instanceof Some) {
            TrieMap wr = (TrieMap)((Some)option).value();
            if (uris != null && uris.nonEmpty()) {
                ArrayBuffer found = new ArrayBuffer();
                Seq missing = (Seq)uris.flatMap((Function1 & Serializable)uri -> {
                    Option option = wr.get(uri);
                    if (option instanceof Some) {
                        Identifiable f = (Identifiable)((Some)option).value();
                        found.$plus$eq((Object)f);
                        return None$.MODULE$;
                    }
                    return new Some(uri);
                });
                if (missing.nonEmpty()) {
                    return this.findAndCache((Seq<String>)missing).map((Function1 & Serializable)items -> (ArrayBuffer)found.$plus$plus((IterableOnce)items), ExecutionContext.Implicits$.MODULE$.global());
                }
                return Future$.MODULE$.successful((Object)found);
            }
        }
        return this.findAndCache(uris);
    }

    public WeakDataCache(Repository<T> repository) {
        this.repository = repository;
        Repository.$init$(this);
    }
}

