/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import java.sql.PreparedStatement;
import java.time.LocalDate;
import net.revenj.Utils$;
import net.revenj.database.postgres.PostgresBuffer;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.database.postgres.converters.Converter;
import net.revenj.database.postgres.converters.DateConverter;
import net.revenj.database.postgres.converters.NumberConverter$;
import net.revenj.database.postgres.converters.PostgresTuple;
import org.postgresql.util.PGobject;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DateConverter$
implements Converter<LocalDate> {
    public static final DateConverter$ MODULE$ = new DateConverter$();
    private static final String dbName;
    private static IndexedSeq<LocalDate> net$revenj$database$postgres$converters$Converter$$emptyCollection;
    private static Some<IndexedSeq<LocalDate>> net$revenj$database$postgres$converters$Converter$$someEmptyCollection;
    private static IndexedSeq<Option<LocalDate>> net$revenj$database$postgres$converters$Converter$$emptyOptionCollection;
    private static Some<IndexedSeq<Option<LocalDate>>> net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection;

    static {
        Converter.$init$(MODULE$);
        dbName = "date";
    }

    @Override
    public Object parse(PostgresReader reader, int context) {
        return Converter.parse$(this, reader, context);
    }

    @Override
    public Option<LocalDate> parseOption(PostgresReader reader, int context) {
        return Converter.parseOption$(this, reader, context);
    }

    @Override
    public IndexedSeq<LocalDate> parseCollection(PostgresReader reader, int context) {
        return Converter.parseCollection$(this, reader, context);
    }

    @Override
    public IndexedSeq<Option<LocalDate>> parseNullableCollection(PostgresReader reader, int context) {
        return Converter.parseNullableCollection$(this, reader, context);
    }

    @Override
    public Option<IndexedSeq<LocalDate>> parseCollectionOption(PostgresReader reader, int context) {
        return Converter.parseCollectionOption$(this, reader, context);
    }

    @Override
    public Option<IndexedSeq<Option<LocalDate>>> parseNullableCollectionOption(PostgresReader reader, int context) {
        return Converter.parseNullableCollectionOption$(this, reader, context);
    }

    @Override
    public PostgresTuple toTuple(Option<LocalDate> value) {
        return Converter.toTuple$(this, value);
    }

    @Override
    public IndexedSeq<LocalDate> net$revenj$database$postgres$converters$Converter$$emptyCollection() {
        return net$revenj$database$postgres$converters$Converter$$emptyCollection;
    }

    @Override
    public Some<IndexedSeq<LocalDate>> net$revenj$database$postgres$converters$Converter$$someEmptyCollection() {
        return net$revenj$database$postgres$converters$Converter$$someEmptyCollection;
    }

    @Override
    public IndexedSeq<Option<LocalDate>> net$revenj$database$postgres$converters$Converter$$emptyOptionCollection() {
        return net$revenj$database$postgres$converters$Converter$$emptyOptionCollection;
    }

    @Override
    public Some<IndexedSeq<Option<LocalDate>>> net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection() {
        return net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection;
    }

    @Override
    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$emptyCollection_$eq(IndexedSeq<LocalDate> x$1) {
        net$revenj$database$postgres$converters$Converter$$emptyCollection = x$1;
    }

    @Override
    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$someEmptyCollection_$eq(Some<IndexedSeq<LocalDate>> x$1) {
        net$revenj$database$postgres$converters$Converter$$someEmptyCollection = x$1;
    }

    @Override
    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$emptyOptionCollection_$eq(IndexedSeq<Option<LocalDate>> x$1) {
        net$revenj$database$postgres$converters$Converter$$emptyOptionCollection = x$1;
    }

    @Override
    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection_$eq(Some<IndexedSeq<Option<LocalDate>>> x$1) {
        net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection = x$1;
    }

    @Override
    public void serializeURI(PostgresBuffer sw, LocalDate value) {
        this.net$revenj$database$postgres$converters$DateConverter$$serialize(sw.tempBuffer(), 0, value);
        sw.addToBuffer(sw.tempBuffer(), 10);
    }

    public void net$revenj$database$postgres$converters$DateConverter$$serialize(char[] buf, int start, LocalDate value) {
        int year = value.getYear();
        if (year > 9999) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Invalid year detected: ").append(value).append(". Only dates up to 9999-12-31 are allowed").toString());
        }
        NumberConverter$.MODULE$.write4(year, buf, start);
        buf[start + 4] = 45;
        NumberConverter$.MODULE$.write2(value.getMonthValue(), buf, start + 5);
        buf[start + 7] = 45;
        NumberConverter$.MODULE$.write2(value.getDayOfMonth(), buf, start + 8);
    }

    public void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, LocalDate value) {
        PGobject pg = new PGobject();
        pg.setType("date");
        char[] buf = sw.tempBuffer();
        this.net$revenj$database$postgres$converters$DateConverter$$serialize(buf, 0, value);
        pg.setValue(new String(buf, 0, 10));
        ps.setObject(index, pg);
    }

    @Override
    public String dbName() {
        return dbName;
    }

    @Override
    public LocalDate default() {
        return Utils$.MODULE$.MinLocalDate();
    }

    @Override
    public LocalDate parseRaw(PostgresReader reader, int start, int context) {
        return this.parseDate(reader, start);
    }

    private LocalDate parseDate(PostgresReader reader, int cur) {
        if (cur == 92 || cur == 34) {
            throw new RuntimeException("Negative dates are not yet implemented.");
        }
        char[] buf = reader.tmp();
        buf[0] = (char)cur;
        reader.fillTotal(buf, 1, 9);
        if (buf[4] != '-') {
            return this.parseDateSlow(buf, reader);
        }
        reader.read();
        return LocalDate.of(NumberConverter$.MODULE$.read4(buf, 0), NumberConverter$.MODULE$.read2(buf, 5), NumberConverter$.MODULE$.read2(buf, 8));
    }

    private LocalDate parseDateSlow(char[] buf, PostgresReader reader) {
        int foundAt;
        for (foundAt = 5; foundAt < buf.length && buf[foundAt] != '-'; ++foundAt) {
        }
        if (foundAt == buf.length || foundAt > buf.length - 2 && buf[foundAt + 3] != '-') {
            throw new RuntimeException(new StringBuilder(20).append("Invalid date value: ").append(new String(buf, 0, foundAt)).toString());
        }
        reader.fillTotal(buf, 10, foundAt - 4);
        reader.read();
        return LocalDate.of(NumberConverter$.MODULE$.parsePositive(buf, 0, foundAt), NumberConverter$.MODULE$.read2(buf, foundAt + 1), NumberConverter$.MODULE$.read2(buf, foundAt + 4));
    }

    @Override
    public LocalDate parseCollectionItem(PostgresReader reader, int context) {
        int cur = reader.read();
        if (cur == 78) {
            reader.read(4);
            return Utils$.MODULE$.MinLocalDate();
        }
        return this.parseDate(reader, cur);
    }

    @Override
    public Option<LocalDate> parseNullableCollectionItem(PostgresReader reader, int context) {
        int cur = reader.read();
        if (cur == 78) {
            reader.read(4);
            return None$.MODULE$;
        }
        return new Some((Object)this.parseDate(reader, cur));
    }

    @Override
    public PostgresTuple toTuple(LocalDate value) {
        return new DateConverter.LocalDateTuple(value);
    }

    private DateConverter$() {
    }
}

