/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import java.sql.PreparedStatement;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import net.revenj.database.postgres.PostgresBuffer;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.database.postgres.converters.NumberConverter$;
import org.postgresql.util.PGobject;

public final class TimestampConverter$ {
    public static final TimestampConverter$ MODULE$ = new TimestampConverter$();
    private static final LocalDateTime MIN_LOCAL_DATE_TIME = LocalDateTime.of(1, 1, 1, 0, 0, 0, 0);
    private static final OffsetDateTime net$revenj$database$postgres$converters$TimestampConverter$$MIN_DATE_TIME_UTC = OffsetDateTime.of(MODULE$.MIN_LOCAL_DATE_TIME(), ZoneOffset.UTC);
    private static final int[] TIMESTAMP_REMINDER = new int[]{100000, 10000, 1000, 100, 10, 1};
    private static final ZoneOffset ZERO_OFFSET = ZoneOffset.ofHoursMinutes(1, 22);

    private LocalDateTime MIN_LOCAL_DATE_TIME() {
        return MIN_LOCAL_DATE_TIME;
    }

    public OffsetDateTime net$revenj$database$postgres$converters$TimestampConverter$$MIN_DATE_TIME_UTC() {
        return net$revenj$database$postgres$converters$TimestampConverter$$MIN_DATE_TIME_UTC;
    }

    private int[] TIMESTAMP_REMINDER() {
        return TIMESTAMP_REMINDER;
    }

    public void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, OffsetDateTime value) {
        PGobject pg = new PGobject();
        pg.setType("timestamptz");
        char[] buf = sw.tempBuffer();
        int len = this.serialize(buf, 0, value);
        pg.setValue(new String(buf, 0, len));
        ps.setObject(index, pg);
    }

    private int serialize(char[] buffer, int pos, LocalDateTime value) {
        int year = value.getYear();
        if (year > 9999) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Invalid year detected: ").append(value).append(". Only dates up to 9999-12-31 are allowed").toString());
        }
        buffer[pos + 4] = 45;
        buffer[pos + 7] = 45;
        buffer[pos + 10] = 32;
        buffer[pos + 13] = 58;
        buffer[pos + 16] = 58;
        NumberConverter$.MODULE$.write4(year, buffer, pos);
        NumberConverter$.MODULE$.write2(value.getMonthValue(), buffer, pos + 5);
        NumberConverter$.MODULE$.write2(value.getDayOfMonth(), buffer, pos + 8);
        NumberConverter$.MODULE$.write2(value.getHour(), buffer, pos + 11);
        NumberConverter$.MODULE$.write2(value.getMinute(), buffer, pos + 14);
        NumberConverter$.MODULE$.write2(value.getSecond(), buffer, pos + 17);
        int micro = value.getNano() / 1000;
        int end = pos + 19;
        if (micro != 0) {
            buffer[pos + 19] = 46;
            int div = micro / 100;
            int rem = micro - div * 100;
            NumberConverter$.MODULE$.write4(div, buffer, 20);
            NumberConverter$.MODULE$.write2(rem, buffer, 24);
            end = pos + 25;
            while (buffer[end] == '0') {
                --end;
            }
            ++end;
        }
        buffer[end] = 43;
        buffer[end + 1] = 48;
        buffer[end + 2] = 48;
        return end + 3;
    }

    private ZoneOffset ZERO_OFFSET() {
        return ZERO_OFFSET;
    }

    public int serialize(char[] buffer, int start, OffsetDateTime value) {
        int offset = value.getOffset().getTotalSeconds();
        if (value.getYear() < 1884) {
            LocalDateTime at122 = value.toLocalDateTime().plusSeconds(this.ZERO_OFFSET().getTotalSeconds() - offset);
            int pos = this.serialize(buffer, start, at122);
            buffer[pos - 1] = 49;
            buffer[pos] = 58;
            buffer[pos + 1] = 50;
            buffer[pos + 2] = 50;
            return pos + 3;
        }
        int offsetHours = offset / 3600;
        int offsetDiff = offset - offsetHours * 3600;
        if (offsetDiff != 0) {
            return this.serializeNormalized(buffer, start, value.toLocalDateTime().minusSeconds(offsetDiff), offsetHours);
        }
        return this.serializeNormalized(buffer, start, value.toLocalDateTime(), offsetHours);
    }

    private int serializeNormalized(char[] buffer, int pos, LocalDateTime value, int offsetHours) {
        int year = value.getYear();
        if (year > 9999) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Invalid year detected: ").append(value).append(". Only dates up to 9999-12-31 are allowed").toString());
        }
        buffer[pos + 4] = 45;
        buffer[pos + 7] = 45;
        buffer[pos + 10] = 32;
        buffer[pos + 13] = 58;
        buffer[pos + 16] = 58;
        NumberConverter$.MODULE$.write4(year, buffer, pos);
        NumberConverter$.MODULE$.write2(value.getMonthValue(), buffer, pos + 5);
        NumberConverter$.MODULE$.write2(value.getDayOfMonth(), buffer, pos + 8);
        NumberConverter$.MODULE$.write2(value.getHour(), buffer, pos + 11);
        NumberConverter$.MODULE$.write2(value.getMinute(), buffer, pos + 14);
        NumberConverter$.MODULE$.write2(value.getSecond(), buffer, pos + 17);
        int micro = value.getNano() / 1000;
        int end = pos + 19;
        if (micro != 0) {
            buffer[pos + 19] = 46;
            int div = micro / 100;
            int rem = micro - div * 100;
            NumberConverter$.MODULE$.write4(div, buffer, 20);
            NumberConverter$.MODULE$.write2(rem, buffer, 24);
            end = pos + 25;
            while (buffer[end] == '0') {
                --end;
            }
            ++end;
        }
        if (offsetHours >= 0) {
            buffer[end] = 43;
            NumberConverter$.MODULE$.write2(offsetHours, buffer, end + 1);
        } else {
            buffer[end] = 45;
            NumberConverter$.MODULE$.write2(-offsetHours, buffer, end + 1);
        }
        return end + 3;
    }

    public OffsetDateTime net$revenj$database$postgres$converters$TimestampConverter$$parseOffsetTimestamp(PostgresReader reader, int context, boolean asUtc) {
        int cur = reader.read(context);
        char[] buf = reader.tmp();
        buf[0] = (char)cur;
        int len = reader.fillUntil(buf, 1, '\\', '\"') + 1;
        reader.read(context + 1);
        if (buf[10] != ' ') {
            int foundAt;
            for (foundAt = 11; foundAt < buf.length && buf[foundAt] != ' '; ++foundAt) {
            }
            if (foundAt == buf.length) {
                throw new RuntimeException(new StringBuilder(25).append("Invalid timestamp value: ").append(new String(buf, 0, foundAt)).toString());
            }
            buf[foundAt] = 84;
            return OffsetDateTime.parse(new StringBuilder(1).append("+").append(new String(buf, 0, len)).toString());
        }
        int year = NumberConverter$.MODULE$.read4(buf, 0);
        int month = NumberConverter$.MODULE$.read2(buf, 5);
        int date = NumberConverter$.MODULE$.read2(buf, 8);
        int hour = NumberConverter$.MODULE$.read2(buf, 11);
        int minutes = NumberConverter$.MODULE$.read2(buf, 14);
        int seconds = NumberConverter$.MODULE$.read2(buf, 17);
        if (buf[19] == '.') {
            boolean pos;
            int nano = 0;
            int max = len - 3;
            int offsetSeconds = NumberConverter$.MODULE$.read2(buf, len - 2);
            if (buf[max] == ':') {
                offsetSeconds = NumberConverter$.MODULE$.read2(buf, len - 5) * 60 + offsetSeconds;
                if (buf[max -= 3] == ':') {
                    max -= 3;
                    offsetSeconds = NumberConverter$.MODULE$.read2(buf, len - 8) * 3600 + offsetSeconds;
                } else {
                    offsetSeconds *= 60;
                }
            } else {
                offsetSeconds *= 3600;
            }
            int i = 20;
            for (int r = 0; i < max && r < this.TIMESTAMP_REMINDER().length; ++i, ++r) {
                nano += this.TIMESTAMP_REMINDER()[r] * (buf[i] - 48);
            }
            boolean bl = pos = buf[max] == '+';
            if (asUtc) {
                return OffsetDateTime.of(year, month, date, hour, minutes, seconds, nano * 1000, ZoneOffset.UTC).plusSeconds(pos ? -offsetSeconds : offsetSeconds);
            }
            if (offsetSeconds != 0) {
                return OffsetDateTime.of(year, month, date, hour, minutes, seconds, nano * 1000, ZoneOffset.ofTotalSeconds(pos ? offsetSeconds : -offsetSeconds));
            }
            return OffsetDateTime.of(year, month, date, hour, minutes, seconds, nano * 1000, ZoneOffset.UTC);
        }
        if (len == 20 && buf[19] == 'Z') {
            return OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.UTC);
        }
        if (len == 22) {
            boolean pos = buf[19] == '+';
            int offset = NumberConverter$.MODULE$.read2(buf, 20);
            if (asUtc) {
                return OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.UTC).plusHours(pos ? -offset : offset);
            }
            if (offset != 0) {
                return OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.ofHours(pos ? offset : -offset));
            }
            return OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.UTC);
        }
        if (len == 25) {
            boolean pos = buf[19] == '+';
            int offsetSeconds = NumberConverter$.MODULE$.read2(buf, 20) * 3600 + NumberConverter$.MODULE$.read2(buf, 23) * 60;
            if (asUtc) {
                return OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.UTC).plusSeconds(pos ? -offsetSeconds : offsetSeconds);
            }
            return OffsetDateTime.of(year, month, date, hour, minutes, seconds, 0, ZoneOffset.ofTotalSeconds(pos ? offsetSeconds : -offsetSeconds));
        }
        buf[10] = 84;
        return OffsetDateTime.parse(new String(buf, 0, len));
    }

    private TimestampConverter$() {
    }
}

