/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import java.io.Serializable;
import net.revenj.database.postgres.PostgresWriter;
import net.revenj.database.postgres.converters.PostgresTuple;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class PostgresTuple$ {
    public static final PostgresTuple$ MODULE$;
    private static final TrieMap<String, String> quoteEscape;
    private static final String[] slashes;
    private static final PostgresTuple NULL;
    private static final ThreadLocal<PostgresWriter> threadWriter;
    private static final Option<Function2<PostgresWriter, Object, BoxedUnit>> QUOTES;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new PostgresTuple$();
        quoteEscape = new TrieMap();
        Object[] arr = new String[20];
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps(arr)).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> PostgresTuple$.$anonfun$slashes$1((String[])arr, arg_0)));
        slashes = var0;
        NULL = new PostgresTuple.NullTuple();
        threadWriter = new ThreadLocal<PostgresWriter>(){

            public PostgresWriter initialValue() {
                return new PostgresWriter();
            }
        };
        QUOTES = new Some((Function2 & Serializable)(sw, c) -> {
            PostgresTuple$.MODULE$.escapeQuote(sw, BoxesRunTime.unboxToChar((Object)c));
            return BoxedUnit.UNIT;
        });
    }

    private TrieMap<String, String> quoteEscape() {
        return quoteEscape;
    }

    private String[] slashes() {
        return slashes;
    }

    public Function2<String, PostgresWriter, BoxedUnit> prepareMapping(Option<Function2<PostgresWriter, Object, BoxedUnit>> mappings) {
        if (mappings.isDefined()) {
            return (arg_0, arg_1) -> PostgresTuple$.$anonfun$prepareMapping$1$adapted((Function2)mappings.get(), arg_0, arg_1);
        }
        return (Function2 & Serializable)(quote, sw) -> {
            PostgresTuple$.MODULE$.noQuoting(quote, sw);
            return BoxedUnit.UNIT;
        };
    }

    private void quoteMapping(Function2<PostgresWriter, Object, BoxedUnit> mapping, String quote, PostgresWriter sw) {
        for (int x = 0; x < quote.length(); ++x) {
            mapping.apply((Object)sw, (Object)BoxesRunTime.boxToCharacter((char)quote.charAt(x)));
        }
    }

    private void noQuoting(String quote, PostgresWriter sw) {
        sw.write(quote);
    }

    public String buildNextEscape(String input, char next) {
        StringBuilder sb = new StringBuilder(input.length() + 1);
        sb.append(input);
        sb.append(next);
        return sb.toString();
    }

    public PostgresTuple NULL() {
        return NULL;
    }

    public ThreadLocal<PostgresWriter> threadWriter() {
        return threadWriter;
    }

    public Option<Function2<PostgresWriter, Object, BoxedUnit>> QUOTES() {
        return QUOTES;
    }

    public void escapeQuote(PostgresWriter sw, char c) {
        if (c == '\'') {
            sw.write('\'');
        }
        sw.write(c);
    }

    public void escapeBulkCopy(PostgresWriter sw, char c) {
        switch (c) {
            case '\\': {
                sw.write("\\\\");
                return;
            }
            case '\t': {
                sw.write("\\t");
                return;
            }
            case '\n': {
                sw.write("\\n");
                return;
            }
            case '\r': {
                sw.write("\\r");
                return;
            }
            case '\u000b': {
                sw.write("\\v");
                return;
            }
            case '\b': {
                sw.write("\\b");
                return;
            }
            case '\f': {
                sw.write("\\f");
                return;
            }
        }
        sw.write(c);
    }

    public String buildQuoteEscape(String escaping) {
        return (String)this.quoteEscape().getOrElseUpdate((Object)escaping, (Function0 & Serializable)() -> {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            for (int j = escaping.length() - 1; j >= 0; --j) {
                if (escaping.charAt(j) == '1') {
                    int len = sb.length();
                    for (int i = 0; i < len; ++i) {
                        sb.insert(i * 2, sb.charAt(i * 2));
                    }
                    continue;
                }
                sb = new StringBuilder(sb.toString().replace("\\", "\\\\").replace("\"", "\\\""));
            }
            return sb.toString();
        });
    }

    public String buildSlashEscape(int len) {
        if (len < this.slashes().length) {
            return this.slashes()[len];
        }
        return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\\"), 1 << len);
    }

    public static final /* synthetic */ void $anonfun$slashes$1(String[] arr$1, int i) {
        arr$1[i] = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\\"), 1 << i);
    }

    private PostgresTuple$() {
    }

    public static final /* synthetic */ Object $anonfun$prepareMapping$1$adapted(Function2 eta$0$1$1, String quote, PostgresWriter sw) {
        PostgresTuple$.MODULE$.quoteMapping((Function2<PostgresWriter, Object, BoxedUnit>)eta$0$1$1, quote, sw);
        return BoxedUnit.UNIT;
    }
}

