/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import java.io.Serializable;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.database.postgres.converters.ArrayTuple;
import net.revenj.database.postgres.converters.PostgresTuple;
import net.revenj.database.postgres.converters.PostgresTuple$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.concurrent.TrieMap;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ArrayTuple$ {
    public static final ArrayTuple$ MODULE$ = new ArrayTuple$();
    private static final PostgresTuple EMPTY = new ArrayTuple.EmptyArrayTuple();
    private static final PostgresTuple NULL = new ArrayTuple.NullTuple();
    private static final TrieMap<String, String> escapingCache = new TrieMap();
    private static final Some<IndexedSeq<Nothing$>> someEmptyCollection = new Some((Object)IndexedSeq$.MODULE$.empty());
    private static final Some<IndexedSeq<Option<Nothing$>>> someEmptyOptionCollection = new Some((Object)IndexedSeq$.MODULE$.empty());

    public PostgresTuple EMPTY() {
        return EMPTY;
    }

    public PostgresTuple NULL() {
        return NULL;
    }

    private TrieMap<String, String> escapingCache() {
        return escapingCache;
    }

    public String nextEscape(String input) {
        if (input.length() < 16) {
            return (String)this.escapingCache().getOrElseUpdate((Object)input, (Function0 & Serializable)() -> PostgresTuple$.MODULE$.buildNextEscape(input, '0'));
        }
        return PostgresTuple$.MODULE$.buildNextEscape(input, '0');
    }

    public PostgresTuple apply(PostgresTuple[] elements) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.length == 0) {
            return this.EMPTY();
        }
        return new ArrayTuple(elements);
    }

    public <T> PostgresTuple createIndexed(IndexedSeq<T> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            tuples[i] = (PostgresTuple)converter.apply(elements.apply(i));
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createIndexedOption(IndexedSeq<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            Option option = (Option)elements.apply(i);
            if (option instanceof Some) {
                Object el = ((Some)option).value();
                tuples[i] = (PostgresTuple)converter.apply(el);
                continue;
            }
            tuples[i] = PostgresTuple$.MODULE$.NULL();
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createSeq(Seq<T> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            tuples[i] = (PostgresTuple)converter.apply(it.next());
            ++i;
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createSeqOption(Seq<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        for (Option option : elements) {
            if (option instanceof Some) {
                Object el = ((Some)option).value();
                tuples[i] = (PostgresTuple)converter.apply(el);
            } else {
                tuples[i] = PostgresTuple$.MODULE$.NULL();
            }
            ++i;
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createSet(Set<T> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            tuples[i] = (PostgresTuple)converter.apply(it.next());
            ++i;
        }
        return new ArrayTuple(tuples);
    }

    public <T> PostgresTuple createSetOption(Set<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        if (elements == null) {
            return this.NULL();
        }
        if (elements.isEmpty()) {
            return this.EMPTY();
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        for (Option option : elements) {
            if (option instanceof Some) {
                Object el = ((Some)option).value();
                tuples[i] = (PostgresTuple)converter.apply(el);
            } else {
                tuples[i] = PostgresTuple$.MODULE$.NULL();
            }
            ++i;
        }
        return new ArrayTuple(tuples);
    }

    private Some<IndexedSeq<Nothing$>> someEmptyCollection() {
        return someEmptyCollection;
    }

    private Some<IndexedSeq<Option<Nothing$>>> someEmptyOptionCollection() {
        return someEmptyOptionCollection;
    }

    public <T> Option<IndexedSeq<T>> parse(PostgresReader reader, int context, Function2<PostgresReader, Object, T> converter, Function0<T> function0) {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return None$.MODULE$;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return this.someEmptyCollection();
        }
        ArrayBuffer result = new ArrayBuffer(4);
        int arrayContext = Math.max(context << 1, 1);
        int recordContext = arrayContext << 1;
        while (cur != -1 && cur != 125) {
            boolean innerEscaped;
            cur = reader.read();
            if (cur == 78) {
                cur = reader.read(4);
                result.$plus$eq(function0.apply());
                continue;
            }
            boolean bl2 = innerEscaped = cur != 40;
            if (innerEscaped) {
                reader.read(arrayContext);
            }
            result.$plus$eq(converter.apply((Object)reader, (Object)BoxesRunTime.boxToInteger((int)recordContext)));
            if (innerEscaped) {
                cur = reader.read(arrayContext + 1);
                continue;
            }
            cur = reader.read();
        }
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return new Some((Object)result);
    }

    public <T> Option<IndexedSeq<Option<T>>> parseOption(PostgresReader reader, int context, Function2<PostgresReader, Object, T> converter) {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return None$.MODULE$;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return this.someEmptyOptionCollection();
        }
        ArrayBuffer result = new ArrayBuffer(4);
        int arrayContext = Math.max(context << 1, 1);
        int recordContext = arrayContext << 1;
        while (cur != -1 && cur != 125) {
            boolean innerEscaped;
            cur = reader.read();
            if (cur == 78) {
                cur = reader.read(4);
                result.$plus$eq((Object)None$.MODULE$);
                continue;
            }
            boolean bl2 = innerEscaped = cur != 40;
            if (innerEscaped) {
                reader.read(arrayContext);
            }
            result.$plus$eq((Object)new Some(converter.apply((Object)reader, (Object)BoxesRunTime.boxToInteger((int)recordContext))));
            if (innerEscaped) {
                cur = reader.read(arrayContext + 1);
                continue;
            }
            cur = reader.read();
        }
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return new Some((Object)result);
    }

    private ArrayTuple$() {
    }
}

