/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.revenj.TreePath;
import net.revenj.TreePath$;
import scala.Predef$;
import scala.collection.StringOps$;

public final class JacksonSerialization$ {
    public static final JacksonSerialization$ MODULE$ = new JacksonSerialization$();

    /*
     * WARNING - void declaration
     */
    public SimpleModule net$revenj$serialization$JacksonSerialization$$withCustomSerializers() {
        void var1_1;
        SimpleModule module = new SimpleModule();
        module.addSerializer(Point.class, (JsonSerializer)new JsonSerializer<Point>(){

            public void serialize(Point value, JsonGenerator jg, SerializerProvider unused) {
                jg.writeStartObject();
                jg.writeNumberField("X", value.x);
                jg.writeNumberField("Y", value.y);
                jg.writeEndObject();
            }
        });
        module.addSerializer(Point2D.class, (JsonSerializer)new JsonSerializer<Point2D>(){

            public void serialize(Point2D value, JsonGenerator jg, SerializerProvider unused) {
                jg.writeStartObject();
                jg.writeNumberField("X", value.getX());
                jg.writeNumberField("Y", value.getY());
                jg.writeEndObject();
            }
        });
        module.addSerializer(Rectangle2D.class, (JsonSerializer)new JsonSerializer<Rectangle2D>(){

            public void serialize(Rectangle2D rect, JsonGenerator jg, SerializerProvider unused) {
                jg.writeStartObject();
                jg.writeNumberField("X", rect.getX());
                jg.writeNumberField("Y", rect.getY());
                jg.writeNumberField("Width", rect.getWidth());
                jg.writeNumberField("Height", rect.getHeight());
                jg.writeEndObject();
            }
        });
        module.addSerializer(BufferedImage.class, (JsonSerializer)new JsonSerializer<BufferedImage>(){

            public void serialize(BufferedImage image, JsonGenerator jg, SerializerProvider unused) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", baos);
                jg.writeBinary(baos.toByteArray());
            }
        });
        module.addSerializer(TreePath.class, (JsonSerializer)new JsonSerializer<TreePath>(){

            public void serialize(TreePath path, JsonGenerator jg, SerializerProvider unused) {
                jg.writeString(path.toString());
            }
        });
        module.addDeserializer(Point.class, (JsonDeserializer)new JsonDeserializer<Point>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Point deserialize(JsonParser parser, DeserializationContext unused) {
                Point point;
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    String[] parts = parser.getValueAsString().split(",");
                    if (parts.length != 2) throw new IOException("Unable to parse \"number,number\" format for point");
                    point = new Point(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parts[0])), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parts[1])));
                    return point;
                } else {
                    JsonNode y;
                    JsonNode tree = (JsonNode)parser.getCodec().readTree(parser);
                    JsonNode x = tree.get("X");
                    if (x == null) {
                        x = tree.get("x");
                    }
                    if ((y = tree.get("Y")) == null) {
                        y = tree.get("y");
                    }
                    point = new Point(x != null ? x.asInt() : 0, y != null ? y.asInt() : 0);
                }
                return point;
            }
        });
        module.addDeserializer(Point2D.class, (JsonDeserializer)new JsonDeserializer<Point2D>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Point2D deserialize(JsonParser parser, DeserializationContext unused) {
                Point2D.Double double_;
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    String[] parts = parser.getValueAsString().split(",");
                    if (parts.length != 2) throw new IOException("Unable to parse \"number,number\" format for point");
                    double_ = new Point2D.Double(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(parts[0])), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(parts[1])));
                    return double_;
                } else {
                    JsonNode y;
                    JsonNode tree = (JsonNode)parser.getCodec().readTree(parser);
                    JsonNode x = tree.get("X");
                    if (x == null) {
                        x = tree.get("x");
                    }
                    if ((y = tree.get("Y")) == null) {
                        y = tree.get("y");
                    }
                    double_ = new Point2D.Double(x != null ? x.asDouble() : 0.0, y != null ? y.asDouble() : 0.0);
                }
                return double_;
            }
        });
        module.addDeserializer(Rectangle2D.class, (JsonDeserializer)new JsonDeserializer<Rectangle2D>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Rectangle2D deserialize(JsonParser parser, DeserializationContext unused) {
                Rectangle2D.Double double_;
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    String[] parts = parser.getValueAsString().split(",");
                    if (parts.length != 4) throw new IOException("Unable to parse \"number,number,number,number\" format for rectangle");
                    double_ = new Rectangle2D.Double(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(parts[0])), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(parts[1])), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(parts[2])), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(parts[3])));
                    return double_;
                } else {
                    JsonNode height;
                    JsonNode width;
                    JsonNode y;
                    JsonNode tree = (JsonNode)parser.getCodec().readTree(parser);
                    JsonNode x = tree.get("X");
                    if (x == null) {
                        x = tree.get("x");
                    }
                    if ((y = tree.get("Y")) == null) {
                        y = tree.get("y");
                    }
                    if ((width = tree.get("Width")) == null) {
                        width = tree.get("width");
                    }
                    if ((height = tree.get("Height")) == null) {
                        height = tree.get("height");
                    }
                    double_ = new Rectangle2D.Double(x != null ? x.asDouble() : 0.0, y != null ? y.asDouble() : 0.0, width != null ? width.asDouble() : 0.0, height != null ? height.asDouble() : 0.0);
                }
                return double_;
            }
        });
        module.addDeserializer(BufferedImage.class, (JsonDeserializer)new JsonDeserializer<BufferedImage>(){

            public BufferedImage deserialize(JsonParser parser, DeserializationContext unused) {
                ByteArrayInputStream is = new ByteArrayInputStream(parser.getBinaryValue());
                return ImageIO.read(is);
            }
        });
        module.addDeserializer(TreePath.class, (JsonDeserializer)new JsonDeserializer<TreePath>(){

            public TreePath deserialize(JsonParser parser, DeserializationContext unused) {
                return TreePath$.MODULE$.create(parser.getValueAsString());
            }
        });
        return var1_1;
    }

    private JacksonSerialization$() {
    }
}

