/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import java.io.IOException;
import net.revenj.database.postgres.PostgresBuffer;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.database.postgres.converters.Converter;
import net.revenj.database.postgres.converters.PostgresTuple;
import net.revenj.database.postgres.converters.ValueTuple$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class StringConverter$
implements Converter<String> {
    public static final StringConverter$ MODULE$ = new StringConverter$();
    private static final String dbName;
    private static IndexedSeq<String> net$revenj$database$postgres$converters$Converter$$emptyCollection;
    private static Some<IndexedSeq<String>> net$revenj$database$postgres$converters$Converter$$someEmptyCollection;
    private static IndexedSeq<Option<String>> net$revenj$database$postgres$converters$Converter$$emptyOptionCollection;
    private static Some<IndexedSeq<Option<String>>> net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection;

    static {
        Converter.$init$(MODULE$);
        dbName = "varchar";
    }

    @Override
    public Object parse(PostgresReader reader, int context) {
        return Converter.parse$(this, reader, context);
    }

    @Override
    public Option<String> parseOption(PostgresReader reader, int context) {
        return Converter.parseOption$(this, reader, context);
    }

    @Override
    public IndexedSeq<String> parseCollection(PostgresReader reader, int context) {
        return Converter.parseCollection$(this, reader, context);
    }

    @Override
    public IndexedSeq<Option<String>> parseNullableCollection(PostgresReader reader, int context) {
        return Converter.parseNullableCollection$(this, reader, context);
    }

    @Override
    public Option<IndexedSeq<String>> parseCollectionOption(PostgresReader reader, int context) {
        return Converter.parseCollectionOption$(this, reader, context);
    }

    @Override
    public Option<IndexedSeq<Option<String>>> parseNullableCollectionOption(PostgresReader reader, int context) {
        return Converter.parseNullableCollectionOption$(this, reader, context);
    }

    @Override
    public PostgresTuple toTuple(Option<String> value) {
        return Converter.toTuple$(this, value);
    }

    @Override
    public IndexedSeq<String> net$revenj$database$postgres$converters$Converter$$emptyCollection() {
        return net$revenj$database$postgres$converters$Converter$$emptyCollection;
    }

    @Override
    public Some<IndexedSeq<String>> net$revenj$database$postgres$converters$Converter$$someEmptyCollection() {
        return net$revenj$database$postgres$converters$Converter$$someEmptyCollection;
    }

    @Override
    public IndexedSeq<Option<String>> net$revenj$database$postgres$converters$Converter$$emptyOptionCollection() {
        return net$revenj$database$postgres$converters$Converter$$emptyOptionCollection;
    }

    @Override
    public Some<IndexedSeq<Option<String>>> net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection() {
        return net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection;
    }

    @Override
    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$emptyCollection_$eq(IndexedSeq<String> x$1) {
        net$revenj$database$postgres$converters$Converter$$emptyCollection = x$1;
    }

    @Override
    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$someEmptyCollection_$eq(Some<IndexedSeq<String>> x$1) {
        net$revenj$database$postgres$converters$Converter$$someEmptyCollection = x$1;
    }

    @Override
    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$emptyOptionCollection_$eq(IndexedSeq<Option<String>> x$1) {
        net$revenj$database$postgres$converters$Converter$$emptyOptionCollection = x$1;
    }

    @Override
    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection_$eq(Some<IndexedSeq<Option<String>>> x$1) {
        net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection = x$1;
    }

    @Override
    public void serializeURI(PostgresBuffer sw, String value) {
        block0: {
            if (value == null) break block0;
            sw.addToBuffer(value);
        }
    }

    public void serializeCompositeURI(PostgresBuffer sw, String value) {
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\\' || c == '/') {
                    sw.addToBuffer('\\');
                }
                sw.addToBuffer(c);
            }
        }
    }

    @Override
    public String dbName() {
        return dbName;
    }

    @Override
    public String default() {
        return "";
    }

    public void skip(PostgresReader reader, int context) {
        int cur = reader.read();
        if (cur != 44 && cur != 41) {
            if (cur != 34 && cur != 92) {
                reader.initBuffer();
                reader.fillUntil(',', ')');
                reader.read();
            } else {
                cur = reader.read(context);
                while (cur >= 0) {
                    if (cur == 92 || cur == 34) {
                        cur = reader.read(context);
                        if (cur == 44 || cur == 41) {
                            cur = -2;
                            continue;
                        }
                        cur = reader.read(context);
                        continue;
                    }
                    cur = reader.read();
                }
                if (cur == -1) {
                    throw new IOException("Unable to find end of string");
                }
            }
        }
    }

    @Override
    public String parseRaw(PostgresReader reader, int start, int context) {
        String string;
        if (start != 34 && start != 92) {
            reader.initBuffer((char)start);
            reader.fillUntil(',', ')');
            reader.read();
            string = reader.bufferToString();
        } else {
            string = this.parseEscapedString(reader, context, ')');
        }
        return string;
    }

    public String parseEscapedString(PostgresReader reader, int context, char matchEnd) {
        int cur = reader.read(context);
        reader.initBuffer();
        do {
            if (cur == 92 || cur == 34) {
                cur = reader.read(context);
                if (cur == 44 || cur == matchEnd) {
                    return reader.bufferToString();
                }
                for (int i = 0; i < context - 1; ++i) {
                    cur = reader.read();
                }
            }
            reader.addToBuffer((char)cur);
            reader.fillUntil('\\', '\"');
            cur = reader.read();
        } while (cur != -1);
        throw new IOException("Unable to find end of string");
    }

    @Override
    public String parseCollectionItem(PostgresReader reader, int context) {
        String string;
        int cur = reader.read();
        if (cur == 34 || cur == 92) {
            string = this.parseEscapedString(reader, context, '}');
        } else {
            reader.initBuffer((char)cur);
            reader.fillUntil(',', '}');
            reader.read();
            string = reader.bufferMatches("NULL") ? "" : reader.bufferToString();
        }
        return string;
    }

    @Override
    public Option<String> parseNullableCollectionItem(PostgresReader reader, int context) {
        Object object;
        int cur = reader.read();
        if (cur == 34 || cur == 92) {
            object = new Some((Object)this.parseEscapedString(reader, context, '}'));
        } else {
            reader.initBuffer((char)cur);
            reader.fillUntil(',', '}');
            reader.read();
            object = reader.bufferMatches("NULL") ? None$.MODULE$ : new Some((Object)reader.bufferToString());
        }
        return object;
    }

    @Override
    public PostgresTuple toTuple(String value) {
        return ValueTuple$.MODULE$.from(value);
    }

    private StringConverter$() {
    }
}

